# Generated by default/object.tt
package Paws::LexRuntimeV2::IntentResultEvent;
  use Moose;
  has EventId => (is => 'ro', isa => 'Str', request_name => 'eventId', traits => ['NameInRequest']);
  has InputMode => (is => 'ro', isa => 'Str', request_name => 'inputMode', traits => ['NameInRequest']);
  has Interpretations => (is => 'ro', isa => 'ArrayRef[Paws::LexRuntimeV2::Interpretation]', request_name => 'interpretations', traits => ['NameInRequest']);
  has RequestAttributes => (is => 'ro', isa => 'Paws::LexRuntimeV2::StringMap', request_name => 'requestAttributes', traits => ['NameInRequest']);
  has SessionId => (is => 'ro', isa => 'Str', request_name => 'sessionId', traits => ['NameInRequest']);
  has SessionState => (is => 'ro', isa => 'Paws::LexRuntimeV2::SessionState', request_name => 'sessionState', traits => ['NameInRequest']);

1;

### main pod documentation begin ###

=head1 NAME

Paws::LexRuntimeV2::IntentResultEvent

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::LexRuntimeV2::IntentResultEvent object:

  $service_obj->Method(Att1 => { EventId => $value, ..., SessionState => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::LexRuntimeV2::IntentResultEvent object:

  $result = $service_obj->Method(...);
  $result->Att1->EventId

=head1 DESCRIPTION

Contains the current state of the conversation between the client
application and Amazon Lex V2.

=head1 ATTRIBUTES


=head2 EventId => Str

A unique identifier of the event sent by Amazon Lex V2. The identifier
is in the form C<RESPONSE-N>, where N is a number starting with one and
incremented for each event sent by Amazon Lex V2 in the current
session.


=head2 InputMode => Str

Indicates whether the input to the operation was text or speech.


=head2 Interpretations => ArrayRef[L<Paws::LexRuntimeV2::Interpretation>]

A list of intents that Amazon Lex V2 determined might satisfy the
user's utterance.

Each interpretation includes the intent, a score that indicates how
confident Amazon Lex V2 is that the interpretation is the correct one,
and an optional sentiment response that indicates the sentiment
expressed in the utterance.


=head2 RequestAttributes => L<Paws::LexRuntimeV2::StringMap>

The attributes sent in the request.


=head2 SessionId => Str

The identifier of the session in use.


=head2 SessionState => L<Paws::LexRuntimeV2::SessionState>





=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::LexRuntimeV2>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

