use strict;
use warnings;

use Test::More tests => 6;

use Time::C;

my $t = Time::C->from_string('2016-09-23T04:28:30Z');
isa_ok($t, "Time::C");

is ($t->string, "2016-09-23T04:28:30Z", 'initial time correct');

# 2016-01-01T04:28:30Z
$t->month = $t->day = 1;
is ($t->string, "2016-01-01T04:28:30Z", 'setting month and day to 1 correct');
 
# 2016-01-01T00:00:00Z
$t->hour = $t->minute = $t->second = 0;
is ($t->string, "2016-01-01T00:00:00Z", 'setting hour, minute, second to 0 correct');
 
# 2016-02-04T00:00:00Z
$t->month += 1; $t->day += 3;
is ($t->string, "2016-02-04T00:00:00Z", 'increasing month by 1 and day by 3 correct');
 
# 2016-03-03T00:00:00Z
$t->day += 28;
is ($t->string, "2016-03-03T00:00:00Z", 'increasing day by 28 correct');
