package Locales::DB::Territory::ee;

use strict;
use warnings;

# Auto generated from CLDR
use if $Locales::_UNICODE_STRINGS, 'utf8';

$Locales::DB::Territory::ee::VERSION = '0.09';

$Locales::DB::Territory::ee::cldr_version = '2.0';

%Locales::DB::Territory::ee::code_to_name = (
    '001' => 'xexeme',
    '002' => "Afrika\ nutome",
    '003' => "Dziehe\ Amerika\ nutome",
    '005' => "Anyiehe\ Amerika\ nutome",
    '009' => "Oceania\ nutome",
    '011' => "Ɣetoɖoƒelɔƒo\ Afrika\ nutome",
    '013' => "Titina\ Amerika\ nutome",
    '014' => "Ɣedzeƒe\ Afrika\ nutome",
    '015' => "Dziehe\ Afrika\ nutome",
    '017' => "Titina\ Afrika\ nutome",
    '018' => "Anyiehelɔƒo\ Afrika\ nutome",
    '019' => "Amerika\ nutome",
    '021' => "Dziehelɔƒo\ Amerika\ nutome",
    '029' => "Karibbea\ nutome",
    '030' => "Ɣedzeƒe\ Asia\ nutome",
    '034' => "Anyiehelɔƒo\ Asia\ nutome",
    '035' => "Anyiehe\ Ɣedzeƒe\ Afrika\ nutome",
    '039' => "Anyiehelɔƒo\ Europa\ nutome",
    '053' => "Australia\ kple\ New\ Zealand\ nutome",
    '054' => "Melanesia\ nutome",
    '057' => 'Mikronesia',
    '061' => "Pɔlinesia\ nutome",
    '062' => "South\-Central\ Asia",
    142   => "Asia\ nutome",
    143   => "Titina\ Asia\ nutome",
    145   => "Ɣetoɖoƒelɔƒo\ Asia\ nutome",
    150   => "Europa\ nutome",
    151   => "Ɣedzeƒe\ Europa\ nutome",
    154   => "Dziehelɔƒo\ Europa\ nutome",
    155   => "Ɣetoɖoƒelɔƒo\ Europa\ nutome",
    172   => "Commonwealth\ of\ Independent\ States",
    200   => 'Czechoslovakia',
    419   => "Latin\ Amerika\ nutome",
    830   => "Channel\ Islands",
    'ac'  => "Ascension\ ƒudomekpo\ nutome",
    'ad'  => "Andorra\ nutome",
    'ae'  => "United\ Arab\ Emirates\ nutome",
    'af'  => "Afghanistan\ nutome",
    'ag'  => "́Antigua\ kple\ Barbuda\ nutome",
    'ai'  => "Anguilla\ nutome",
    'al'  => "Albania\ nutome",
    'am'  => "Armenia\ nutome",
    'an'  => "Nedalands\ Antilis\ nutome",
    'ao'  => "Angola\ nutome",
    'aq'  => "Antartica\ nutome",
    'ar'  => "Argentina\ nutome",
    'as'  => "Amerika\ Samoa\ nutome",
    'at'  => "Austria\ nutome",
    'au'  => "Australia\ nutome",
    'aw'  => "Aruba\ nutome",
    'ax'  => "Åland\ ƒudomekpo\ nutome",
    'az'  => "Azerbaijan\ nutome",
    'ba'  => "Bosnia\ kple\ Herzergovina\ nutome",
    'bb'  => "Barbados\ nutome",
    'bd'  => "Bangladesh\ nutome",
    'be'  => "Belgium\ nutome",
    'bf'  => "Burkina\ Faso\ nutome",
    'bg'  => "Bulgaria\ nutome",
    'bh'  => "Bahrain\ nutome",
    'bi'  => "Burundi\ nutome",
    'bj'  => "Benin\ nutome",
    'bl'  => "Saint\ Barthélemy\ nutome",
    'bm'  => "Bermuda\ nutome",
    'bn'  => "Brunei\ nutome",
    'bo'  => "Bolivia\ nutome",
    'bq'  => "British\ Antarctic\ Territory",
    'br'  => "Brazil\ nutome",
    'bs'  => "Bahamas\ nutome",
    'bt'  => "Bhutan\ nutome",
    'bv'  => "Bouvet\ ƒudomekpo\ nutome",
    'bw'  => "Botswana\ nutome",
    'by'  => "Belarus\ nutome",
    'bz'  => "Belize\ nutome",
    'ca'  => "Kanada\ nutome",
    'cc'  => "Kokos\ \[Kiling\]\ fudomekpo\ nutome",
    'cd'  => "Kongo\ demokratik\ repɔblik\ nutome",
    'cf'  => "Titina\ Afrika\ repɔblik\ nutome",
    'cg'  => "Kongo\ repɔblik\ nutome",
    'ch'  => "Switzerland\ nutome",
    'ci'  => "Ivory\ Kost\ nutome",
    'ck'  => "Kook\ ƒudomekpo\ nutome",
    'cl'  => "Tsile\ nutome",
    'cm'  => "Kamerun\ nutome",
    'cn'  => "Tsaina\ nutome",
    'co'  => "Kolombia\ nutome",
    'cp'  => "Klipaton\ ƒudomekpo\ nutome",
    'cr'  => "Kosta\ Rika\ nutome",
    'cs'  => "Serbia\ kple\ Montenegro\ nutome",
    'ct'  => "Canton\ and\ Enderbury\ Islands",
    'cu'  => "Kuba\ nutome",
    'cv'  => "Kape\ Verde\ nutome",
    'cx'  => "Kristmas\ ƒudomekpo\ nutome",
    'cy'  => "Saiprus\ nutome",
    'cz'  => "Tsɛk\ repɔblik\ nutome",
    'dd'  => "East\ Germany",
    'de'  => "Germania\ nutome",
    'dg'  => "Diego\ Garsia\ nutome",
    'dj'  => "Dzibuti\ nutome",
    'dk'  => "Denmark\ nutome",
    'dm'  => "Dominika\ nutome",
    'do'  => "Dominika\ repɔblik\ nutome",
    'dz'  => "Algeria\ nutome",
    'ea'  => "Keuta\ and\ Melilla\ nutome",
    'ec'  => "Ekuadɔ\ nutome",
    'ee'  => "Estonia\ nutome",
    'eg'  => "Egypte\ nutome",
    'eh'  => "Ɣetoɖoƒe\ Sahara\ nutome",
    'er'  => "Eritrea\ nutome",
    'es'  => "Spania\ nutome",
    'et'  => "Etiopia\ nutome",
    'eu'  => "Europa\ Wɔɖeka\ nutome",
    'fi'  => "Finland\ nutome",
    'fj'  => "Fidzi\ nutome",
    'fk'  => "Falkland\ ƒudomekpowo\ \[Islas\ Malvinas\]\ nutome",
    'fm'  => "Mikronesia\ nutome",
    'fo'  => "Faroe\ ƒudomekpowo\ nutome",
    'fq'  => "French\ Southern\ and\ Antarctic\ Territories",
    'fr'  => "Frans\ nutome",
    'fx'  => "Metropolitan\ France",
    'ga'  => "Gabɔn\ nutome",
    'gb'  => "United\ Kingdom\ nutome",
    'gd'  => "Grenada\ nutome",
    'ge'  => "Georgia\ nutome",
    'gf'  => "Frentsi\ Gayana\ nutome",
    'gg'  => "Guernse\ nutome",
    'gh'  => "Ghana\ nutome",
    'gi'  => "Gibraltar\ nutome",
    'gl'  => "Grinland\ nutome",
    'gm'  => "Gambia\ nutome",
    'gn'  => "Guini\ nutome",
    'gp'  => "Guadelupe\ nutome",
    'gq'  => "Ekuatorial\ Guini\ nutome",
    'gr'  => "Grisi\ nutome",
    'gs'  => "Anyiehe\ Georgia\ kple\ Anyiehe\ Sandwich\ ƒudomekpowo\ nutome",
    'gt'  => "Guatemala\ nutome",
    'gu'  => "Guam\ nutome",
    'gw'  => "Gini\-Bisao\ nutome",
    'gy'  => 'Guyanadu',
    'hk'  => "Hɔng\ Kɔng\ nutome",
    'hm'  => "Heard\ kple\ Mcdonald\ ƒudomekpowo\ nutome",
    'hn'  => 'Hondurasdu',
    'hr'  => "Kroatsia\ nutome",
    'ht'  => "Haiti\ nutome",
    'hu'  => "Hungari\ nutome",
    'ic'  => "Kanari\ ƒudomekpowo\ nutome",
    'id'  => "Indonesia\ nutome",
    'ie'  => "Ireland\ nutome",
    'il'  => "Israel\ nutome",
    'im'  => "Aisle\ of\ Man\ nutome",
    'in'  => "India\ nutome",
    'io'  => "Britaintɔwo\ ƒe\ india\ ƒudome\ nutome",
    'iq'  => 'iraqdukɔ',
    'ir'  => "Iran\ nutome",
    'is'  => "Aiseland\ nutome",
    'it'  => "Italia\ nutome",
    'je'  => "Dzɛse\ nutome",
    'jm'  => "Dzamaika\ nutome",
    'jo'  => "Yordan\ nutome",
    'jp'  => "Dzapan\ nutome",
    'jt'  => "Johnston\ Island",
    'ke'  => "Kenya\ nutome",
    'kg'  => "Kirgizstan\ nutome",
    'kh'  => "Kambodia\ nutome",
    'ki'  => "Kiribati\ nutome",
    'km'  => "Komoros\ nutome",
    'kn'  => "Saint\ Kitis\ kple\ Nevis\ nutome",
    'kp'  => "Dziehe\ Korea\ nutome",
    'kr'  => "Anyiehe\ Korea\ nutome",
    'kw'  => "Kuwait\ nutome",
    'ky'  => "Kayman\ ƒudomekpowo\ nutome",
    'kz'  => "Kazakstan\ nutome",
    'la'  => "Laos\ nutome",
    'lb'  => "Lebanɔn\ nutome",
    'lc'  => "Saint\ Lusia\ nutome",
    'li'  => "Litsenstein\ nutome",
    'lk'  => "Sri\ Lanka\ nutome",
    'lr'  => "Liberia\ nutome",
    'ls'  => "Lɛsoto\ nutome",
    'lt'  => "Lituania\ nutome",
    'lu'  => "Lazembɔg\ nutome",
    'lv'  => "Latvia\ nutome",
    'ly'  => "Libya\ nutome",
    'ma'  => "Moroko\ nutome",
    'mc'  => "Monako\ nutome",
    'md'  => "Moldova\ nutome",
    'me'  => "Montenegro\ nutome",
    'mf'  => "Saint\ Martin\ nutome",
    'mg'  => "Madagaska\ nutome",
    'mh'  => "Marshal\ ƒudomekpowo\ nutome",
    'mi'  => "Midway\ Islands",
    'mk'  => "Makedonia\ \[FYROM\]\ nutome",
    'ml'  => "Mali\ nutome",
    'mm'  => "Myanmar\ \[Burma\]\ nutome",
    'mn'  => "Mongolia\ nutome",
    'mo'  => "Macau\ nutome",
    'mp'  => "Dziehe\ Marina\ ƒudomekpowo\ nutome",
    'mq'  => "Martiniki\ nutome",
    'mr'  => "Mauritania\ nutome",
    'ms'  => "Montserrat\ nutome",
    'mt'  => "Malta\ nutome",
    'mu'  => 'mauritiusdukɔ',
    'mv'  => 'maldivesdukɔ',
    'mw'  => "Malawi\ nutome",
    'mx'  => "Meksico\ nutome",
    'my'  => "Malaysia\ nutome",
    'mz'  => "Mozambiki\ nutome",
    'na'  => "Namibia\ nutome",
    'nc'  => "New\ Kaledonia\ nutome",
    'ne'  => "Niger\ nutome",
    'nf'  => "Norfolk\ ƒudomekpo\ nutome",
    'ng'  => "Nigeria\ nutome",
    'ni'  => 'Nicaraguadukɔ',
    'nl'  => "Nedalands\ nutome",
    'no'  => "Norway\ nutome",
    'np'  => "Nepal\ nutome",
    'nq'  => "Dronning\ Maud\ Land",
    'nr'  => "Nauru\ nutome",
    'nt'  => "Neutral\ Zone",
    'nu'  => "Niue\ nutome",
    'nz'  => "New\ Zealand\ nutome",
    'om'  => "Oman\ nutome",
    'pa'  => "Panama\ nutome",
    'pc'  => "Pacific\ Islands\ Trust\ Territory",
    'pe'  => "Peru\ nutome",
    'pf'  => "Frentsi\ Pɔlinesia\ nutome",
    'pg'  => "Papua\ New\ Gini\ nutome",
    'ph'  => "Filipini\ nutome",
    'pk'  => "Pakistan\ nutome",
    'pl'  => "Poland\ nutome",
    'pm'  => "Saint\ Pierre\ kple\ Mikelɔn\ nutome",
    'pn'  => "Pitkairn\ ƒudomekpo\ nutome",
    'pr'  => "Puerto\ Riko\ nutome",
    'ps'  => "Palestinia\ nutome",
    'pt'  => "Portugal\ nutome",
    'pu'  => "U\.S\.\ Miscellaneous\ Pacific\ Islands",
    'pw'  => "Palau\ nutome",
    'py'  => "Paragua\ nutome",
    'pz'  => "Panama\ Canal\ Zone",
    'qa'  => "Katar\ nutome",
    'qo'  => "Outlaying\ Oceania\ nutome",
    're'  => "Réunion\ nutome",
    'ro'  => "Romania\ nutome",
    'rs'  => 'RS',
    'ru'  => "Russia\ nutome",
    'rw'  => "Rwanda\ nutome",
    'sa'  => "Saudi\ Arabia\ nutome",
    'sb'  => "Solomon\ ƒudomekpowo\ nutome",
    'sc'  => "Seshɛls\ nutome",
    'sd'  => "Sudan\ nutome",
    'se'  => "Sweden\ nutome",
    'sg'  => "Singapɔr\ nutome",
    'sh'  => "Saint\ Helena\ nutome",
    'si'  => "Slovenia\ nutome",
    'sj'  => "Svalbard\ kple\ Yan\ Mayen\ nutome",
    'sk'  => "Slovakia\ nutome",
    'sl'  => "Sierra\ Leone\ nutome",
    'sm'  => "San\ Marino\ nutome",
    'sn'  => "Senegal\ nutome",
    'so'  => "Somalia\ nutome",
    'sr'  => "Suriname\ nutome",
    'st'  => "São\ Tomé\ kple\ Príncipe\ nutome",
    'su'  => "Union\ of\ Soviet\ Socialist\ Republics",
    'sv'  => "El\ Salvadɔ\ nutome",
    'sy'  => "Siria\ nutome",
    'sz'  => "Swaziland\ nutome",
    'ta'  => "Tristan\ da\ Kunha\ nutome",
    'tc'  => "Tɛks\ kple\ Kaikos\ ƒudomekpowo\ nutome",
    'td'  => "Tsad\ nutome",
    'tf'  => "Anyiehe\ Franseme\ nutome",
    'tg'  => "Togo\ nutome",
    'th'  => "Tailand\ nutome",
    'tj'  => "Tajikistan\ nutome",
    'tk'  => "Tokelau\ nutome",
    'tl'  => "Ɣedzeƒe\ Timɔ\ nutome",
    'tm'  => "Tɛkmenistan\ nutome",
    'tn'  => "Tunisia\ nutome",
    'to'  => "Tonga\ nutome",
    'tr'  => "Tɛki\ nutome",
    'tt'  => "Trinidad\ kple\ Tobago\ nutome",
    'tv'  => "Tuvalu\ nutome",
    'tw'  => "Taiwan\ nutome",
    'tz'  => "Tanzania\ nutome",
    'ua'  => "Ukraine\ nutome",
    'ug'  => "Uganda\ nutome",
    'um'  => "U\.S\.\ Minor\ Outlaying\ ƒudomekpowo\ nutome",
    'us'  => "USA\ nutome",
    'uy'  => 'uruguaydukɔ',
    'uz'  => "Uzbekistan\ nutome",
    'va'  => "Vatikandu\ nutome",
    'vc'  => "Saint\ Vincent\ kple\ Grenadine\ nutome",
    'vd'  => "North\ Vietnam",
    've'  => "Venezuela\ nutome",
    'vg'  => "Britaintɔwo\ ƒe\ Virgin\ ƒudomekpowo\ nutome",
    'vi'  => "U\.S\.\ Vɛrgin\ ƒudomekpowo\ nutome",
    'vn'  => "Vietnam\ nutome",
    'vu'  => "Vanuatu\ nutome",
    'wf'  => "Wallis\ kple\ Futuna\ nutome",
    'wk'  => "Wake\ Island",
    'ws'  => "Samoa\ nutome",
    'yd'  => "People\â\\s\ Democratic\ Republic\ of\ Yemen",
    'ye'  => "Yemen\ nutome",
    'yt'  => "Mayotte\ nutome",
    'za'  => "Anyiehe\ Afrika\ nutome",
    'zm'  => "Zambia\ nutome",
    'zw'  => "Zimbabwe\ nutome",
    'zz'  => "nutome\ manya",
);

%Locales::DB::Territory::ee::name_to_code = (
    'afghanistannutome'                                   => 'af',
    'afrikanutome'                                        => '002',
    'aiselandnutome'                                      => 'is',
    'aisleofmannutome'                                    => 'im',
    'albanianutome'                                       => 'al',
    'algerianutome'                                       => 'dz',
    'amerikanutome'                                       => '019',
    'amerikasamoanutome'                                  => 'as',
    'andorranutome'                                       => 'ad',
    'angolanutome'                                        => 'ao',
    'anguillanutome'                                      => 'ai',
    'antarticanutome'                                     => 'aq',
    'anyieheafrikanutome'                                 => 'za',
    'anyieheamerikanutome'                                => '005',
    'anyiehefransemenutome'                               => 'tf',
    'anyiehegeorgiakpleanyiehesandwichƒudomekpowonutome' => 'gs',
    'anyiehekoreanutome'                                  => 'kr',
    'anyiehelɔƒoafrikanutome'                           => '018',
    'anyiehelɔƒoasianutome'                             => '034',
    'anyiehelɔƒoeuropanutome'                           => '039',
    'anyieheƔedzeƒeafrikanutome'                        => '035',
    'argentinanutome'                                     => 'ar',
    'armenianutome'                                       => 'am',
    'arubanutome'                                         => 'aw',
    'ascensionƒudomekponutome'                           => 'ac',
    'asianutome'                                          => 142,
    'australiakplenewzealandnutome'                       => '053',
    'australianutome'                                     => 'au',
    'austrianutome'                                       => 'at',
    'azerbaijannutome'                                    => 'az',
    'bahamasnutome'                                       => 'bs',
    'bahrainnutome'                                       => 'bh',
    'bangladeshnutome'                                    => 'bd',
    'barbadosnutome'                                      => 'bb',
    'belarusnutome'                                       => 'by',
    'belgiumnutome'                                       => 'be',
    'belizenutome'                                        => 'bz',
    'beninnutome'                                         => 'bj',
    'bermudanutome'                                       => 'bm',
    'bhutannutome'                                        => 'bt',
    'bolivianutome'                                       => 'bo',
    'bosniakpleherzergovinanutome'                        => 'ba',
    'botswananutome'                                      => 'bw',
    'bouvetƒudomekponutome'                              => 'bv',
    'brazilnutome'                                        => 'br',
    'britaintɔwoƒeindiaƒudomenutome'                   => 'io',
    'britaintɔwoƒevirginƒudomekpowonutome'             => 'vg',
    'britishantarcticterritory'                           => 'bq',
    'bruneinutome'                                        => 'bn',
    'bulgarianutome'                                      => 'bg',
    'burkinafasonutome'                                   => 'bf',
    'burundinutome'                                       => 'bi',
    'cantonandenderburyislands'                           => 'ct',
    'channelislands'                                      => 830,
    'commonwealthofindependentstates'                     => 172,
    'czechoslovakia'                                      => 200,
    'denmarknutome'                                       => 'dk',
    'diegogarsianutome'                                   => 'dg',
    'dominikanutome'                                      => 'dm',
    'dominikarepɔbliknutome'                             => 'do',
    'dronningmaudland'                                    => 'nq',
    'dzamaikanutome'                                      => 'jm',
    'dzapannutome'                                        => 'jp',
    'dzibutinutome'                                       => 'dj',
    'dzieheafrikanutome'                                  => '015',
    'dzieheamerikanutome'                                 => '003',
    'dziehekoreanutome'                                   => 'kp',
    'dziehelɔƒoamerikanutome'                           => '021',
    'dziehelɔƒoeuropanutome'                            => 154,
    'dziehemarinaƒudomekpowonutome'                      => 'mp',
    'dzɛsenutome'                                        => 'je',
    'eastgermany'                                         => 'dd',
    'egyptenutome'                                        => 'eg',
    'ekuadɔnutome'                                       => 'ec',
    'ekuatorialguininutome'                               => 'gq',
    'elsalvadɔnutome'                                    => 'sv',
    'eritreanutome'                                       => 'er',
    'estonianutome'                                       => 'ee',
    'etiopianutome'                                       => 'et',
    'europanutome'                                        => 150,
    'europawɔɖekanutome'                                => 'eu',
    'falklandƒudomekpowoislasmalvinasnutome'             => 'fk',
    'faroeƒudomekpowonutome'                             => 'fo',
    'fidzinutome'                                         => 'fj',
    'filipininutome'                                      => 'ph',
    'finlandnutome'                                       => 'fi',
    'fransnutome'                                         => 'fr',
    'frenchsouthernandantarcticterritories'               => 'fq',
    'frentsigayananutome'                                 => 'gf',
    'frentsipɔlinesianutome'                             => 'pf',
    'gabɔnnutome'                                        => 'ga',
    'gambianutome'                                        => 'gm',
    'georgianutome'                                       => 'ge',
    'germanianutome'                                      => 'de',
    'ghananutome'                                         => 'gh',
    'gibraltarnutome'                                     => 'gi',
    'ginibisaonutome'                                     => 'gw',
    'grenadanutome'                                       => 'gd',
    'grinlandnutome'                                      => 'gl',
    'grisinutome'                                         => 'gr',
    'guadelupenutome'                                     => 'gp',
    'guamnutome'                                          => 'gu',
    'guatemalanutome'                                     => 'gt',
    'guernsenutome'                                       => 'gg',
    'guininutome'                                         => 'gn',
    'guyanadu'                                            => 'gy',
    'haitinutome'                                         => 'ht',
    'heardkplemcdonaldƒudomekpowonutome'                 => 'hm',
    'hondurasdu'                                          => 'hn',
    'hungarinutome'                                       => 'hu',
    'hɔngkɔngnutome'                                    => 'hk',
    'indianutome'                                         => 'in',
    'indonesianutome'                                     => 'id',
    'irannutome'                                          => 'ir',
    'iraqdukɔ'                                           => 'iq',
    'irelandnutome'                                       => 'ie',
    'israelnutome'                                        => 'il',
    'italianutome'                                        => 'it',
    'ivorykostnutome'                                     => 'ci',
    'johnstonisland'                                      => 'jt',
    'kambodianutome'                                      => 'kh',
    'kamerunnutome'                                       => 'cm',
    'kanadanutome'                                        => 'ca',
    'kanariƒudomekpowonutome'                            => 'ic',
    'kapeverdenutome'                                     => 'cv',
    'karibbeanutome'                                      => '029',
    'katarnutome'                                         => 'qa',
    'kaymanƒudomekpowonutome'                            => 'ky',
    'kazakstannutome'                                     => 'kz',
    'kenyanutome'                                         => 'ke',
    'keutaandmelillanutome'                               => 'ea',
    'kirgizstannutome'                                    => 'kg',
    'kiribatinutome'                                      => 'ki',
    'klipatonƒudomekponutome'                            => 'cp',
    'kokoskilingfudomekponutome'                          => 'cc',
    'kolombianutome'                                      => 'co',
    'komorosnutome'                                       => 'km',
    'kongodemokratikrepɔbliknutome'                      => 'cd',
    'kongorepɔbliknutome'                                => 'cg',
    'kookƒudomekponutome'                                => 'ck',
    'kostarikanutome'                                     => 'cr',
    'kristmasƒudomekponutome'                            => 'cx',
    'kroatsianutome'                                      => 'hr',
    'kubanutome'                                          => 'cu',
    'kuwaitnutome'                                        => 'kw',
    'laosnutome'                                          => 'la',
    'latinamerikanutome'                                  => 419,
    'latvianutome'                                        => 'lv',
    'lazembɔgnutome'                                     => 'lu',
    'lebanɔnnutome'                                      => 'lb',
    'liberianutome'                                       => 'lr',
    'libyanutome'                                         => 'ly',
    'litsensteinnutome'                                   => 'li',
    'lituanianutome'                                      => 'lt',
    'lɛsotonutome'                                       => 'ls',
    'macaunutome'                                         => 'mo',
    'madagaskanutome'                                     => 'mg',
    'makedoniafyromnutome'                                => 'mk',
    'malawinutome'                                        => 'mw',
    'malaysianutome'                                      => 'my',
    'maldivesdukɔ'                                       => 'mv',
    'malinutome'                                          => 'ml',
    'maltanutome'                                         => 'mt',
    'marshalƒudomekpowonutome'                           => 'mh',
    'martinikinutome'                                     => 'mq',
    'mauritanianutome'                                    => 'mr',
    'mauritiusdukɔ'                                      => 'mu',
    'mayottenutome'                                       => 'yt',
    'meksiconutome'                                       => 'mx',
    'melanesianutome'                                     => '054',
    'metropolitanfrance'                                  => 'fx',
    'midwayislands'                                       => 'mi',
    'mikronesia'                                          => '057',
    'mikronesianutome'                                    => 'fm',
    'moldovanutome'                                       => 'md',
    'monakonutome'                                        => 'mc',
    'mongolianutome'                                      => 'mn',
    'montenegronutome'                                    => 'me',
    'montserratnutome'                                    => 'ms',
    'morokonutome'                                        => 'ma',
    'mozambikinutome'                                     => 'mz',
    'myanmarburmanutome'                                  => 'mm',
    'namibianutome'                                       => 'na',
    'naurunutome'                                         => 'nr',
    'nedalandsantilisnutome'                              => 'an',
    'nedalandsnutome'                                     => 'nl',
    'nepalnutome'                                         => 'np',
    'neutralzone'                                         => 'nt',
    'newkaledonianutome'                                  => 'nc',
    'newzealandnutome'                                    => 'nz',
    'nicaraguadukɔ'                                      => 'ni',
    'nigerianutome'                                       => 'ng',
    'nigernutome'                                         => 'ne',
    'niuenutome'                                          => 'nu',
    'norfolkƒudomekponutome'                             => 'nf',
    'northvietnam'                                        => 'vd',
    'norwaynutome'                                        => 'no',
    'nutomemanya'                                         => 'zz',
    'oceanianutome'                                       => '009',
    'omannutome'                                          => 'om',
    'outlayingoceanianutome'                              => 'qo',
    'pacificislandstrustterritory'                        => 'pc',
    'pakistannutome'                                      => 'pk',
    'palaunutome'                                         => 'pw',
    'palestinianutome'                                    => 'ps',
    'panamacanalzone'                                     => 'pz',
    'panamanutome'                                        => 'pa',
    'papuanewgininutome'                                  => 'pg',
    'paraguanutome'                                       => 'py',
    "people\â\\sdemocraticrepublicofyemen"           => 'yd',
    'perunutome'                                          => 'pe',
    'pitkairnƒudomekponutome'                            => 'pn',
    'polandnutome'                                        => 'pl',
    'portugalnutome'                                      => 'pt',
    'puertorikonutome'                                    => 'pr',
    'pɔlinesianutome'                                    => '061',
    'romanianutome'                                       => 'ro',
    'rs'                                                  => 'rs',
    'russianutome'                                        => 'ru',
    'rwandanutome'                                        => 'rw',
    'réunionnutome'                                      => 're',
    'saintbarthélemynutome'                              => 'bl',
    'sainthelenanutome'                                   => 'sh',
    'saintkitiskplenevisnutome'                           => 'kn',
    'saintlusianutome'                                    => 'lc',
    'saintmartinnutome'                                   => 'mf',
    'saintpierrekplemikelɔnnutome'                       => 'pm',
    'saintvincentkplegrenadinenutome'                     => 'vc',
    'saiprusnutome'                                       => 'cy',
    'samoanutome'                                         => 'ws',
    'sanmarinonutome'                                     => 'sm',
    'saudiarabianutome'                                   => 'sa',
    'senegalnutome'                                       => 'sn',
    'serbiakplemontenegronutome'                          => 'cs',
    'seshɛlsnutome'                                      => 'sc',
    'sierraleonenutome'                                   => 'sl',
    'singapɔrnutome'                                     => 'sg',
    'sirianutome'                                         => 'sy',
    'slovakianutome'                                      => 'sk',
    'slovenianutome'                                      => 'si',
    'solomonƒudomekpowonutome'                           => 'sb',
    'somalianutome'                                       => 'so',
    'southcentralasia'                                    => '062',
    'spanianutome'                                        => 'es',
    'srilankanutome'                                      => 'lk',
    'sudannutome'                                         => 'sd',
    'surinamenutome'                                      => 'sr',
    'svalbardkpleyanmayennutome'                          => 'sj',
    'swazilandnutome'                                     => 'sz',
    'swedennutome'                                        => 'se',
    'switzerlandnutome'                                   => 'ch',
    'sãotomékplepríncipenutome'                        => 'st',
    'tailandnutome'                                       => 'th',
    'taiwannutome'                                        => 'tw',
    'tajikistannutome'                                    => 'tj',
    'tanzanianutome'                                      => 'tz',
    'titinaafrikanutome'                                  => '017',
    'titinaafrikarepɔbliknutome'                         => 'cf',
    'titinaamerikanutome'                                 => '013',
    'titinaasianutome'                                    => 143,
    'togonutome'                                          => 'tg',
    'tokelaunutome'                                       => 'tk',
    'tonganutome'                                         => 'to',
    'trinidadkpletobagonutome'                            => 'tt',
    'tristandakunhanutome'                                => 'ta',
    'tsadnutome'                                          => 'td',
    'tsainanutome'                                        => 'cn',
    'tsilenutome'                                         => 'cl',
    'tsɛkrepɔbliknutome'                                => 'cz',
    'tunisianutome'                                       => 'tn',
    'tuvalunutome'                                        => 'tv',
    'tɛkinutome'                                         => 'tr',
    'tɛkmenistannutome'                                  => 'tm',
    'tɛkskplekaikosƒudomekpowonutome'                   => 'tc',
    "u\.s\.minoroutlayingƒudomekpowonutome"              => 'um',
    "u\.s\.miscellaneouspacificislands"                   => 'pu',
    "u\.s\.vɛrginƒudomekpowonutome"                     => 'vi',
    'ugandanutome'                                        => 'ug',
    'ukrainenutome'                                       => 'ua',
    'unionofsovietsocialistrepublics'                     => 'su',
    'unitedarabemiratesnutome'                            => 'ae',
    'unitedkingdomnutome'                                 => 'gb',
    'uruguaydukɔ'                                        => 'uy',
    'usanutome'                                           => 'us',
    'uzbekistannutome'                                    => 'uz',
    'vanuatunutome'                                       => 'vu',
    'vatikandunutome'                                     => 'va',
    'venezuelanutome'                                     => 've',
    'vietnamnutome'                                       => 'vn',
    'wakeisland'                                          => 'wk',
    'walliskplefutunanutome'                              => 'wf',
    'xexeme'                                              => '001',
    'yemennutome'                                         => 'ye',
    'yordannutome'                                        => 'jo',
    'zambianutome'                                        => 'zm',
    'zimbabwenutome'                                      => 'zw',
    'Ålandƒudomekponutome'                              => 'ax',
    'Ɣedzeƒeafrikanutome'                               => '014',
    'Ɣedzeƒeasianutome'                                 => '030',
    'Ɣedzeƒeeuropanutome'                               => 151,
    'Ɣedzeƒetimɔnutome'                                => 'tl',
    'Ɣetoɖoƒelɔƒoafrikanutome'                       => '011',
    'Ɣetoɖoƒelɔƒoasianutome'                         => 145,
    'Ɣetoɖoƒelɔƒoeuropanutome'                       => 155,
    'Ɣetoɖoƒesaharanutome'                             => 'eh',
    '́antiguakplebarbudanutome'                          => 'ag',
);

1;

