use strict;
use warnings;
use Test::More tests => 68;
use Digest::Keccak qw(keccak_224 keccak_224_hex);

my $len = 0;

while (my $line = <DATA>) {
    chomp $line;
    my ($msg, $digest) = split '\|', $line, 2;
    my $data = pack 'H*', $msg;
    $digest = lc $digest;

    if ($len and not $len % 8) {
        my $md = Digest::Keccak->new(224)->add($data)->hexdigest;
        is($md, $digest, "new/add/hexdigest: $len bits of $msg");
        is(
            keccak_224_hex($data), $digest,
            "keccak_224_hex: $len bits of $msg"
        );
        ok(
            keccak_224($data) eq pack('H*', $digest),
            "keccak_224: $len bits of $msg"
        );
    }

    my $md = Digest::Keccak->new(224)->add_bits($data, $len)->hexdigest;
    is($md, $digest, "new/add_bits/hexdigest: $len bits of $msg");
}
continue { $len++ }

__DATA__
00|38A72B8EC93CC3860EFB22A75F6E94BCEA65B21D92EE525B32E85D3F
00|E6E26CFC5E682AF2DA884F874ACE2CABAFE3772355ADEE248989705E
C0|1612E16D57B8331B0E35CA0BB0E28E286AE3311CB30121EB565D70A3
C0|AEFC9875E93A292B3F8C445C84594770211E746EA62C1A8CC749F7DE
80|938BEFCB9765CD2DCF8E0B86174F0392650E9FBCFC1F30392F41B8AC
48|9CC01D825F98E49C186A83238BFDDCF205157C2B59AA34CCF851E925
50|D6E961285B91CD0A2CF5E6870CC4BF3FFD0E6C8B5A349E74CB920338
98|5E3A093FF89E1F22B0660E8732AE2CAFF46C8ED08C336671586C1643
CC|F4DCAABB6FB80D459EFFE93E5B4D5AE8D05E1A6C173FD0F0DDBA2B7D
9800|9EB2123CF08D74172AE9269D9E432EF8088303FA6108DBCFA75D7A1F
9D40|D84B33C4B0BCD7B1E4A5EE74F83F7936E645906A8F60DF16FB84586C
AA80|B8F2494413F1CE94FBE74A59F227176E45BB20E2D5155F2F9FEAFF6F
9830|3CCE0AA5E1B02399288270516222AE628D72FB5CC6F184906D487BA9
5030|86F91687186F095D74EADD5539C76611E93009597820FC8E17E2421F
4D24|4976BF06C8E9083D6E823ECEBB3B646ABE01E2CB4B429578C6DA8D65
CBDE|E848BD17AAB53C198E7A2911DDEAA92A65A4D25E89E9D3B2C3E49715
41FB|7A39035F164B010E3ABD435EB063A378D1A027E8EED3BEA91FFCCA9E
4FF400|0AE4138FF9D9C6F26DD8EA323FDBEB3E82307AB694F6B10C8C12B028
FD0440|1A596075E2B77DD946FA3E13E8F8158E1961254063EB9560E4B419C1
424D00|90DB92AAD49A7182DBA91F96B10B24E422E074D2FEBBFFF013A8212F
3FDEE0|82FC7DA7DDCE1FF19900A6324217FB4E41E1CD8481F9E723362E24BF
335768|B1EA8BFA9B11D0D08EC1D905D436E5669D5B78FEC9C3AD5AAEF02999
051E7C|B08EB316CAD666EE382012DB35944C0F90637BA3BA2E3317FCBF49F3
717F8C|22508BA344B04BD7BE0D6D7D4C0635BABE61916025FE6B6E2C36514F
1F877C|E34A9A2BE049A5632497218DB9CB6F2C67E4638572EE93F429385AEC
EB35CF80|9D2C9A150875D38C3768ED9C37D986D15570F3502507A79C795794DA
B406C480|FB94DD656C4DDE5C748639DE61351ADA04803328184A65340CD785CA
CEE88040|F46FE1E4EB32FA12C3777146E1B098DB50C5F12DD8BC48BF9883E559
C584DB70|9ECC199F8F8492E3C9AB7BABB81AA9E4292969E2885F5D9DEED84F6D
53587BC8|7B2A9906F52C2B7321B4FD4153C04C8771B816861989F737BD3C30E7
69A305B0|E74947C9680E44923ED714A90EBC8297E170DBA5C06DCC61E9251EF8
C9375ECE|11E8331B161C0ACF44FC3FB49651F37A6C64873088E46DB22E05C4DD
C1ECFDFC|FBC0332C8F9CA5CD499F6AB642B36CA55AC855825A803745EA9AB0B8
8D73E8A280|B29B72E035F099121AD8FD949B76DAB3DD6C7DEF65B0E054644FBD13
06F2522080|34B15906994B6DC29399BAB5A2A28E176CED93624CBE10710B5C317D
3EF6C36F20|FB1B826DD41249FEF76B1695A422527927C43FCC6AE79B5429706D58
0127A1D340|41CF516F8D251FB5D1CDABBDEA73AC06438B240368D0807FD1C308E0
6A6AB6C210|D597150A78D24D2BE4E0896685E10673D9A458360B2E9A76C9603211
AF3175E160|A6220B79338D9EC13C3A3A7BF3974AE77AE8F47726221B05BDD117F2
B66609ED86|E6D10E99014A59CB2C4263F5ADAE31EDDB43A5656572D5D6818BD36B
21F134AC57|6BC8429AE30670C0B36270A71FF8BF8BA3A5C85322DE6FE5503D3873
3DC2AADFFC80|F28299B7C78E97BBC4160FEC1B0D203D6852EA1C9A770F39C7930CEC
9202736D2240|8BCA8EA39DEEF2C5781C8E2F6CC1A7DAF79535188BC9B380E907DE67
F219BD629820|83019001DB5223FB532097D31DB9721634D5FCD8BC284E1E647393F0
F3511EE2C4B0|785E45E1C2E7F5C25F1F6F3FEC4D9BF98852C2201DE90502373C2C45
3ECAB6BF7720|390470BF0D16C7DAD3BFC93D51D7AFEFB0F03FA56B7450DB355B7678
CD62F688F498|401C7E966ABCCB5AFBF3F1DFEBD872F8C3FA490B62FE0215AA2EF959
C2CBAA33A9F8|47EBE81383986C1678C9BD16E4D3E714D3BD20218D60AE62C953C59C
C6F50BB74E29|7AEA1378DD6303FF42950E9B80E53B4CAF7A05621738A135F79A7F20
79F1B4CCC62A00|002A179A552130C63DD710B2872469093B01E22E45FB9E495DDD2B4E
