# Generated by default/object.tt
package Paws::Appflow::ConnectorEntity;
  use Moose;
  has HasNestedEntities => (is => 'ro', isa => 'Bool', request_name => 'hasNestedEntities', traits => ['NameInRequest']);
  has Label => (is => 'ro', isa => 'Str', request_name => 'label', traits => ['NameInRequest']);
  has Name => (is => 'ro', isa => 'Str', request_name => 'name', traits => ['NameInRequest'], required => 1);

1;

### main pod documentation begin ###

=head1 NAME

Paws::Appflow::ConnectorEntity

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::Appflow::ConnectorEntity object:

  $service_obj->Method(Att1 => { HasNestedEntities => $value, ..., Name => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::Appflow::ConnectorEntity object:

  $result = $service_obj->Method(...);
  $result->Att1->HasNestedEntities

=head1 DESCRIPTION

The high-level entity that can be queried in Amazon AppFlow. For
example, a Salesforce entity might be an I<Account> or I<Opportunity>,
whereas a ServiceNow entity might be an I<Incident>.

=head1 ATTRIBUTES


=head2 HasNestedEntities => Bool

Specifies whether the connector entity is a parent or a category and
has more entities nested underneath it. If another call is made with
C<entitiesPath =
"the_current_entity_name_with_hasNestedEntities_true">, then it returns
the nested entities underneath it. This provides a way to retrieve all
supported entities in a recursive fashion.


=head2 Label => Str

The label applied to the connector entity.


=head2 B<REQUIRED> Name => Str

The name of the connector entity.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::Appflow>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

