# This Makefile.PL for  was generated by Dist::Zilla.
# Don't edit it but the dist.ini used to construct it.

use strict;
use warnings;
use ExtUtils::MakeMaker 6.30;

my %WriteMakefileArgs = (
  'ABSTRACT' => 'Portably access the process table',
  'AUTHOR' => 'Brendan Byrd <BBYRD@CPAN.org>',
  'BUILD_REQUIRES' => {
    'Test::CheckDeps' => '0.002',
    'Test::More' => '0.88'
  },
  'CONFIGURE_REQUIRES' => {
    'ExtUtils::MakeMaker' => '6.30'
  },
  'DISTNAME' => 'P9Y-ProcessTable',
  'EXE_FILES' => [],
  'LICENSE' => 'artistic_2',
  'NAME' => 'P9Y::ProcessTable',
  'PREREQ_PM' => &os_deps,
  'VERSION' => '0.90',
  'test' => {
    'TESTS' => 't/*.t'
  }
);


unless ( eval { ExtUtils::MakeMaker->VERSION(6.56) } ) {
  my $br = delete $WriteMakefileArgs{BUILD_REQUIRES};
  my $pp = $WriteMakefileArgs{PREREQ_PM};
  for my $mod ( keys %$br ) {
    if ( exists $pp->{$mod} ) {
      $pp->{$mod} = $br->{$mod} if $br->{$mod} > $pp->{$mod};
    }
    else {
      $pp->{$mod} = $br->{$mod};
    }
  }
}

delete $WriteMakefileArgs{CONFIGURE_REQUIRES}
  unless eval { ExtUtils::MakeMaker->VERSION(6.52) };

WriteMakefile(%WriteMakefileArgs);

sub os_deps {
   for (lc $^O) {
      if    (/mswin32|cygwin/) {
         return {
            'Win32::Process'       => 0,
            'Win32::Process::Info' => 0,
         };
      }
      elsif ('freebsd') {
         return {'BSD::Process' => 0};
      }
      elsif ('darwin') {
         return {'Proc::ProcessTable' => 0.45};
      }
      elsif ('os2') {
         return {'OS2::Process' => 0};
      }
      elsif ('vms') {
         return {'VMS::Process' => 0};
      }
      elsif ('dos') {
         die "Heh, DOS processes... you're funny!";
      }
      else {
         # let's hope they have /proc
         unless ( -d dir('', 'proc') ) {
            die lc $^O =~ /bsd|dragonfly/ ? 
               "BSD::Process only works for FreeBSD.  Encourage development for $^O, or write your own and I can include it here." :
               "No idea how to handle $^O processes.  Email me with more information!";
         }
      }
   }
   return {};
}
