# Generated by default/object.tt
package Paws::LexRuntime::ActiveContextTimeToLive;
  use Moose;
  has TimeToLiveInSeconds => (is => 'ro', isa => 'Int', request_name => 'timeToLiveInSeconds', traits => ['NameInRequest']);
  has TurnsToLive => (is => 'ro', isa => 'Int', request_name => 'turnsToLive', traits => ['NameInRequest']);

1;

### main pod documentation begin ###

=head1 NAME

Paws::LexRuntime::ActiveContextTimeToLive

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::LexRuntime::ActiveContextTimeToLive object:

  $service_obj->Method(Att1 => { TimeToLiveInSeconds => $value, ..., TurnsToLive => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::LexRuntime::ActiveContextTimeToLive object:

  $result = $service_obj->Method(...);
  $result->Att1->TimeToLiveInSeconds

=head1 DESCRIPTION

The length of time or number of turns that a context remains active.

=head1 ATTRIBUTES


=head2 TimeToLiveInSeconds => Int

The number of seconds that the context should be active after it is
first sent in a C<PostContent> or C<PostText> response. You can set the
value between 5 and 86,400 seconds (24 hours).


=head2 TurnsToLive => Int

The number of conversation turns that the context should be active. A
conversation turn is one C<PostContent> or C<PostText> request and the
corresponding response from Amazon Lex.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::LexRuntime>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

