use Test::More qw(no_plan);
use Date::Calc::Endpoints;
use strict;
use warnings;


my $ref_date = '2016-08-28';

my $dr = Date::Calc::Endpoints->new(today_date => $ref_date);
my $type = 'YEAR';

while (my $line = <main::DATA>) {
    chomp $line;
    my ($start_month,$intervals,$span,$sliding_window,$direction,$test_start,$test_end,$test_last) = split /,/, $line;
    $dr->set_type($type);
    $dr->set_start_month_of_year($start_month);
    $dr->set_intervals($intervals);
    $dr->set_span($span);
    $dr->set_sliding_window($sliding_window);
    $dr->set_direction($direction);

    my $m = $dr->get_start_month_of_year;

    my $atts = "M=$m | I=$intervals | S=$span | W=$sliding_window | D=$direction";


    my ($start,$end,$last) = $dr->get_dates;
    cmp_ok($start,'eq',$test_start,"$type START $atts")
        or BAIL_OUT("Fail")
    ;
    cmp_ok($end,'eq',$test_end,"$type END $atts")
        or BAIL_OUT("Fail")
    ;
    cmp_ok($last,'eq',$test_last,"$type LAST $atts")
        or BAIL_OUT("Fail")
    ;

}

__END__
5,-3,1,0,-,2019-05-01,2020-05-01,2020-04-30
5,-2,1,0,-,2018-05-01,2019-05-01,2019-04-30
5,-1,1,0,-,2017-05-01,2018-05-01,2018-04-30
5,0,1,0,-,2016-05-01,2017-05-01,2017-04-30
5,1,1,0,-,2015-05-01,2016-05-01,2016-04-30
5,2,1,0,-,2014-05-01,2015-05-01,2015-04-30
5,3,1,0,-,2013-05-01,2014-05-01,2014-04-30
5,-3,5,0,-,2031-05-01,2036-05-01,2036-04-30
5,-2,5,0,-,2026-05-01,2031-05-01,2031-04-30
5,-1,5,0,-,2021-05-01,2026-05-01,2026-04-30
5,0,5,0,-,2016-05-01,2021-05-01,2021-04-30
5,1,5,0,-,2011-05-01,2016-05-01,2016-04-30
5,2,5,0,-,2006-05-01,2011-05-01,2011-04-30
5,3,5,0,-,2001-05-01,2006-05-01,2006-04-30
5,-3,5,1,-,2015-05-01,2020-05-01,2020-04-30
5,-2,5,1,-,2014-05-01,2019-05-01,2019-04-30
5,-1,5,1,-,2013-05-01,2018-05-01,2018-04-30
5,0,5,1,-,2012-05-01,2017-05-01,2017-04-30
5,1,5,1,-,2011-05-01,2016-05-01,2016-04-30
5,2,5,1,-,2010-05-01,2015-05-01,2015-04-30
5,3,5,1,-,2009-05-01,2014-05-01,2014-04-30
5,-3,1,0,+,2013-05-01,2014-05-01,2014-04-30
5,-2,1,0,+,2014-05-01,2015-05-01,2015-04-30
5,-1,1,0,+,2015-05-01,2016-05-01,2016-04-30
5,0,1,0,+,2016-05-01,2017-05-01,2017-04-30
5,1,1,0,+,2017-05-01,2018-05-01,2018-04-30
5,2,1,0,+,2018-05-01,2019-05-01,2019-04-30
5,3,1,0,+,2019-05-01,2020-05-01,2020-04-30
5,-3,5,0,+,2001-05-01,2006-05-01,2006-04-30
5,-2,5,0,+,2006-05-01,2011-05-01,2011-04-30
5,-1,5,0,+,2011-05-01,2016-05-01,2016-04-30
5,0,5,0,+,2016-05-01,2021-05-01,2021-04-30
5,1,5,0,+,2021-05-01,2026-05-01,2026-04-30
5,2,5,0,+,2026-05-01,2031-05-01,2031-04-30
5,3,5,0,+,2031-05-01,2036-05-01,2036-04-30
5,-3,5,1,+,2013-05-01,2018-05-01,2018-04-30
5,-2,5,1,+,2014-05-01,2019-05-01,2019-04-30
5,-1,5,1,+,2015-05-01,2020-05-01,2020-04-30
5,0,5,1,+,2016-05-01,2021-05-01,2021-04-30
5,1,5,1,+,2017-05-01,2022-05-01,2022-04-30
5,2,5,1,+,2018-05-01,2023-05-01,2023-04-30
5,3,5,1,+,2019-05-01,2024-05-01,2024-04-30
8,-3,1,0,-,2019-08-01,2020-08-01,2020-07-31
8,-2,1,0,-,2018-08-01,2019-08-01,2019-07-31
8,-1,1,0,-,2017-08-01,2018-08-01,2018-07-31
8,0,1,0,-,2016-08-01,2017-08-01,2017-07-31
8,1,1,0,-,2015-08-01,2016-08-01,2016-07-31
8,2,1,0,-,2014-08-01,2015-08-01,2015-07-31
8,3,1,0,-,2013-08-01,2014-08-01,2014-07-31
8,-3,5,0,-,2031-08-01,2036-08-01,2036-07-31
8,-2,5,0,-,2026-08-01,2031-08-01,2031-07-31
8,-1,5,0,-,2021-08-01,2026-08-01,2026-07-31
8,0,5,0,-,2016-08-01,2021-08-01,2021-07-31
8,1,5,0,-,2011-08-01,2016-08-01,2016-07-31
8,2,5,0,-,2006-08-01,2011-08-01,2011-07-31
8,3,5,0,-,2001-08-01,2006-08-01,2006-07-31
8,-3,5,1,-,2015-08-01,2020-08-01,2020-07-31
8,-2,5,1,-,2014-08-01,2019-08-01,2019-07-31
8,-1,5,1,-,2013-08-01,2018-08-01,2018-07-31
8,0,5,1,-,2012-08-01,2017-08-01,2017-07-31
8,1,5,1,-,2011-08-01,2016-08-01,2016-07-31
8,2,5,1,-,2010-08-01,2015-08-01,2015-07-31
8,3,5,1,-,2009-08-01,2014-08-01,2014-07-31
8,-3,1,0,+,2013-08-01,2014-08-01,2014-07-31
8,-2,1,0,+,2014-08-01,2015-08-01,2015-07-31
8,-1,1,0,+,2015-08-01,2016-08-01,2016-07-31
8,0,1,0,+,2016-08-01,2017-08-01,2017-07-31
8,1,1,0,+,2017-08-01,2018-08-01,2018-07-31
8,2,1,0,+,2018-08-01,2019-08-01,2019-07-31
8,3,1,0,+,2019-08-01,2020-08-01,2020-07-31
8,-3,5,0,+,2001-08-01,2006-08-01,2006-07-31
8,-2,5,0,+,2006-08-01,2011-08-01,2011-07-31
8,-1,5,0,+,2011-08-01,2016-08-01,2016-07-31
8,0,5,0,+,2016-08-01,2021-08-01,2021-07-31
8,1,5,0,+,2021-08-01,2026-08-01,2026-07-31
8,2,5,0,+,2026-08-01,2031-08-01,2031-07-31
8,3,5,0,+,2031-08-01,2036-08-01,2036-07-31
8,-3,5,1,+,2013-08-01,2018-08-01,2018-07-31
8,-2,5,1,+,2014-08-01,2019-08-01,2019-07-31
8,-1,5,1,+,2015-08-01,2020-08-01,2020-07-31
8,0,5,1,+,2016-08-01,2021-08-01,2021-07-31
8,1,5,1,+,2017-08-01,2022-08-01,2022-07-31
8,2,5,1,+,2018-08-01,2023-08-01,2023-07-31
8,3,5,1,+,2019-08-01,2024-08-01,2024-07-31
11,-3,1,0,-,2018-11-01,2019-11-01,2019-10-31
11,-2,1,0,-,2017-11-01,2018-11-01,2018-10-31
11,-1,1,0,-,2016-11-01,2017-11-01,2017-10-31
11,0,1,0,-,2015-11-01,2016-11-01,2016-10-31
11,1,1,0,-,2014-11-01,2015-11-01,2015-10-31
11,2,1,0,-,2013-11-01,2014-11-01,2014-10-31
11,3,1,0,-,2012-11-01,2013-11-01,2013-10-31
11,-3,5,0,-,2030-11-01,2035-11-01,2035-10-31
11,-2,5,0,-,2025-11-01,2030-11-01,2030-10-31
11,-1,5,0,-,2020-11-01,2025-11-01,2025-10-31
11,0,5,0,-,2015-11-01,2020-11-01,2020-10-31
11,1,5,0,-,2010-11-01,2015-11-01,2015-10-31
11,2,5,0,-,2005-11-01,2010-11-01,2010-10-31
11,3,5,0,-,2000-11-01,2005-11-01,2005-10-31
11,-3,5,1,-,2014-11-01,2019-11-01,2019-10-31
11,-2,5,1,-,2013-11-01,2018-11-01,2018-10-31
11,-1,5,1,-,2012-11-01,2017-11-01,2017-10-31
11,0,5,1,-,2011-11-01,2016-11-01,2016-10-31
11,1,5,1,-,2010-11-01,2015-11-01,2015-10-31
11,2,5,1,-,2009-11-01,2014-11-01,2014-10-31
11,3,5,1,-,2008-11-01,2013-11-01,2013-10-31
11,-3,1,0,+,2012-11-01,2013-11-01,2013-10-31
11,-2,1,0,+,2013-11-01,2014-11-01,2014-10-31
11,-1,1,0,+,2014-11-01,2015-11-01,2015-10-31
11,0,1,0,+,2015-11-01,2016-11-01,2016-10-31
11,1,1,0,+,2016-11-01,2017-11-01,2017-10-31
11,2,1,0,+,2017-11-01,2018-11-01,2018-10-31
11,3,1,0,+,2018-11-01,2019-11-01,2019-10-31
11,-3,5,0,+,2000-11-01,2005-11-01,2005-10-31
11,-2,5,0,+,2005-11-01,2010-11-01,2010-10-31
11,-1,5,0,+,2010-11-01,2015-11-01,2015-10-31
11,0,5,0,+,2015-11-01,2020-11-01,2020-10-31
11,1,5,0,+,2020-11-01,2025-11-01,2025-10-31
11,2,5,0,+,2025-11-01,2030-11-01,2030-10-31
11,3,5,0,+,2030-11-01,2035-11-01,2035-10-31
11,-3,5,1,+,2012-11-01,2017-11-01,2017-10-31
11,-2,5,1,+,2013-11-01,2018-11-01,2018-10-31
11,-1,5,1,+,2014-11-01,2019-11-01,2019-10-31
11,0,5,1,+,2015-11-01,2020-11-01,2020-10-31
11,1,5,1,+,2016-11-01,2021-11-01,2021-10-31
11,2,5,1,+,2017-11-01,2022-11-01,2022-10-31
11,3,5,1,+,2018-11-01,2023-11-01,2023-10-31
