#!/usr/bin/perl -w
# based on fl14.mpg
# http://bmrc.berkeley.edu/ftp/pub/multimedia/mpeg/mpeg2/conformance-bitstreams/audio/mpeg1/compliance/

use strict;
use integer;

my $n;
use Test::More tests => ($n = 16) * 8 + 2;
BEGIN { use_ok("MPEG::Audio::Frame") };

for (1 .. $n){
	isa_ok(my $frame = MPEG::Audio::Frame->read(*DATA), "MPEG::Audio::Frame", "frame $_");
	ok($frame->mpeg1, "frame is MPEG1");
	ok($frame->layer2, "frame is layer II");
	ok($frame->has_crc, "frame has crc");
	ok(!$frame->broken, "frame isn't broken");
	is($frame->bitrate, 384, "bitrate");
	is($frame->sample, 48000, "sample rate");
	ok($frame->dual_channel, "dual_channel");
}
is(MPEG::Audio::Frame->read(*DATA), undef, "nothing else in the file");

__DATA__
)eivvvvwwgwmk(   #       	P~w6-JQJ8>Nԫ{:RYnZ͛|b\ϦpjƲ=o>s3
|w=<w?_  ? }}{}}}{{{{{{{kc_6	7=op.`DA|/tǡq]z^P;9st={9sA5MGiAW3< rH"t\
4tsZ RU,D<T'Ͷl';dvl$(NHN
v8)Cpc<]Mt!
מ\^ۏ5φ!u^y^qסCP={9={9=5{a1%n4A	fc0݇4 &Y{wY2s<+wp
ڇk.QLOӴ܏'ƖF ?^߿tf=}{~\u_'<>tass5|idap1%n A}oށ{<u^"~/sϾk^F{9{a=|_=|[-7ƖF ?^߿tf=}{~\u_'<>tass5|idax4u1%n)ܺAAPq"
ŷj±'n4Hy(\#	0pn[i}hkHco]5WMEKJ]ƖFAS^]˯tgr [z6+v@$\E?ޠP嶟>:ֆĆ6[5tTEpidax4u1%n)ܺAAPq"
ŷj±'n4Hy(\#	0pn[i}hkHco]5WMEKJ]ƖFAS^]˯tgr [z6+v@$\E?ޠP嶟>:ֆĆ6[5tTEpzewcfۥ$     >}N:ν=޾|߾7,aAOE]"l[a4)u@APy[Yo1E(g4Mk]Ϙُ8}lې5#º~;%l08(1ՉkP\
wr& *#?k`U:Z]c#-?(Q?tLƉps3˹1rxW]9cZ/d:=wn._ФCYv
l
gSK`DrJ'@n5fyw>cf<An@ԏ
,kEQV'Ap6-: sK<V,qiu\DM3&.lǜh>m]th6^R(.Ż~vBGTig5*eN-.˖Q(&~cDָ9͹R<+YFXֻEطx/hRꀂ,;[lť0"9rc%Q7Dh3<1qٷ jGuӖ5vK(`pPczqHM
APT9G`mu8G.[~QDt
&Zgs6c4[6
Hrƴ_e
ubz/Z)b\;	H#
4mΧXy(OD?1k\|yƃf܁NX֋,aAOE]"l[a4)u@APy[Yo1E(g4Mk]Ϙُ8}lې5#º~;%l08(1ՉkP\
wr& *#?k`U:Z]c#-?(Q?tLƉps3˹1rxW]9cZ/d:=wn._ФCYv
l
gSK`DrJ'@n5fyw>cf<An@ԏ
,kEQV'Ap6-: sK<V,qiu\DM3&.lǜh>m]th zewcfۥ$     >}N:ν=޾|߾7,aAOE]"l[a4)u@APy[Yo1E(g4Mk]Ϙُ8}lې5#º~;%l08(1ՉkP\
wr& *#?k`U:Z]c#-?(Q?tLƉps3˹1rxW]9cZ/d:=wn._ФCYv
l
gSK`DrJ'@n5fyw>cf<An@ԏ
,kEQV'Ap6-: sK<V,qiu\DM3&.lǜh>m]th6^R(.Ż~vBGTig5*eN-.˖Q(&~cDָ9͹R<+YFXֻEطx/hRꀂ,;[lť0"9rc%Q7Dh3<1qٷ jGuӖ5vK(`pPczqHM
APT9G`mu8G.[~QDt
&Zgs6c4[6
Hrƴ_e
ubz/Z)b\;	H#
4mΧXy(OD?1k\|yƃf܁NX֋,aAOE]"l[a4)u@APy[Yo1E(g4Mk]Ϙُ8}lې5#º~;%l08(1ՉkP\
wr& *#?k`U:Z]c#-?(Q?tLƉps3˹1rxW]9cZ/d:=wn._ФCYv
l
gSK`DrJ'@n5fyw>cf<An@ԏ
,kEQV'Ap6-: sK<V,qiu\DM3&.lǜh>m]th zewcfۥ$     >}N:ν=޾|߾7,aAOE]"l[a4)u@APy[Yo1E(g4Mk]Ϙُ8}lې5#º~;%l08(1ՉkP\
wr& *#?k`U:Z]c#-?(Q?tLƉps3˹1rxW]9cZ/d:=wn._ФCYv
l
gSK`DrJ'@n5fyw>cf<An@ԏ
,kEQV'Ap6-: sK<V,qiu\DM3&.lǜh>m]th6^R(.Ż~vBGTig5*eN-.˖Q(&~cDָ9͹R<+YFXֻEطx/hRꀂ,;[lť0"9rc%Q7Dh3<1qٷ jGuӖ5vK(`pPczqHM
APT9G`mu8G.[~QDt
&Zgs6c4[6
Hrƴ_e
ubz/Z)b\;	H#
4mΧXy(OD?1k\|yƃf܁NX֋,aAOE]"l[a4)u@APy[Yo1E(g4Mk]Ϙُ8}lې5#º~;%l08(1ՉkP\
wr& *#?k`U:Z]c#-?(Q?tLƉps3˹1rxW]9cZ/d:=wn._ФCYv
l
gSK`DrJ'@n5fyw>cf<An@ԏ
,kEQV'Ap6-: sK<V,qiu\DM3&.lǜh>m]th zewcfۥ$     >}N:ν=޾|߾7,aAOE]"l[a4)u@APy[Yo1E(g4Mk]Ϙُ8}lې5#º~;%l08(1ՉkP\
wr& *#?k`U:Z]c#-?(Q?tLƉps3˹1rxW]9cZ/d:=wn._ФCYv
l
gSK`DrJ'@n5fyw>cf<An@ԏ
,kEQV'Ap6-: sK<V,qiu\DM3&.lǜh>m]th6^R(.Ż~vBGTig5*eN-.˖Q(&~cDָ9͹R<+YFXֻEطx/hRꀂ,;[lť0"9rc%Q7Dh3<1qٷ jGuӖ5vK(`pPczqHM
APT9G`mu8G.[~QDt
&Zgs6c4[6
Hrƴ_e
ubz/Z)b\;	H#
4mΧXy(OD?1k\|yƃf܁NX֋,aAOE]"l[a4)u@APy[Yo1E(g4Mk]Ϙُ8}lې5#º~;%l08(1ՉkP\
wr& *#?k`U:Z]c#-?(Q?tLƉps3˹1rxW]9cZ/d:=wn._ФCYv
l
gSK`DrJ'@n5fyw>cf<An@ԏ
,kEQV'Ap6-: sK<V,qiu\DM3&.lǜh>m]th zewcfۥ$     >}N:ν=޾|߾7,aAOE]"l[a4)u@APy[Yo1E(g4Mk]Ϙُ8}lې5#º~;%l08(1ՉkP\
wr& *#?k`U:Z]c#-?(Q?tLƉps3˹1rxW]9cZ/d:=wn._ФCYv
l
gSK`DrJ'@n5fyw>cf<An@ԏ
,kEQV'Ap6-: sK<V,qiu\DM3&.lǜh>m]th6^R(.Ż~vBGTig5*eN-.˖Q(&~cDָ9͹R<+YFXֻEطx/hRꀂ,;[lť0"9rc%Q7Dh3<1qٷ jGuӖ5vK(`pPczqHM
APT9G`mu8G.[~QDt
&Zgs6c4[6
Hrƴ_e
ubz/Z)b\;	H#
4mΧXy(OD?1k\|yƃf܁NX֋,aAOE]"l[a4)u@APy[Yo1E(g4Mk]Ϙُ8}lې5#º~;%l08(1ՉkP\
wr& *#?k`U:Z]c#-?(Q?tLƉps3˹1rxW]9cZ/d:=wn._ФCYv
l
gSK`DrJ'@n5fyw>cf<An@ԏ
,kEQV'Ap6-: sK<V,qiu\DM3&.lǜh>m]th zewcfۥ$     >}N:ν=޾|߾7,aAOE]"l[a4)u@APy[Yo1E(g4Mk]Ϙُ8}lې5#º~;%l08(1ՉkP\
wr& *#?k`U:Z]c#-?(Q?tLƉps3˹1rxW]9cZ/d:=wn._ФCYv
l
gSK`DrJ'@n5fyw>cf<An@ԏ
,kEQV'Ap6-: sK<V,qiu\DM3&.lǜh>m]th6^R(.Ż~vBGTig5*eN-.˖Q(&~cDָ9͹R<+YFXֻEطx/hRꀂ,;[lť0"9rc%Q7Dh3<1qٷ jGuӖ5vK(`pPczqHM
APT9G`mu8G.[~QDt
&Zgs6c4[6
Hrƴ_e
ubz/Z)b\;	H#
4mΧXy(OD?1k\|yƃf܁NX֋,aAOE]"l[a4)u@APy[Yo1E(g4Mk]Ϙُ8}lې5#º~;%l08(1ՉkP\
wr& *#?k`U:Z]c#-?(Q?tLƉps3˹1rxW]9cZ/d:=wn._ФCYv
l
gSK`DrJ'@n5fyw>cf<An@ԏ
,kEQV'Ap6-: sK<V,qiu\DM3&.lǜh>m]th zewcfۥ$     >}N:ν=޾|߾7,aAOE]"l[a4)u@APy[Yo1E(g4Mk]Ϙُ8}lې5#º~;%l08(1ՉkP\
wr& *#?k`U:Z]c#-?(Q?tLƉps3˹1rxW]9cZ/d:=wn._ФCYv
l
gSK`DrJ'@n5fyw>cf<An@ԏ
,kEQV'Ap6-: sK<V,qiu\DM3&.lǜh>m]th6^R(.Ż~vBGTig5*eN-.˖Q(&~cDָ9͹R<+YFXֻEطx/hRꀂ,;[lť0"9rc%Q7Dh3<1qٷ jGuӖ5vK(`pPczqHM
APT9G`mu8G.[~QDt
&Zgs6c4[6
Hrƴ_e
ubz/Z)b\;	H#
4mΧXy(OD?1k\|yƃf܁NX֋,aAOE]"l[a4)u@APy[Yo1E(g4Mk]Ϙُ8}lې5#º~;%l08(1ՉkP\
wr& *#?k`U:Z]c#-?(Q?tLƉps3˹1rxW]9cZ/d:=wn._ФCYv
l
gSK`DrJ'@n5fyw>cf<An@ԏ
,kEQV'Ap6-: sK<V,qiu\DM3&.lǜh>m]th zewcfۥ$     >}N:ν=޾|߾7,aAOE]"l[a4)u@APy[Yo1E(g4Mk]Ϙُ8}lې5#º~;%l08(1ՉkP\
wr& *#?k`U:Z]c#-?(Q?tLƉps3˹1rxW]9cZ/d:=wn._ФCYv
l
gSK`DrJ'@n5fyw>cf<An@ԏ
,kEQV'Ap6-: sK<V,qiu\DM3&.lǜh>m]th6^R(.Ż~vBGTig5*eN-.˖Q(&~cDָ9͹R<+YFXֻEطx/hRꀂ,;[lť0"9rc%Q7Dh3<1qٷ jGuӖ5vK(`pPczqHM
APT9G`mu8G.[~QDt
&Zgs6c4[6
Hrƴ_e
ubz/Z)b\;	H#
4mΧXy(OD?1k\|yƃf܁NX֋,aAOE]"l[a4)u@APy[Yo1E(g4Mk]Ϙُ8}lې5#º~;%l08(1ՉkP\
wr& *#?k`U:Z]c#-?(Q?tLƉps3˹1rxW]9cZ/d:=wn._ФCYv
l
gSK`DrJ'@n5fyw>cf<An@ԏ
,kEQV'Ap6-: sK<V,qiu\DM3&.lǜh>m]th zewcfۥ$     >}N:ν=޾|߾7,aAOE]"l[a4)u@APy[Yo1E(g4Mk]Ϙُ8}lې5#º~;%l08(1ՉkP\
wr& *#?k`U:Z]c#-?(Q?tLƉps3˹1rxW]9cZ/d:=wn._ФCYv
l
gSK`DrJ'@n5fyw>cf<An@ԏ
,kEQV'Ap6-: sK<V,qiu\DM3&.lǜh>m]th6^R(.Ż~vBGTig5*eN-.˖Q(&~cDָ9͹R<+YFXֻEطx/hRꀂ,;[lť0"9rc%Q7Dh3<1qٷ jGuӖ5vK(`pPczqHM
APT9G`mu8G.[~QDt
&Zgs6c4[6
Hrƴ_e
ubz/Z)b\;	H#
4mΧXy(OD?1k\|yƃf܁NX֋,aAOE]"l[a4)u@APy[Yo1E(g4Mk]Ϙُ8}lې5#º~;%l08(1ՉkP\
wr& *#?k`U:Z]c#-?(Q?tLƉps3˹1rxW]9cZ/d:=wn._ФCYv
l
gSK`DrJ'@n5fyw>cf<An@ԏ
,kEQV'Ap6-: sK<V,qiu\DM3&.lǜh>m]th zewcfۥ$     >}N:ν=޾|߾7,aAOE]"l[a4)u@APy[Yo1E(g4Mk]Ϙُ8}lې5#º~;%l08(1ՉkP\
wr& *#?k`U:Z]c#-?(Q?tLƉps3˹1rxW]9cZ/d:=wn._ФCYv
l
gSK`DrJ'@n5fyw>cf<An@ԏ
,kEQV'Ap6-: sK<V,qiu\DM3&.lǜh>m]th6^R(.Ż~vBGTig5*eN-.˖Q(&~cDָ9͹R<+YFXֻEطx/hRꀂ,;[lť0"9rc%Q7Dh3<1qٷ jGuӖ5vK(`pPczqHM
APT9G`mu8G.[~QDt
&Zgs6c4[6
Hrƴ_e
ubz/Z)b\;	H#
4mΧXy(OD?1k\|yƃf܁NX֋,aAOE]"l[a4)u@APy[Yo1E(g4Mk]Ϙُ8}lې5#º~;%l08(1ՉkP\
wr& *#?k`U:Z]c#-?(Q?tLƉps3˹1rxW]9cZ/d:=wn._ФCYv
l
gSK`DrJ'@n5fyw>cf<An@ԏ
,kEQV'Ap6-: sK<V,qiu\DM3&.lǜh>m]th zewcfۥ$     >}N:ν=޾|߾7,aAOE]"l[a4)u@APy[Yo1E(g4Mk]Ϙُ8}lې5#º~;%l08(1ՉkP\
wr& *#?k`U:Z]c#-?(Q?tLƉps3˹1rxW]9cZ/d:=wn._ФCYv
l
gSK`DrJ'@n5fyw>cf<An@ԏ
,kEQV'Ap6-: sK<V,qiu\DM3&.lǜh>m]th6^R(.Ż~vBGTig5*eN-.˖Q(&~cDָ9͹R<+YFXֻEطx/hRꀂ,;[lť0"9rc%Q7Dh3<1qٷ jGuӖ5vK(`pPczqHM
APT9G`mu8G.[~QDt
&Zgs6c4[6
Hrƴ_e
ubz/Z)b\;	H#
4mΧXy(OD?1k\|yƃf܁NX֋,aAOE]"l[a4)u@APy[Yo1E(g4Mk]Ϙُ8}lې5#º~;%l08(1ՉkP\
wr& *#?k`U:Z]c#-?(Q?tLƉps3˹1rxW]9cZ/d:=wn._ФCYv
l
gSK`DrJ'@n5fyw>cf<An@ԏ
,kEQV'Ap6-: sK<V,qiu\DM3&.lǜh>m]th zewcfۥ$     >}N:ν=޾|߾7,aAOE]"l[a4)u@APy[Yo1E(g4Mk]Ϙُ8}lې5#º~;%l08(1ՉkP\
wr& *#?k`U:Z]c#-?(Q?tLƉps3˹1rxW]9cZ/d:=wn._ФCYv
l
gSK`DrJ'@n5fyw>cf<An@ԏ
,kEQV'Ap6-: sK<V,qiu\DM3&.lǜh>m]th6^R(.Ż~vBGTig5*eN-.˖Q(&~cDָ9͹R<+YFXֻEطx/hRꀂ,;[lť0"9rc%Q7Dh3<1qٷ jGuӖ5vK(`pPczqHM
APT9G`mu8G.[~QDt
&Zgs6c4[6
Hrƴ_e
ubz/Z)b\;	H#
4mΧXy(OD?1k\|yƃf܁NX֋,aAOE]"l[a4)u@APy[Yo1E(g4Mk]Ϙُ8}lې5#º~;%l08(1ՉkP\
wr& *#?k`U:Z]c#-?(Q?tLƉps3˹1rxW]9cZ/d:=wn._ФCYv
l
gSK`DrJ'@n5fyw>cf<An@ԏ
,kEQV'Ap6-: sK<V,qiu\DM3&.lǜh>m]th zewcfۥ$     >}N:ν=޾|߾7,aAOE]"l[a4)u@APy[Yo1E(g4Mk]Ϙُ8}lې5#º~;%l08(1ՉkP\
wr& *#?k`U:Z]c#-?(Q?tLƉps3˹1rxW]9cZ/d:=wn._ФCYv
l
gSK`DrJ'@n5fyw>cf<An@ԏ
,kEQV'Ap6-: sK<V,qiu\DM3&.lǜh>m]th6^R(.Ż~vBGTig5*eN-.˖Q(&~cDָ9͹R<+YFXֻEطx/hRꀂ,;[lť0"9rc%Q7Dh3<1qٷ jGuӖ5vK(`pPczqHM
APT9G`mu8G.[~QDt
&Zgs6c4[6
Hrƴ_e
ubz/Z)b\;	H#
4mΧXy(OD?1k\|yƃf܁NX֋,aAOE]"l[a4)u@APy[Yo1E(g4Mk]Ϙُ8}lې5#º~;%l08(1ՉkP\
wr& *#?k`U:Z]c#-?(Q?tLƉps3˹1rxW]9cZ/d:=wn._ФCYv
l
gSK`DrJ'@n5fyw>cf<An@ԏ
,kEQV'Ap6-: sK<V,qiu\DM3&.lǜh>m]th zewcfۥ$     >}N:ν=޾|߾7,aAOE]"l[a4)u@APy[Yo1E(g4Mk]Ϙُ8}lې5#º~;%l08(1ՉkP\
wr& *#?k`U:Z]c#-?(Q?tLƉps3˹1rxW]9cZ/d:=wn._ФCYv
l
gSK`DrJ'@n5fyw>cf<An@ԏ
,kEQV'Ap6-: sK<V,qiu\DM3&.lǜh>m]th6^R(.Ż~vBGTig5*eN-.˖Q(&~cDָ9͹R<+YFXֻEطx/hRꀂ,;[lť0"9rc%Q7Dh3<1qٷ jGuӖ5vK(`pPczqHM
APT9G`mu8G.[~QDt
&Zgs6c4[6
Hrƴ_e
ubz/Z)b\;	H#
4mΧXy(OD?1k\|yƃf܁NX֋,aAOE]"l[a4)u@APy[Yo1E(g4Mk]Ϙُ8}lې5#º~;%l08(1ՉkP\
wr& *#?k`U:Z]c#-?(Q?tLƉps3˹1rxW]9cZ/d:=wn._ФCYv
l
gSK`DrJ'@n5fyw>cf<An@ԏ
,kEQV'Ap6-: sK<V,qiu\DM3&.lǜh>m]th zewcfۥ$     >}N:ν=޾|߾7,aAOE]"l[a4)u@APy[Yo1E(g4Mk]Ϙُ8}lې5#º~;%l08(1ՉkP\
wr& *#?k`U:Z]c#-?(Q?tLƉps3˹1rxW]9cZ/d:=wn._ФCYv
l
gSK`DrJ'@n5fyw>cf<An@ԏ
,kEQV'Ap6-: sK<V,qiu\DM3&.lǜh>m]th6^R(.Ż~vBGTig5*eN-.˖Q(&~cDָ9͹R<+YFXֻEطx/hRꀂ,;[lť0"9rc%Q7Dh3<1qٷ jGuӖ5vK(`pPczqHM
APT9G`mu8G.[~QDt
&Zgs6c4[6
Hrƴ_e
ubz/Z)b\;	H#
4mΧXy(OD?1k\|yƃf܁NX֋,aAOE]"l[a4)u@APy[Yo1E(g4Mk]Ϙُ8}lې5#º~;%l08(1ՉkP\
wr& *#?k`U:Z]c#-?(Q?tLƉps3˹1rxW]9cZ/d:=wn._ФCYv
l
gSK`DrJ'@n5fyw>cf<An@ԏ
,kEQV'Ap6-: sK<V,qiu\DM3&.lǜh>m]th 
