package Bundle::Math::Numeric;
use strict;
use warnings;

$VERSION = '1.00';

1;

__END__

=head1 NAME

Bundle::Math::Numeric - Bundle of modules related to numeric algorithms

=head1 SYNOPSIS

 perl -MCPAN -e 'install Bundle::Math::Numeric'

=head1 CONTENTS

Math::Amoeba

Math::Bezier

Math::Brent

Math::CatmullRom

Math::ConvexHull

Math::Curve::Hilbert

Math::Derivative

Math::ErrorPropagation

Math::FFT

Math::Factor

Math::Fortran

Math::Interpolate

Math::Gradient

Math::LP

Math::LP::Solve

Math::NumberCruncher

Math::Polynomial::Solve

Math::Prime::Simple

Math::Project3D

Math::Project3D::Plot

Math::RungeKutta

Math::TotalBuilder

Math::Trig

Math::Volume::Rotational

Math::WalshTransform

=head1 DESCRIPTION

This is a bundle of modules related to numeric algorithms.

Please have a look at L<Bundle::Math>.

If you would like to see a specific module included in a future version of
this bundle, please send me an email or use rt.cpan.org.

=head1 AUTHOR

Steffen Mueller E<lt>bundlemath-module at steffen-mueller dot netE<gt>

=cut 
