/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.style;

import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.Literal;
import net.sf.saxon.expr.instruct.SequenceInstr;
import net.sf.saxon.expr.parser.RoleDiagnostic;
import net.sf.saxon.expr.parser.TypeChecker;
import net.sf.saxon.ma.map.HashTrieMap;
import net.sf.saxon.ma.map.MapFunctionSet;
import net.sf.saxon.ma.map.MapType;
import net.sf.saxon.om.AttributeCollection;
import net.sf.saxon.style.Compilation;
import net.sf.saxon.style.ComponentDeclaration;
import net.sf.saxon.style.StyleElement;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.value.SequenceType;
import net.sf.saxon.value.StringValue;

public class XSLMap
extends StyleElement {
    Expression select = null;

    public boolean isInstruction() {
        return true;
    }

    protected ItemType getReturnedItemType() {
        return MapType.ANY_MAP_TYPE;
    }

    public boolean mayContainSequenceConstructor() {
        return true;
    }

    public void prepareAttributes() throws XPathException {
        AttributeCollection atts = this.getAttributeList();
        for (int a = 0; a < atts.getLength(); ++a) {
            String f = atts.getQName(a);
            this.checkUnknownAttribute(atts.getNodeName(a));
        }
    }

    public Expression compile(Compilation exec, ComponentDeclaration decl) throws XPathException {
        this.select = this.compileSequenceConstructor(exec, decl, false);
        this.select = this.select.simplify();
        TypeChecker tc = this.getConfiguration().getTypeChecker(false);
        RoleDiagnostic role = new RoleDiagnostic(18, "", 0);
        role.setErrorCode("XTTE3375");
        this.select = tc.staticTypeCheck(this.select, SequenceType.makeSequenceType(MapType.ANY_MAP_TYPE, 57344), role, this.makeExpressionVisitor());
        HashTrieMap options = new HashTrieMap();
        options.initialPut(new StringValue("duplicates"), new StringValue("reject"));
        options.initialPut(new StringValue("duplicates-error-code"), new StringValue("XTDE3365"));
        Expression exp = MapFunctionSet.getInstance().makeFunction("merge", 2).makeFunctionCall(this.select, Literal.makeLiteral(options));
        if (this.getConfiguration().getBooleanProperty("http://saxon.sf.net/feature/strictStreamability")) {
            exp = new SequenceInstr(exp);
        }
        return exp;
    }
}

