/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.lib;

import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.xml.transform.ErrorListener;
import javax.xml.transform.Source;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stream.StreamSource;
import net.sf.saxon.Configuration;
import net.sf.saxon.event.FilterFactory;
import net.sf.saxon.lib.ValidationStatisticsRecipient;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.om.TreeModel;
import net.sf.saxon.type.SchemaType;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.XMLReader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ParseOptions
implements Serializable {
    private int schemaValidation = 0;
    private int dtdValidation = 0;
    private StructuredQName topLevelElement;
    private SchemaType topLevelType;
    private transient XMLReader parser = null;
    private Boolean wrapDocument = null;
    private TreeModel treeModel = null;
    private int stripSpace = 3;
    private Boolean lineNumbering = null;
    private Boolean xIncludeAware = null;
    private boolean pleaseClose = false;
    private transient ErrorListener errorListener = null;
    private transient EntityResolver entityResolver = null;
    private transient ErrorHandler errorHandler = null;
    private List<FilterFactory> filters = null;
    private boolean sourceIsXQJ = false;
    private boolean continueAfterValidationErrors = false;
    private boolean addCommentsAfterValidationErrors = false;
    private boolean expandAttributeDefaults = true;
    private boolean useXsiSchemaLocation = true;
    private boolean checkEntityReferences = false;
    private ValidationStatisticsRecipient validationStatisticsRecipient = null;

    public ParseOptions() {
    }

    public ParseOptions(ParseOptions p) {
        this.schemaValidation = p.schemaValidation;
        this.dtdValidation = p.dtdValidation;
        this.topLevelElement = p.topLevelElement;
        this.topLevelType = p.topLevelType;
        this.parser = p.parser;
        this.wrapDocument = p.wrapDocument;
        this.treeModel = p.treeModel;
        this.stripSpace = p.stripSpace;
        this.lineNumbering = p.lineNumbering;
        this.xIncludeAware = p.xIncludeAware;
        this.pleaseClose = p.pleaseClose;
        this.errorListener = p.errorListener;
        this.entityResolver = p.entityResolver;
        if (p.filters != null) {
            this.filters = new ArrayList<FilterFactory>(p.filters);
        }
        this.sourceIsXQJ = p.sourceIsXQJ;
        this.expandAttributeDefaults = p.expandAttributeDefaults;
        this.useXsiSchemaLocation = p.useXsiSchemaLocation;
        this.continueAfterValidationErrors = p.continueAfterValidationErrors;
        this.addCommentsAfterValidationErrors = p.addCommentsAfterValidationErrors;
    }

    public void merge(ParseOptions options) {
        if (options.dtdValidation != 0) {
            this.dtdValidation = options.dtdValidation;
        }
        if (options.schemaValidation != 0) {
            this.schemaValidation = options.schemaValidation;
        }
        if (options.topLevelElement != null) {
            this.topLevelElement = options.topLevelElement;
        }
        if (options.topLevelType != null) {
            this.topLevelType = options.topLevelType;
        }
        if (options.parser != null) {
            this.parser = options.parser;
        }
        if (options.wrapDocument != null) {
            this.wrapDocument = options.wrapDocument;
        }
        if (options.treeModel != null) {
            this.treeModel = options.treeModel;
        }
        if (options.stripSpace != 3) {
            this.stripSpace = options.stripSpace;
        }
        if (options.lineNumbering != null) {
            this.lineNumbering = options.lineNumbering;
        }
        if (options.xIncludeAware != null) {
            this.xIncludeAware = options.xIncludeAware;
        }
        if (options.pleaseClose) {
            this.pleaseClose = true;
        }
        if (options.errorListener != null) {
            this.errorListener = options.errorListener;
        }
        if (options.entityResolver != null) {
            this.entityResolver = options.entityResolver;
        }
        if (options.filters != null) {
            if (this.filters == null) {
                this.filters = new ArrayList<FilterFactory>();
            }
            this.filters.addAll(options.filters);
        }
        if (options.sourceIsXQJ) {
            this.sourceIsXQJ = true;
        }
        if (!options.expandAttributeDefaults) {
            this.expandAttributeDefaults = false;
        }
        if (!options.useXsiSchemaLocation) {
            this.useXsiSchemaLocation = false;
        }
        if (options.addCommentsAfterValidationErrors) {
            this.addCommentsAfterValidationErrors = true;
        }
    }

    public void applyDefaults(Configuration config) {
        if (this.dtdValidation == 0) {
            int n = this.dtdValidation = config.isValidation() ? 1 : 4;
        }
        if (this.schemaValidation == 0) {
            this.schemaValidation = config.getSchemaValidationMode();
        }
        if (this.treeModel == null) {
            this.treeModel = TreeModel.getTreeModel(config.getTreeModel());
        }
        if (this.stripSpace == 3) {
            this.stripSpace = config.getStripsWhiteSpace();
        }
        if (this.lineNumbering == null) {
            this.lineNumbering = config.isLineNumbering();
        }
        if (this.xIncludeAware == null) {
            this.xIncludeAware = config.isXIncludeAware();
        }
        if (this.errorListener == null) {
            this.errorListener = config.getErrorListener();
        }
    }

    public void addFilter(FilterFactory filterFactory) {
        if (this.filters == null) {
            this.filters = new ArrayList<FilterFactory>(5);
        }
        this.filters.add(filterFactory);
    }

    public List<FilterFactory> getFilters() {
        return this.filters;
    }

    public void setStripSpace(int stripAction) {
        this.stripSpace = stripAction;
    }

    public int getStripSpace() {
        return this.stripSpace == 3 ? 1 : this.stripSpace;
    }

    public void setTreeModel(int model) {
        this.treeModel = TreeModel.getTreeModel(model);
    }

    public int getTreeModel() {
        if (this.treeModel == null) {
            return -1;
        }
        return this.treeModel.getSymbolicValue();
    }

    public void setModel(TreeModel model) {
        this.treeModel = model;
    }

    public TreeModel getModel() {
        return this.treeModel == null ? TreeModel.TINY_TREE : this.treeModel;
    }

    public void setSchemaValidationMode(int option) {
        this.schemaValidation = option;
    }

    public int getSchemaValidationMode() {
        return this.schemaValidation;
    }

    public void setExpandAttributeDefaults(boolean expand) {
        this.expandAttributeDefaults = expand;
    }

    public boolean isExpandAttributeDefaults() {
        return this.expandAttributeDefaults;
    }

    public void setTopLevelElement(StructuredQName elementName) {
        this.topLevelElement = elementName;
    }

    public StructuredQName getTopLevelElement() {
        return this.topLevelElement;
    }

    public void setTopLevelType(SchemaType type) {
        this.topLevelType = type;
    }

    public SchemaType getTopLevelType() {
        return this.topLevelType;
    }

    public void setUseXsiSchemaLocation(boolean use) {
        this.useXsiSchemaLocation = use;
    }

    public boolean isUseXsiSchemaLocation() {
        return this.useXsiSchemaLocation;
    }

    public void setDTDValidationMode(int option) {
        this.dtdValidation = option;
    }

    public int getDTDValidationMode() {
        return this.dtdValidation;
    }

    public void setValidationStatisticsRecipient(ValidationStatisticsRecipient recipient) {
        this.validationStatisticsRecipient = recipient;
    }

    public ValidationStatisticsRecipient getValidationStatisticsRecipient() {
        return this.validationStatisticsRecipient;
    }

    public void setLineNumbering(boolean lineNumbering) {
        this.lineNumbering = lineNumbering;
    }

    public boolean isLineNumbering() {
        return this.lineNumbering != null && this.lineNumbering != false;
    }

    public boolean isLineNumberingSet() {
        return this.lineNumbering != null;
    }

    public void setXMLReader(XMLReader parser) {
        this.parser = parser;
    }

    public XMLReader getXMLReader() {
        return this.parser;
    }

    public void setEntityResolver(EntityResolver resolver) {
        this.entityResolver = resolver;
    }

    public EntityResolver getEntityResolver() {
        return this.entityResolver;
    }

    public void setErrorHandler(ErrorHandler handler) {
        this.errorHandler = handler;
    }

    public ErrorHandler getErrorHandler() {
        return this.errorHandler;
    }

    public void setWrapDocument(Boolean wrap) {
        this.wrapDocument = wrap;
    }

    public Boolean getWrapDocument() {
        return this.wrapDocument;
    }

    public void setXIncludeAware(boolean state) {
        this.xIncludeAware = state;
    }

    public boolean isXIncludeAwareSet() {
        return this.xIncludeAware != null;
    }

    public boolean isXIncludeAware() {
        return this.xIncludeAware != null && this.xIncludeAware != false;
    }

    public void setErrorListener(ErrorListener listener) {
        this.errorListener = listener;
    }

    public ErrorListener getErrorListener() {
        return this.errorListener;
    }

    public void setContinueAfterValidationErrors(boolean keepGoing) {
        this.continueAfterValidationErrors = keepGoing;
    }

    public boolean isContinueAfterValidationErrors() {
        return this.continueAfterValidationErrors;
    }

    public void setAddCommentsAfterValidationErrors(boolean keepGoing) {
        this.addCommentsAfterValidationErrors = keepGoing;
    }

    public boolean isAddCommentsAfterValidationErrors() {
        return this.addCommentsAfterValidationErrors;
    }

    public void setCheckEntityReferences(boolean check) {
        this.checkEntityReferences = check;
    }

    public boolean isCheckEntityReferences() {
        return this.checkEntityReferences;
    }

    public void setPleaseCloseAfterUse(boolean close) {
        this.pleaseClose = close;
    }

    public boolean isPleaseCloseAfterUse() {
        return this.pleaseClose;
    }

    public static void close(Source source) {
        try {
            InputSource is;
            if (source instanceof StreamSource) {
                StreamSource ss = (StreamSource)source;
                if (ss.getInputStream() != null) {
                    ss.getInputStream().close();
                }
                if (ss.getReader() != null) {
                    ss.getReader().close();
                }
            } else if (source instanceof SAXSource && (is = ((SAXSource)source).getInputSource()) != null) {
                if (is.getByteStream() != null) {
                    is.getByteStream().close();
                }
                if (is.getCharacterStream() != null) {
                    is.getCharacterStream().close();
                }
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

