/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.tree.tiny;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.sf.saxon.Configuration;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.expr.sort.IntHashMap;
import net.sf.saxon.om.CopyOptions;
import net.sf.saxon.om.DocumentInfo;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.pattern.NodeKindTest;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.iter.AxisIterator;
import net.sf.saxon.tree.iter.AxisIteratorOverSequence;
import net.sf.saxon.tree.iter.ListIterator;
import net.sf.saxon.tree.iter.SingletonIterator;
import net.sf.saxon.tree.tiny.TinyElementImpl;
import net.sf.saxon.tree.tiny.TinyParentNodeImpl;
import net.sf.saxon.tree.tiny.TinyTree;
import net.sf.saxon.tree.util.FastStringBuffer;
import net.sf.saxon.type.AnyType;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.type.Untyped;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.UntypedAtomicValue;
import net.sf.saxon.value.Value;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class TinyDocumentImpl
extends TinyParentNodeImpl
implements DocumentInfo {
    private HashMap<String, NodeInfo> idTable;
    private IntHashMap<List<TinyElementImpl>> elementList;
    private HashMap<String, String[]> entityTable;
    private HashMap<String, Object> userData;
    private String baseURI;

    public TinyDocumentImpl(TinyTree tree) {
        this.tree = tree;
        this.nodeNr = tree.numberOfNodes;
    }

    @Override
    public TinyTree getTree() {
        return this.tree;
    }

    @Override
    public Configuration getConfiguration() {
        return this.tree.getConfiguration();
    }

    @Override
    public void setSystemId(String uri) {
        this.tree.setSystemId(this.nodeNr, uri);
    }

    @Override
    public String getSystemId() {
        return this.tree.getSystemId(this.nodeNr);
    }

    public void setBaseURI(String uri) {
        this.baseURI = uri;
    }

    @Override
    public String getBaseURI() {
        if (this.baseURI != null) {
            return this.baseURI;
        }
        return this.getSystemId();
    }

    @Override
    public int getLineNumber() {
        return 0;
    }

    @Override
    public boolean isTyped() {
        return this.tree.getTypeCodeArray() != null;
    }

    @Override
    public final int getNodeKind() {
        return 9;
    }

    @Override
    public NodeInfo getParent() {
        return null;
    }

    @Override
    public NodeInfo getRoot() {
        return this;
    }

    @Override
    public DocumentInfo getDocumentRoot() {
        return this;
    }

    @Override
    public void generateId(FastStringBuffer buffer) {
        buffer.append('d');
        buffer.append(Long.toString(this.getDocumentNumber()));
    }

    @Override
    public Value<? extends AtomicValue> atomize() throws XPathException {
        return new UntypedAtomicValue(this.getStringValueCS());
    }

    @Override
    public SequenceIterator<? extends AtomicValue> getTypedValue() throws XPathException {
        return SingletonIterator.makeIterator(new UntypedAtomicValue(this.getStringValueCS()));
    }

    AxisIterator getAllElements(int fingerprint) {
        List<TinyElementImpl> list;
        if (this.elementList == null) {
            this.elementList = new IntHashMap(20);
        }
        if ((list = this.elementList.get(fingerprint)) == null) {
            list = this.getElementList(fingerprint);
            this.elementList.put(fingerprint, list);
        }
        return new AxisIteratorOverSequence<TinyElementImpl>(new ListIterator<TinyElementImpl>(list));
    }

    List<TinyElementImpl> getElementList(int fingerprint) {
        int size = this.tree.getNumberOfNodes() / 20;
        if (size > 100) {
            size = 100;
        }
        if (size < 20) {
            size = 20;
        }
        ArrayList<TinyElementImpl> list = new ArrayList<TinyElementImpl>(size);
        int i = this.nodeNr + 1;
        try {
            while (this.tree.depth[i] != 0) {
                if (this.tree.nodeKind[i] == 1 && (this.tree.nameCode[i] & 0xFFFFF) == fingerprint) {
                    list.add((TinyElementImpl)this.tree.getNode(i));
                }
                ++i;
            }
        }
        catch (ArrayIndexOutOfBoundsException e) {
            return list;
        }
        list.trimToSize();
        return list;
    }

    void registerID(NodeInfo e, String id) {
        NodeInfo old;
        if (this.idTable == null) {
            this.idTable = new HashMap(256);
        }
        if ((old = this.idTable.get(id)) == null) {
            this.idTable.put(id, e);
        }
    }

    @Override
    public NodeInfo selectID(String id, boolean getParent) {
        if (this.idTable == null) {
            return null;
        }
        NodeInfo node = this.idTable.get(id);
        if (node != null && getParent && node.isId() && node.getStringValue().equals(id)) {
            node = node.getParent();
        }
        return node;
    }

    void setUnparsedEntity(String name, String uri, String publicId) {
        if (this.entityTable == null) {
            this.entityTable = new HashMap(20);
        }
        String[] ids = new String[]{uri, publicId};
        this.entityTable.put(name, ids);
    }

    @Override
    public Iterator<String> getUnparsedEntityNames() {
        if (this.entityTable == null) {
            List emptyList = Collections.emptyList();
            return emptyList.iterator();
        }
        return this.entityTable.keySet().iterator();
    }

    @Override
    public String[] getUnparsedEntity(String name) {
        if (this.entityTable == null) {
            return null;
        }
        return this.entityTable.get(name);
    }

    @Override
    public int getTypeAnnotation() {
        AxisIterator children = this.iterateAxis((byte)3, NodeKindTest.ELEMENT);
        Object node = children.next();
        if (node == null || node.getTypeAnnotation() == 630) {
            return 630;
        }
        return 572;
    }

    @Override
    public SchemaType getSchemaType() {
        AxisIterator children = this.iterateAxis((byte)3, NodeKindTest.ELEMENT);
        Object node = children.next();
        if (node == null || node.getTypeAnnotation() == 630) {
            return Untyped.getInstance();
        }
        return AnyType.getInstance();
    }

    @Override
    public void copy(Receiver out, int copyOptions, int locationId) throws XPathException {
        Object n;
        out.startDocument(CopyOptions.getStartDocumentProperties(copyOptions));
        if (this.entityTable != null) {
            for (Map.Entry<String, String[]> entry : this.entityTable.entrySet()) {
                String name = entry.getKey();
                String[] details = entry.getValue();
                String systemId = details[0];
                String publicId = details[1];
                out.setUnparsedEntity(name, systemId, publicId);
            }
        }
        AxisIterator children = this.iterateAxis((byte)3);
        while ((n = children.next()) != null) {
            n.copy(out, copyOptions, locationId);
        }
        out.endDocument();
    }

    public void showSize() {
        this.tree.showSize();
    }

    @Override
    public int hashCode() {
        return (int)this.tree.getDocumentNumber();
    }

    @Override
    public void setUserData(String key, Object value) {
        if (this.userData == null) {
            this.userData = new HashMap(4);
        }
        if (value == null) {
            this.userData.remove(key);
        } else {
            this.userData.put(key, value);
        }
    }

    @Override
    public Object getUserData(String key) {
        if (this.userData == null) {
            return null;
        }
        return this.userData.get(key);
    }
}

