
use Config;
use Devel::CheckLib;

my $use_system_ffi = check_lib(lib => "ffi", header => "ffi.h");
my $pkg_config;

if (!$use_system_ffi && eval { require ExtUtils::PkgConfig }) {
  my %pkg_config = eval { ExtUtils::PkgConfig -> find('libffi') };

  unless ($@) {
    if (check_lib(header => "ffi.h", LIBS => $pkg_config{libs}, INC => $pkg_config{cflags})) {
      $use_system_ffi = 1;
      $pkg_config = \%pkg_config;
    }
  }
}

sub MY::postamble {
  return if $use_system_ffi;

  if ($^O eq 'MSWin32') {
    return "\t$^X -MAlien::MSYS=msys_run -Minc::MSYSConfigure -e \"configure(); msys_run 'make'\"\n\n";
  }

  return <<'MAKE_LIBFFI';
$(MYEXTLIB):
	cd deps/libffi && ./configure MAKEINFO=true --disable-builddir --with-pic && $(MAKE)

.NOTPARALLEL:

MAKE_LIBFFI
}

# This Makefile.PL for FFI-Raw was generated by
# inc::MakeMaker <self>
# and Dist::Zilla::Plugin::MakeMaker::Awesome 0.20.
# Don't edit it but the dist.ini and plugins used to construct it.

use strict;
use warnings;

use 5.010;

use ExtUtils::MakeMaker 6.30;



my %WriteMakefileArgs = (
  "ABSTRACT" => "Perl bindings to the portable FFI library (libffi)",
  "AUTHOR" => "Alessandro Ghedini <alexbio\@cpan.org>",
  "BUILD_REQUIRES" => {},
  "CONFIGURE_REQUIRES" => {
    "Devel::CheckLib" => 0,
    "ExtUtils::MakeMaker" => "6.30"
  },
  "DISTNAME" => "FFI-Raw",
  "EXE_FILES" => [],
  "INC" => "-I. -Ixs -Ideps -Ideps/libffi/include",
  "LICENSE" => "perl",
  "MYEXTLIB" => "deps/libffi/.libs/libffi.a",
  "NAME" => "FFI::Raw",
  "OBJECT" => "\$(O_FILES) deps/libffi/.libs/libffi.a",
  "PREREQ_PM" => {
    "XSLoader" => 0,
    "overload" => 0,
    "strict" => 0,
    "warnings" => 0
  },
  "TEST_REQUIRES" => {
    "Env" => 0,
    "ExtUtils::CBuilder" => 0,
    "File::Basename" => 0,
    "File::Copy" => 0,
    "File::Spec" => 0,
    "File::Temp" => 0,
    "FindBin" => 0,
    "IO::Handle" => 0,
    "IPC::Open3" => 0,
    "Math::BigInt" => 0,
    "POSIX" => 0,
    "Test::More" => 0,
    "Text::ParseWords" => 0,
    "base" => 0,
    "bigint" => 0,
    "lib" => 0
  },
  "VERSION" => "0.31",
  "test" => {
    "TESTS" => "t/*.t"
  }
);

my @libs;

$WriteMakefileArgs{CCFLAGS}   = "$Config{ccflags} $Config{cccdlflags}";
$WriteMakefileArgs{LDDLFLAGS} = "$Config{lddlflags}";

if ($^O eq 'MSWin32' && $Config{cc} =~ /cl(\.exe)?$/) {
  for (@WriteMakefileArgs{'MYEXTLIB','OBJECT'}) {
    s/libffi.a/libffi.lib/;
  }

  $WriteMakefileArgs{CCFLAGS}   .= " -DFFI_BUILDING",
  $WriteMakefileArgs{LDDLFLAGS} .= " psapi.lib";

} elsif ($^O =~ /^(MSWin32|cygwin)$/) {
  push @libs, '-L/usr/lib/w32api' if ($^O eq 'cygwin');
  push @libs, '-lpsapi';
}

if ($^O eq 'openbsd' && !$Config{usethreads}) {
  $WriteMakefileArgs{MYEXTLIB} .= ' /usr/lib/libpthread.a';
}

if ($use_system_ffi) {
  $WriteMakefileArgs{OBJECT} = '$(O_FILES)';

  if ($pkg_config) {
    push @libs, $pkg_config -> {libs};
    $WriteMakefileArgs{CCFLAGS} .= " " . $pkg_config -> {cflags};
  } else {
    push @libs, '-lffi';
  }

  delete $WriteMakefileArgs{MYEXTLIB};
}

$WriteMakefileArgs{LIBS} = "@libs" if @libs;



my %FallbackPrereqs = (
  "Env" => 0,
  "ExtUtils::CBuilder" => 0,
  "File::Basename" => 0,
  "File::Copy" => 0,
  "File::Spec" => 0,
  "File::Temp" => 0,
  "FindBin" => 0,
  "IO::Handle" => 0,
  "IPC::Open3" => 0,
  "Math::BigInt" => 0,
  "POSIX" => 0,
  "Test::More" => 0,
  "Text::ParseWords" => 0,
  "XSLoader" => 0,
  "base" => 0,
  "bigint" => 0,
  "lib" => 0,
  "overload" => 0,
  "strict" => 0,
  "warnings" => 0
);


unless ( eval { ExtUtils::MakeMaker->VERSION(6.63_03) } ) {
  delete $WriteMakefileArgs{TEST_REQUIRES};
  delete $WriteMakefileArgs{BUILD_REQUIRES};
  $WriteMakefileArgs{PREREQ_PM} = \%FallbackPrereqs;
}

delete $WriteMakefileArgs{CONFIGURE_REQUIRES}
  unless eval { ExtUtils::MakeMaker->VERSION(6.52) };

if ( $^O eq 'MSWin32' ) {
	$WriteMakefileArgs{PREREQ_PM}{'Alien::MSYS'} = '0';
}

WriteMakefile(%WriteMakefileArgs);



