use strict;
use warnings;

package App::Embra::Role::FileGatherer;
$App::Embra::Role::FileGatherer::VERSION = '0.001'; # TRIAL
# ABSTRACT: something that adds file to your site

use Method::Signatures;
use Moo::Role;


with 'App::Embra::Role::Plugin';

requires 'gather_files';


method add_file( App::Embra::File $file ) {
    $self->debug( "gathered $file" );
    push @{ $self->embra->files }, $file;
}

1;

__END__

=pod

=encoding UTF-8

=head1 NAME

App::Embra::Role::FileGatherer - something that adds file to your site

=head1 VERSION

version 0.001

=head1 DESCRIPTION

This role should be implemented by any plugin which plans to add files to your site. It provides one method (C<L</add_file>>), and requires plugins provide a C<gather_files> method.

C<gather_files> will be called early in the site collation process, and is expected to call the provided C<L</add_file>> method for each file it wishes to include in the site.

=head1 METHODS

=head2 add_file

    $plugin->add_file( $app_embra_file );

This adds a file to the site.

=head1 AUTHOR

Daniel Holz <dgholz@gmail.com>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2015 by Daniel Holz.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
