use strict;
use warnings;
use Test::More tests => 68;
use Digest::Shabal qw(shabal_384 shabal_384_hex);

my $len = 0;

while (my $line = <DATA>) {
    chomp $line;
    my ($msg, $digest) = split '\|', $line, 2;
    my $data = pack 'H*', $msg;
    $digest = lc $digest;

    if ($len and not $len % 8) {
        my $md = Digest::Shabal->new(384)->add($data)->hexdigest;
        is($md, $digest, "new/add/hexdigest: $len bits of $msg");
        is(
            shabal_384_hex($data), $digest,
            "shabal_384_hex: $len bits of $msg"
        );
        ok(
            shabal_384($data) eq pack('H*', $digest),
            "shabal_384: $len bits of $msg"
        );
    }

    my $md = Digest::Shabal->new(384)->add_bits($data, $len)->hexdigest;
    is($md, $digest, "new/add_bits/hexdigest: $msg");
}
continue { $len++ }

__DATA__
00|FF093D67D22B06A674B5F384719150D617E0FF9C8923569A2AB60CDA886DF63C91A25F33CD71CC22C9EEBC5CD6AEE52A
00|AF3D529BCB924D2A99319B8139BCF3E3059EDB7E59DE4EE8A4066B7338D94D3FBCD7DCB9D36AC15A713285DA8F51D061
C0|A902A1779EEEEF16F18F42ED8D1738B7F0E8DA3AFECE1A2799D7D99A76743F6DDB84C1B8FAB47295E7AFE61EF460D268
C0|0333CC5D2C3D408722A98AC456E1B8E2283719F9BB64757D0C2840EA99115CB41BC91858B244D5791E61D714663E639E
80|3E7CAF8B4B67B7E39F3A240D4F95E2F6F805AD3FD9C64DD8880EF1BC2E055614D52C3A501BA0DB09F6044C0E0D29967F
48|ED1DFE2B9A8B33064F466A030D44D8BF01C09DBFD4385F46923F56CDE445F252C48645AC93A9B043E6A5D5151D158335
50|B0412194B4D6266A86442B1423F56457CBA08AA0C4B37115223D95FE9F7B1C25DED313C2C65EF28D335E5D5C860A6798
98|55C485BA8F1A032530E1534D02B9CB89996E31ADB8C90EA920CD2D6DA0CAC6D879909C22B47A025A74B29E0E81D7B981
CC|DA6E116F4FC2740ABB1308089251582E516C1B0DA5E56492126E3AA8FE4BE1A9CE5D58514CF32A5C1BD9211B535ACFB5
9800|534B359129E4F8603C298802A6C23F9BB93CD656786B50673371A859243BAE8E24D1039B4EC64D06A9B7295769DD004B
9D40|CFAC38B94084E9335926800F06736D9E0D01C062266134CF984115DB480D5CB34CEE994B1ED7E8F581A0811A8B077F14
AA80|16A7F6859AA8A3A608FB186AD271C46A3D2B850E0C5BF2D0F8D9A922E11889225475EB1AE5BD13383B33820464E82AAA
9830|9CC941455B499E780710AA323A320654361FBD5C41FB92143B8682368AB2485B819A0F51AB32A2EB93842B953F239A67
5030|6E5B564F0087DEFE2900DDECDB518C5FDADD7B9255C842B54F5BFB35E41D0A2BE9960771DD662284EF47551B00F443E7
4D24|C4836481C65C2C21431018756B5B36A10AD3DA9B64DE6D193EB90C49BAD3FDA9ED59AEB76310AA991E6AE99F376C2933
CBDE|5309C68D5F47259C334A543F509BFA64BF6E1C04937FD1E78805246645DFA5FF2928F51CE191C66120794E3DEB33DDA0
41FB|F3B641253750A156B84750A9FF6BEAF19B96426F0189DF0A749F792A1A78543CBD419B324BB24D999EBBD188F9CFB62F
4FF400|50512FCD25C68B845ED711A002D5FE9AE50A7EE888131D771C3448BEA4AE8C360EEA525EF3A4654A6689EFF16BECF42A
FD0440|046EADB7DD274306B3FEC9E53EFB4AF1DCF6E5DFBF76C6397899CB7FB68F54A7547C7A14A1740D5A4FE4BBDD2641D959
424D00|10F8DA8FEAE8F34F31F1F77BDCF678BC93E0925639001C9275147553749B90E886CE585EC14BF5CF1DFBDF8C8E756105
3FDEE0|615874B58B9842E1C0B7280E2C2A17792FA6D60938C54D25A11C03E849E83556DDECF3202940DBDA4146F708F1928B65
335768|698167DD7795B1411FE3B1A814A3AEE246BF846B5C64638CAB9A7C5414BED3D3F5F9254F43E2FB404015CA5C8656F923
051E7C|714A829B5EF06628EFF5443B8BDC84A5E58010B839E9887E3F64F51F43EF36093507C4584DE24974807678B012291891
717F8C|1CACC06BDEFC4D13A9F86D021A2F7150E7A576C87DA31D4F5B123633671975CF8E96DC5B32F8855A4B69306880BC44A4
1F877C|796411D75FB36C8025A2F69C1CA0C10F0D88902291C4CEC14375CE73194DEFC91E98A54C09B1E86F10A9641FAC57B916
EB35CF80|6D58B9CC3B9AF8F8239EA0A465E3D4A10A4EBB57110C57517DE2DA7DA07888EF6BA6DBA354CBC323BDAB28943EF2A15A
B406C480|636B5E6D8F70C51895BFEF9BF72F86D89F998AB2BB38DE55F20B3CB5BC55A338A119CAE947A4DE85B64BE7E8260ECDB9
CEE88040|D9D88F6EFD76690BA9B442A99DC00DCB1FEBB1C7CD6DDE6AF0DE23E1D666E0ED033539E3737E7E903F8B629451D93B72
C584DB70|EFCBF2778236D9A595BB72B304786DA00B8DABF7EC89D2F8829212D7DB03545C587821E6EB4218F447C639A9891C925E
53587BC8|3F4D5A3D15B659A48B2281883B16453B3DCCC778B917B3160A9020FCD4A5EB4144AB99444228A3B398470B761FD1329B
69A305B0|0EF1266F5FE770850091CC20DAD5B9036A8BDB311051B869E7B44F98E811EDF118237FDCA08C3F4510A81B6E77AF4386
C9375ECE|EDF7B5A74BB8801A682B784F0AF30969A1A57B328585565971D04AB734E3655154B6F2F5C18CEA910510EB9E4DB2A904
C1ECFDFC|1F4C7DDCE5089DE154CEBA5DEF970903195CA1C45CBDA93A0860E387E65915F9946BFA625065D5C64ECDD3D2D6282042
8D73E8A280|0A238AFB9D24AE2E7D62AE51876BAF600F32EA340EA79A2B37A96071174B02D7AD5FA4CF4B6801A18C841863041DF41C
06F2522080|D52C38390B9C54FE1926A404113FAEA9D9819C648BFA948F7E5E5CF28D014F8ED32E51267FA4E46B9F9181417FA53116
3EF6C36F20|33FE950101AF79DF78AAB2CF8609097B68026B875C605BF2D71D9BC457CF882E7BDD55C56A4119E762185149530321C1
0127A1D340|2932FD766A2664A3D8E6EADE0085914879B57263E704302C7E34AE7CE9AF018A73ACCB2F55E19DB016F977C178B1C6EA
6A6AB6C210|E8E2259D4DD61BBC4ACAA0614E65A58A1C209A6759161879E0A95FAFE40D75504D74C8E978CA55DCB50A75A53E447878
AF3175E160|50B3076D89C641A5CA6A2BF0C6458857FFEF0F0E141D63D3D4D10ABBFD88F5B31F640B82450DC823025F560E85D49B9B
B66609ED86|975C2FA89B4822E441731C6E3F8C5911C955929126863C2793A043353833B223F7A00274AAD0E4EBC7001B1671EE0AA5
21F134AC57|F83540065BBE7716124C7CBB9D1C747311AD13897D015CB65EC658D3BF4FB1A64DEC0A57A5085FFC653DB0C59EC9688E
3DC2AADFFC80|68FA2B05EC8E3BEE75D0CC6EF327812875FD8136BBE99FB3492D467571A2940BA339B310562B83AFFADD88FF0AB0B9D9
9202736D2240|43FA4A5A1CAC30229A41E484D2E4B7061D6FC55999BF4E831C2A5C10EC92006A1951FFAA4433EE6795215B590C807F1A
F219BD629820|A7364ACFE6277EE747B68BB0A64D0749E77175BA2A7844CDE54E1EC2D7C96A232C49D5EA902868B682DDE2F55F2BF6AF
F3511EE2C4B0|441627361B28B1C0A1C85A7B26FEED600938020635A29A03268E1E7ED57E42DA8C7E8E5796A9F640DCBF8CBE6D728635
3ECAB6BF7720|7A82080D7F853FC11BBD372F01F2FF05375030B1BEB0C13EECBB9CED32784B0585408638F5BFC969FED155122E1F2179
CD62F688F498|1CE66CE2FD4E30E656BCCABCABD9308D30DC6F3AD57A33B907502EBCA256C9A686B88DA68639C6E5F5135A1096DE8370
C2CBAA33A9F8|5DB26E5151D3EFDB74687C33A5798D0CDFFFB7AB09FE121AE20CA6C76CE282DC7135F4A1C7511B2715489D0A0410C424
C6F50BB74E29|513353B95143C1C33CF2DAC68D73ED92E3BE052B92F05D246605437078916494E7190CAD974F4F30042CEC5C54C96826
79F1B4CCC62A00|A086F9385AE9C19B5801C4AC7788B18C2985473A98D0A98BA555E064804DBC43E4F2F21C6CC9C948AC4552DA90B8608D
