#!perl

use strict;
use warnings;
use Test::More;

use FIDO::Raw;

is (FIDO::Raw->OPT_OMIT,  0);
is (FIDO::Raw->OPT_FALSE, 1);
is (FIDO::Raw->OPT_TRUE,  2);

is (FIDO::Raw->COSE_ES256, -7);
is (FIDO::Raw->COSE_EDDSA, -8);
is (FIDO::Raw->COSE_ECDH_ES256, -25);
is (FIDO::Raw->COSE_RS256, -257);

is (FIDO::Raw->COSE_KTY_OKP, 1);
is (FIDO::Raw->COSE_KTY_EC2, 2);
is (FIDO::Raw->COSE_KTY_RSA, 3);

is (FIDO::Raw->COSE_P256, 1);
is (FIDO::Raw->COSE_ED25519, 6);

is (FIDO::Raw->EXT_HMAC_SECRET,	1);
is (FIDO::Raw->EXT_CRED_PROTECT, 2);

is (FIDO::Raw->CRED_PROT_UV_OPTIONAL, 1);
is (FIDO::Raw->CRED_PROT_UV_OPTIONAL_WITH_ID, 2);
is (FIDO::Raw->CRED_PROT_UV_REQUIRED, 3);

is (FIDO::Raw->ERR_SUCCESS, 0x00);
is (FIDO::Raw->ERR_INVALID_COMMAND, 0x01);
is (FIDO::Raw->ERR_INVALID_PARAMETER, 0x02);
is (FIDO::Raw->ERR_INVALID_LENGTH, 0x03);
is (FIDO::Raw->ERR_INVALID_SEQ, 0x04);
is (FIDO::Raw->ERR_TIMEOUT, 0x05);
is (FIDO::Raw->ERR_CHANNEL_BUSY, 0x06);
is (FIDO::Raw->ERR_LOCK_REQUIRED, 0x0a);
is (FIDO::Raw->ERR_INVALID_CHANNEL, 0x0b);
is (FIDO::Raw->ERR_CBOR_UNEXPECTED_TYPE, 0x11);
is (FIDO::Raw->ERR_INVALID_CBOR, 0x12);
is (FIDO::Raw->ERR_MISSING_PARAMETER, 0x14);
is (FIDO::Raw->ERR_LIMIT_EXCEEDED, 0x15);
is (FIDO::Raw->ERR_UNSUPPORTED_EXTENSION, 0x16);
is (FIDO::Raw->ERR_CREDENTIAL_EXCLUDED, 0x19);
is (FIDO::Raw->ERR_PROCESSING, 0x21);
is (FIDO::Raw->ERR_INVALID_CREDENTIAL, 0x22);
is (FIDO::Raw->ERR_USER_ACTION_PENDING, 0x23);
is (FIDO::Raw->ERR_OPERATION_PENDING, 0x24);
is (FIDO::Raw->ERR_NO_OPERATIONS, 0x25);
is (FIDO::Raw->ERR_UNSUPPORTED_ALGORITHM, 0x26);
is (FIDO::Raw->ERR_OPERATION_DENIED, 0x27);
is (FIDO::Raw->ERR_KEY_STORE_FULL, 0x28);
is (FIDO::Raw->ERR_NOT_BUSY, 0x29);
is (FIDO::Raw->ERR_NO_OPERATION_PENDING, 0x2a);
is (FIDO::Raw->ERR_UNSUPPORTED_OPTION, 0x2b);
is (FIDO::Raw->ERR_INVALID_OPTION, 0x2c);
is (FIDO::Raw->ERR_KEEPALIVE_CANCEL, 0x2d);
is (FIDO::Raw->ERR_NO_CREDENTIALS, 0x2e);
is (FIDO::Raw->ERR_USER_ACTION_TIMEOUT, 0x2f);
is (FIDO::Raw->ERR_NOT_ALLOWED, 0x30);
is (FIDO::Raw->ERR_PIN_INVALID, 0x31);
is (FIDO::Raw->ERR_PIN_BLOCKED, 0x32);
is (FIDO::Raw->ERR_PIN_AUTH_INVALID, 0x33);
is (FIDO::Raw->ERR_PIN_AUTH_BLOCKED, 0x34);
is (FIDO::Raw->ERR_PIN_NOT_SET, 0x35);
is (FIDO::Raw->ERR_PIN_REQUIRED, 0x36);
is (FIDO::Raw->ERR_PIN_POLICY_VIOLATION, 0x37);
is (FIDO::Raw->ERR_PIN_TOKEN_EXPIRED, 0x38);
is (FIDO::Raw->ERR_REQUEST_TOO_LARGE, 0x39);
is (FIDO::Raw->ERR_ACTION_TIMEOUT, 0x3a);
is (FIDO::Raw->ERR_UP_REQUIRED, 0x3b);
is (FIDO::Raw->ERR_UV_BLOCKED, 0x3c);
is (FIDO::Raw->ERR_ERR_OTHER, 0x7f);
is (FIDO::Raw->ERR_SPEC_LAST, 0xdf);

is (FIDO::Raw->OK, 0);
is (FIDO::Raw->ERR_TX, -1);
is (FIDO::Raw->ERR_RX, -2);
is (FIDO::Raw->ERR_RX_NOT_CBOR, -3);
is (FIDO::Raw->ERR_RX_INVALID_CBOR, -4);
is (FIDO::Raw->ERR_INVALID_PARAM, -5);
is (FIDO::Raw->ERR_INVALID_SIG, -6);
is (FIDO::Raw->ERR_INVALID_ARGUMENT, -7);
is (FIDO::Raw->ERR_USER_PRESENCE_REQUIRED, -8);
is (FIDO::Raw->ERR_INTERNAL, -9);

done_testing;

