package BioX::Wrapper;

use Moose;
use File::Find::Rule;
use File::Basename;
use File::Path qw(make_path remove_tree);
use File::Find::Rule;
use Cwd;

our $VERSION = '1.1';

=head2 Wrapper Options

=cut

=head3 indir

A path to your vcf files can be given, and using File::Find::Rule it will recursively search for vcf or vcf.gz  

=cut

has 'indir' => (
    is => 'rw',
    isa => 'Str|Undef',
    required => 0,
);

=head3 outdir

Path to write out annotation files. It creates the structure

    outdir
        --annovar_interim
        --annovar_final
        --vcf-annotate_interim #If you choose to reannotate VCF file
        --vcf-annotate_final #If you choose to reannotate VCF file

A lot of interim files are created by annovar, and the only one that really matters unless you debugging a new database is the multianno file found in annovar_final

If not given the outdirectory is assumed to be the current working directory.

=cut

has 'outdir' => (
    is => 'rw',
    isa => 'Str',
    required => 1,
    default => sub { return getcwd() },
);

1;
__END__

=encoding utf-8

=head1 NAME

BioX::Wrapper - Base class for BioX::Wrappers 

=head1 SYNOPSIS

  use BioX::Wrapper;

=head1 DESCRIPTION

BioX::Wrapper is

=head1 AUTHOR

Jillian Rowe E<lt>jillian.e.rowe@gmail.comE<gt>

=head1 COPYRIGHT

Copyright 2015- Jillian Rowe

=head1 LICENSE

This library is free software; you can redistribute it and/or modify
it under the same terms as Perl itself.

=head1 SEE ALSO

=cut
