# Generated by default/object.tt
package Paws::SecurityHub::Range;
  use Moose;
  has End => (is => 'ro', isa => 'Int');
  has Start => (is => 'ro', isa => 'Int');
  has StartColumn => (is => 'ro', isa => 'Int');

1;

### main pod documentation begin ###

=head1 NAME

Paws::SecurityHub::Range

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::SecurityHub::Range object:

  $service_obj->Method(Att1 => { End => $value, ..., StartColumn => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::SecurityHub::Range object:

  $result = $service_obj->Method(...);
  $result->Att1->End

=head1 DESCRIPTION

Identifies where the sensitive data begins and ends.

=head1 ATTRIBUTES


=head2 End => Int

The number of lines (for a line range) or characters (for an offset
range) from the beginning of the file to the end of the sensitive data.


=head2 Start => Int

The number of lines (for a line range) or characters (for an offset
range) from the beginning of the file to the end of the sensitive data.


=head2 StartColumn => Int

In the line where the sensitive data starts, the column within the line
where the sensitive data starts.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::SecurityHub>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

