
######################################################################
## $Id: ImageBarSelector.pm 9449 2007-04-25 14:56:42Z spadkins $
######################################################################

package App::Widget::ImageBarSelector;
$VERSION = (q$Revision: 9449 $ =~ /(\d[\d\.]*)/)[0];  # VERSION numbers generated by svn

use App;
use App::Widget::HierSelector;
@ISA = ( "App::Widget::HierSelector" );

use strict;

=head1 NAME

App::Widget::ImageBarSelector - A screen selector widget

=head1 SYNOPSIS

   use App::Widget::ImageBarSelector;

   $name = "get_data";
   $w = App::Widget::ImageBarSelector->new($name);
   print $w->html();

=cut

=head1 DESCRIPTION

This class implements a widget selector which is implemented as a
set of images side-by-side in an image-bar with a padding image
filling out the full width.

=cut

######################################################################
# INITIALIZATION
######################################################################

sub _init {
    &App::sub_entry if ($App::trace);
    my $self = shift;
    $self->SUPER::_init(@_);
    my $node       = $self->{context}{"hotel-selector"}{auth_node}[1];
    if (! $self->get("selected")) {
        $self->select_first();
    }
    &App::sub_exit() if ($App::trace);
}

sub select {
    &App::sub_entry if ($App::trace);
    my ($self, $nodeattrib, $value) = @_;
    my $success = $self->SUPER::select($nodeattrib, $value);
    $self->open_selected_exclusively();
    &App::sub_exit($success) if ($App::trace);
    return($success);
}

sub open_exclusively {
    &App::sub_entry if ($App::trace);
    my ($self, $opennodenumber) = @_;
    #$self->{debug} .= "open_exclusively($opennodenumber)<br>";
    $self->SUPER::open_exclusively($opennodenumber);
    $self->select_first_open_leaf($opennodenumber);
    &App::sub_exit() if ($App::trace);
}

######################################################################
# OUTPUT METHODS
######################################################################

sub html {
    &App::sub_entry if ($App::trace);
    my $self = shift;

    my $context    = $self->{context};
    my $name       = $self->{name};
    my $node       = $self->node_list();
    my $pad        = $self->{pad};
    my $align      = $self->{align};
    my $valign     = $self->{valign};
    my $bar_height = $self->{height};
    my $bar_width  = $self->{width};
    my $bar_background = $self->{background};
    my $theme      = $context->so_get("theme") || $context->{options}{theme} || "app";

    my $html = "";

    my ($nodebase, $nodeidx, $nodenumber, $nodelabel, $parentnodenumber, $nodelevel, $opennodenumber);
    my (@nodeidx, $selected_nodenumber, $w);

    $selected_nodenumber = $self->{selected};
    $selected_nodenumber = $self->get_tag_nodenumber($selected_nodenumber);

    @nodeidx = split(/\./,$selected_nodenumber);

    my $html_url_dir = $context->get_option("html_url_dir");

    $html = "";

    $nodelevel = 0;
    $nodebase = "";
    if (defined $node->{1} && !defined $node->{2}) {
        $nodelevel = 1;
        $nodebase = "1.";
    }
    my $table_opts = ($bar_width) ? " width=\"$bar_width\"" : " width=\"100%\"";
    my $td_opts = "";
    $td_opts .= " align=\"$align\"" if ($align);
    $td_opts .= " valign=\"$valign\"" if ($valign);
    $td_opts .= " height=\"$bar_height\"" if ($bar_height);
    $td_opts .= " width=\"$bar_width\"" if ($bar_width);
    if ($bar_background) {
        $td_opts .= " background=\"$html_url_dir/theme/$theme/$bar_background\"";
    }
    my $auth = $context->authorization();
    my (@args, $auth_name);
    for (; $nodelevel <= $#nodeidx; $nodelevel++) {
        $html .= "\n<!-- ImageBarSelector (BEGIN) -->\n";
        $html .= "<table border=\"0\" cellpadding=\"0\" cellspacing=\"0\"${table_opts}><tr><td${td_opts}>\n";
        $html .= "<table border=\"0\" cellpadding=\"0\" cellspacing=\"0\">\n";
        $html .= "  <tr>";

        $nodeidx = 1;
        $nodenumber = "$nodebase$nodeidx"; # create its node number
        while (defined $node->{$nodenumber}) {

            $auth_name = $node->{$nodenumber}{auth_name};
            if (!$auth_name || $auth->is_authorized("/App/SessionObject/$name/$auth_name")) {
                @args = ();
                push(@args, height => $node->{$nodenumber}{height}) if ($node->{$nodenumber}{height});
                push(@args, width => $node->{$nodenumber}{width}) if ($node->{$nodenumber}{width});
                push(@args, label => $node->{$nodenumber}{label}) if ($node->{$nodenumber}{label});
                push(@args, image => $node->{$nodenumber}{image}) if ($node->{$nodenumber}{image});

                $w = $context->widget("$name-button$nodenumber",
                    class => "App::Widget::ImageButton",
                    volatile     => 1,
                    event_target => $name,
                    event        => "open_exclusively",
                    args         => $nodenumber,
                    @args
                );
                if ($node->{$nodenumber}{open}) {
                    $w->set("selected", 1);
                    $w->set("image", "$html_url_dir/theme/$theme/" . $node->{$nodenumber}{selected_image});
                }
                else {
                    $w->set("selected", 0);
                    $w->set("image", "$html_url_dir/theme/$theme/" . $node->{$nodenumber}{image});
                }
                $html .= "<td>";
                $html .= $w->html();
                $html .= "</td>\n";
                $html .= "<td>&nbsp;</td>\n";
            }

            $nodeidx++;
            $nodenumber = "$nodebase$nodeidx"; # create its node number
        }
        $nodebase .= "$nodeidx[$nodelevel].";
        if ($pad) {
            my $td_dims = "";
            my $image_dims = "";
            if ($pad->{height}) {
                $td_dims    .= " height=\"$pad->{height}\"";
                $image_dims .= " height=\"$pad->{height}\"";
            }
            if ($pad->{width}) {
                $td_dims    .= " width=\"$pad->{width}\"";
                $image_dims .= " width=\"$pad->{width}\"";
            }
            else {
                $td_dims    .= " width=\"99%\"";
                $image_dims .= " width=\"99%\"";
            }
            my $bgimage = "$html_url_dir/theme/$theme/" . $pad->{image};
            $html .= "<td${td_dims} background=\"$bgimage\"><img src=\"$bgimage\" border=\"0\"${image_dims}></td>\n";
        }

        $html .= "  </tr>\n";
        $html .= "</table>\n";
        $html .= "</td></tr></table>\n";
        $html .= "<!-- ImageBarSelector (END) -->\n";
    }

    &App::sub_exit() if ($App::trace);
    $html;
}

1;

