# Generated by default/object.tt
package Paws::NimbleStudio::StudioComponentConfiguration;
  use Moose;
  has ActiveDirectoryConfiguration => (is => 'ro', isa => 'Paws::NimbleStudio::ActiveDirectoryConfiguration', request_name => 'activeDirectoryConfiguration', traits => ['NameInRequest']);
  has ComputeFarmConfiguration => (is => 'ro', isa => 'Paws::NimbleStudio::ComputeFarmConfiguration', request_name => 'computeFarmConfiguration', traits => ['NameInRequest']);
  has LicenseServiceConfiguration => (is => 'ro', isa => 'Paws::NimbleStudio::LicenseServiceConfiguration', request_name => 'licenseServiceConfiguration', traits => ['NameInRequest']);
  has SharedFileSystemConfiguration => (is => 'ro', isa => 'Paws::NimbleStudio::SharedFileSystemConfiguration', request_name => 'sharedFileSystemConfiguration', traits => ['NameInRequest']);

1;

### main pod documentation begin ###

=head1 NAME

Paws::NimbleStudio::StudioComponentConfiguration

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::NimbleStudio::StudioComponentConfiguration object:

  $service_obj->Method(Att1 => { ActiveDirectoryConfiguration => $value, ..., SharedFileSystemConfiguration => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::NimbleStudio::StudioComponentConfiguration object:

  $result = $service_obj->Method(...);
  $result->Att1->ActiveDirectoryConfiguration

=head1 DESCRIPTION

The configuration of the studio component, based on component type.

=head1 ATTRIBUTES


=head2 ActiveDirectoryConfiguration => L<Paws::NimbleStudio::ActiveDirectoryConfiguration>

The configuration for a Microsoft Active Directory (Microsoft AD)
studio resource.


=head2 ComputeFarmConfiguration => L<Paws::NimbleStudio::ComputeFarmConfiguration>

The configuration for a render farm that is associated with a studio
resource.


=head2 LicenseServiceConfiguration => L<Paws::NimbleStudio::LicenseServiceConfiguration>

The configuration for a license service that is associated with a
studio resource.


=head2 SharedFileSystemConfiguration => L<Paws::NimbleStudio::SharedFileSystemConfiguration>

The configuration for a shared file storage system that is associated
with a studio resource.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::NimbleStudio>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

