# Generated by default/object.tt
package Paws::LexModelsV2::StillWaitingResponseSpecification;
  use Moose;
  has AllowInterrupt => (is => 'ro', isa => 'Bool', request_name => 'allowInterrupt', traits => ['NameInRequest']);
  has FrequencyInSeconds => (is => 'ro', isa => 'Int', request_name => 'frequencyInSeconds', traits => ['NameInRequest'], required => 1);
  has MessageGroups => (is => 'ro', isa => 'ArrayRef[Paws::LexModelsV2::MessageGroup]', request_name => 'messageGroups', traits => ['NameInRequest'], required => 1);
  has TimeoutInSeconds => (is => 'ro', isa => 'Int', request_name => 'timeoutInSeconds', traits => ['NameInRequest'], required => 1);

1;

### main pod documentation begin ###

=head1 NAME

Paws::LexModelsV2::StillWaitingResponseSpecification

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::LexModelsV2::StillWaitingResponseSpecification object:

  $service_obj->Method(Att1 => { AllowInterrupt => $value, ..., TimeoutInSeconds => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::LexModelsV2::StillWaitingResponseSpecification object:

  $result = $service_obj->Method(...);
  $result->Att1->AllowInterrupt

=head1 DESCRIPTION

Defines the messages that Amazon Lex sends to a user to remind them
that the bot is waiting for a response.

=head1 ATTRIBUTES


=head2 AllowInterrupt => Bool

Indicates that the user can interrupt the response by speaking while
the message is being played.


=head2 B<REQUIRED> FrequencyInSeconds => Int

How often a message should be sent to the user. Minimum of 1 second,
maximum of 5 minutes.


=head2 B<REQUIRED> MessageGroups => ArrayRef[L<Paws::LexModelsV2::MessageGroup>]

One or more message groups, each containing one or more messages, that
define the prompts that Amazon Lex sends to the user.


=head2 B<REQUIRED> TimeoutInSeconds => Int

If Amazon Lex waits longer than this length of time for a response, it
will stop sending messages.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::LexModelsV2>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

