# Generated by default/object.tt
package Paws::SageMaker::PipelineExecutionStepMetadata;
  use Moose;
  has Callback => (is => 'ro', isa => 'Paws::SageMaker::CallbackStepMetadata');
  has Condition => (is => 'ro', isa => 'Paws::SageMaker::ConditionStepMetadata');
  has Model => (is => 'ro', isa => 'Paws::SageMaker::ModelStepMetadata');
  has ProcessingJob => (is => 'ro', isa => 'Paws::SageMaker::ProcessingJobStepMetadata');
  has RegisterModel => (is => 'ro', isa => 'Paws::SageMaker::RegisterModelStepMetadata');
  has TrainingJob => (is => 'ro', isa => 'Paws::SageMaker::TrainingJobStepMetadata');
  has TransformJob => (is => 'ro', isa => 'Paws::SageMaker::TransformJobStepMetadata');

1;

### main pod documentation begin ###

=head1 NAME

Paws::SageMaker::PipelineExecutionStepMetadata

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::SageMaker::PipelineExecutionStepMetadata object:

  $service_obj->Method(Att1 => { Callback => $value, ..., TransformJob => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::SageMaker::PipelineExecutionStepMetadata object:

  $result = $service_obj->Method(...);
  $result->Att1->Callback

=head1 DESCRIPTION

Metadata for a step execution.

=head1 ATTRIBUTES


=head2 Callback => L<Paws::SageMaker::CallbackStepMetadata>




=head2 Condition => L<Paws::SageMaker::ConditionStepMetadata>

If this is a Condition step metadata object, details on the condition.


=head2 Model => L<Paws::SageMaker::ModelStepMetadata>

Metadata for the Model step.


=head2 ProcessingJob => L<Paws::SageMaker::ProcessingJobStepMetadata>

The Amazon Resource Name (ARN) of the processing job that was run by
this step execution.


=head2 RegisterModel => L<Paws::SageMaker::RegisterModelStepMetadata>

Metadata for the RegisterModel step.


=head2 TrainingJob => L<Paws::SageMaker::TrainingJobStepMetadata>

The Amazon Resource Name (ARN) of the training job that was run by this
step execution.


=head2 TransformJob => L<Paws::SageMaker::TransformJobStepMetadata>

The Amazon Resource Name (ARN) of the transform job that was run by
this step execution.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::SageMaker>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

