package Convert::IBM390::CP01144;

use Convert::IBM390 'set_translation';

use vars qw($VERSION);

$VERSION = '0.26';

sub import {
  set_translation(undef, <<'END EBCDIC');
00 01 02 03 9C 09 86 7F 97 8D 8E 0B 0C 0D 0E 0F
10 11 12 13 9D 0A 08 87 18 19 92 8F 1C 1D 1E 1F
80 81 82 83 84 85 17 1B 88 89 8A 8B 8C 05 06 07
90 91 16 93 94 95 96 04 98 99 9A 9B 14 15 9E 1A
20 A0 E2 E4 7B E1 E3 E5 5C F1 B0 2E 3C 28 2B 21
26 5D EA EB 7D ED EE EF 7E DF E9 24 2A 29 3B 5E
2D 2F C2 C4 C0 C1 C3 C5 C7 D1 F2 2C 25 5F 3E 3F
F8 C9 CA CB C8 CD CE CF CC F9 3A A3 A7 27 3D 22
D8 61 62 63 64 65 66 67 68 69 AB BB F0 FD FE B1
5B 6A 6B 6C 6D 6E 6F 70 71 72 AA BA E6 B8 C6 A4
B5 EC 73 74 75 76 77 78 79 7A A1 BF D0 DD DE AE
A2 23 A5 B7 A9 40 B6 BC BD BE AC 7C AF A8 B4 D7
E0 41 42 43 44 45 46 47 48 49 AD F4 F6 A6 F3 F5
E8 4A 4B 4C 4D 4E 4F 50 51 52 B9 FB FC 60 FA FF
E7 F7 53 54 55 56 57 58 59 5A B2 D4 D6 D2 D3 D5
30 31 32 33 34 35 36 37 38 39 B3 DB DC D9 DA 9F
END EBCDIC
} # end import

__END__

=head1 NAME

Convert::IBM390::CP01144 - EBCDIC Italy (Euro)

=head1 SYNOPSIS

Code Page 01144: EBCDIC Italy (Euro)

     -0 -1 -2 -3 -4 -5 -6 -7 -8 -9 -A -B -C -D -E -F
  0- 00 01 02 03 9C 09 86 7F 97 8D 8E 0B 0C 0D 0E 0F
  1- 10 11 12 13 9D 0A 08 87 18 19 92 8F 1C 1D 1E 1F
  2- 80 81 82 83 84 85 17 1B 88 89 8A 8B 8C 05 06 07
  3- 90 91 16 93 94 95 96 04 98 99 9A 9B 14 15 9E 1A
  4- 20 A0 E2 E4 7B E1 E3 E5 5C F1 B0 2E 3C 28 2B 21
  5- 26 5D EA EB 7D ED EE EF 7E DF E9 24 2A 29 3B 5E
  6- 2D 2F C2 C4 C0 C1 C3 C5 C7 D1 F2 2C 25 5F 3E 3F
  7- F8 C9 CA CB C8 CD CE CF CC F9 3A A3 A7 27 3D 22
  8- D8 61 62 63 64 65 66 67 68 69 AB BB F0 FD FE B1
  9- 5B 6A 6B 6C 6D 6E 6F 70 71 72 AA BA E6 B8 C6 A4
  A- B5 EC 73 74 75 76 77 78 79 7A A1 BF D0 DD DE AE
  B- A2 23 A5 B7 A9 40 B6 BC BD BE AC 7C AF A8 B4 D7
  C- E0 41 42 43 44 45 46 47 48 49 AD F4 F6 A6 F3 F5
  D- E8 4A 4B 4C 4D 4E 4F 50 51 52 B9 FB FC 60 FA FF
  E- E7 F7 53 54 55 56 57 58 59 5A B2 D4 D6 D2 D3 D5
  F- 30 31 32 33 34 35 36 37 38 39 B3 DB DC D9 DA 9F
