# Generated by default/object.tt
package Paws::FSX::UpdateFileSystemWindowsConfiguration;
  use Moose;
  has AuditLogConfiguration => (is => 'ro', isa => 'Paws::FSX::WindowsAuditLogCreateConfiguration');
  has AutomaticBackupRetentionDays => (is => 'ro', isa => 'Int');
  has DailyAutomaticBackupStartTime => (is => 'ro', isa => 'Str');
  has SelfManagedActiveDirectoryConfiguration => (is => 'ro', isa => 'Paws::FSX::SelfManagedActiveDirectoryConfigurationUpdates');
  has ThroughputCapacity => (is => 'ro', isa => 'Int');
  has WeeklyMaintenanceStartTime => (is => 'ro', isa => 'Str');

1;

### main pod documentation begin ###

=head1 NAME

Paws::FSX::UpdateFileSystemWindowsConfiguration

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::FSX::UpdateFileSystemWindowsConfiguration object:

  $service_obj->Method(Att1 => { AuditLogConfiguration => $value, ..., WeeklyMaintenanceStartTime => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::FSX::UpdateFileSystemWindowsConfiguration object:

  $result = $service_obj->Method(...);
  $result->Att1->AuditLogConfiguration

=head1 DESCRIPTION

Updates the configuration for an existing Amazon FSx for Windows File
Server file system. Amazon FSx only overwrites existing properties with
non-null values provided in the request.

=head1 ATTRIBUTES


=head2 AuditLogConfiguration => L<Paws::FSX::WindowsAuditLogCreateConfiguration>

The configuration that Amazon FSx for Windows File Server uses to audit
and log user accesses of files, folders, and file shares on the Amazon
FSx for Windows File Server file system..


=head2 AutomaticBackupRetentionDays => Int

The number of days to retain automatic daily backups. Setting this to
zero (0) disables automatic daily backups. You can retain automatic
daily backups for a maximum of 90 days. For more information, see
Working with Automatic Daily Backups
(https://docs.aws.amazon.com/fsx/latest/WindowsGuide/using-backups.html#automatic-backups).


=head2 DailyAutomaticBackupStartTime => Str

The preferred time to start the daily automatic backup, in the UTC time
zone, for example, C<02:00>


=head2 SelfManagedActiveDirectoryConfiguration => L<Paws::FSX::SelfManagedActiveDirectoryConfigurationUpdates>

The configuration Amazon FSx uses to join the Windows File Server
instance to the self-managed Microsoft AD directory. You cannot make a
self-managed Microsoft AD update request if there is an existing
self-managed Microsoft AD update request in progress.


=head2 ThroughputCapacity => Int

Sets the target value for a file system's throughput capacity, in MB/s,
that you are updating the file system to. Valid values are 8, 16, 32,
64, 128, 256, 512, 1024, 2048. You cannot make a throughput capacity
update request if there is an existing throughput capacity update
request in progress. For more information, see Managing Throughput
Capacity
(https://docs.aws.amazon.com/fsx/latest/WindowsGuide/managing-throughput-capacity.html).


=head2 WeeklyMaintenanceStartTime => Str

The preferred start time to perform weekly maintenance, formatted
d:HH:MM in the UTC time zone. Where d is the weekday number, from 1
through 7, with 1 = Monday and 7 = Sunday.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::FSX>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

