# Generated by default/object.tt
package Paws::IoTWireless::LoRaWANGatewayMetadata;
  use Moose;
  has GatewayEui => (is => 'ro', isa => 'Str');
  has Rssi => (is => 'ro', isa => 'Num');
  has Snr => (is => 'ro', isa => 'Num');

1;

### main pod documentation begin ###

=head1 NAME

Paws::IoTWireless::LoRaWANGatewayMetadata

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::IoTWireless::LoRaWANGatewayMetadata object:

  $service_obj->Method(Att1 => { GatewayEui => $value, ..., Snr => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::IoTWireless::LoRaWANGatewayMetadata object:

  $result = $service_obj->Method(...);
  $result->Att1->GatewayEui

=head1 DESCRIPTION

LoRaWAN gateway metatdata.

=head1 ATTRIBUTES


=head2 GatewayEui => Str

The gateway's EUI value.


=head2 Rssi => Num

The RSSI value.


=head2 Snr => Num

The SNR value.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::IoTWireless>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

