use Test::More 'no_plan';

use List::Maker;

is_deeply [<^10>],  [0,1,2,3,4,5,6,7,8,9]      => '<^10>';
is_deeply [<^1>],   [0]                        => '<^1>';
is_deeply [<^0>],   []                         => '<^0>';
is_deeply [<^-1>],  [0]                        => '<^-1>';
is_deeply [<^-4>],  [0,-1,-2,-3]               => '<^-4>';

is_deeply [<^10 x 2>],  [0,2,4,6,8]            => '<^10 x 2>';
is_deeply [<^1 x 2>],   [0]                    => '<^1 x 2>';
is_deeply [<^0 x 2>],   []                     => '<^0 x 2>';
is_deeply [<^-1 x -2>],  [0]                   => '<^-1 x 2>';
is_deeply [<^-4 x -2>],  [0,-2]                => '<^-4 x 2>';


is_deeply [<^10 : X%2>],  [1,3,5,7,9]           => '<^10 : X%2>';
is_deeply [<^1 : X%2>],   []                    => '<^1 : X%2>';
is_deeply [<^0 : X%2>],   []                    => '<^0 : X%2>';
is_deeply [<^-1 : X%2>],  []                    => '<^-1 : X%2>';
is_deeply [<^-4 : X%2>],  [-1,-3]               => '<^-4 : X%2>';

is_deeply [<^10 x 2 : X%2>],  []                => '<^10 x 2 : X%2>';
is_deeply [<^1 x 2 : X%2>],   []                => '<^1 x 2 : X%2>';
is_deeply [<^0 x 2 : X%2>],   []                => '<^0 x 2 : X%2>';
is_deeply [<^-1 x -2 : X%2>],  []               => '<^-1 x 2 : X%2>';
is_deeply [<^-4 x -2 : X%2>],  []               => '<^-4 x 2 : X%2>';

is_deeply [<^10 x 2 : not X%2>],  [0,2,4,6,8]   => '<^10 x 2 : X%2>';
is_deeply [<^1 x 2 : not X%2>],   [0]           => '<^1 x 2 : X%2>';
is_deeply [<^0 x 2 : not X%2>],   []            => '<^0 x 2 : X%2>';
is_deeply [<^-1 x -2 : not X%2>],  [0]          => '<^-1 x 2 : X%2>';
is_deeply [<^-4 x -2 : not X%2>],  [0,-2]       => '<^-4 x 2 : X%2>';




