# automatically generated file, don't edit



# Copyright 2024 David Cantrell, derived from data from libphonenumber
# http://code.google.com/p/libphonenumber/
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
package Number::Phone::StubCountry::RU;
use base qw(Number::Phone::StubCountry);

use strict;
use warnings;
use utf8;
our $VERSION = 1.20240910191017;

my $formatters = [
                {
                  'format' => '$1-$2-$3',
                  'intl_format' => 'NA',
                  'leading_digits' => '[0-79]',
                  'pattern' => '(\\d{3})(\\d{2})(\\d{2})'
                },
                {
                  'format' => '$1 $2 $3 $4',
                  'leading_digits' => '
            7(?:
              1(?:
                [0-356]2|
                4[29]|
                7|
                8[27]
              )|
              2(?:
                13[03-69]|
                62[013-9]
              )
            )|
            72[1-57-9]2
          ',
                  'national_rule' => '8 ($1)',
                  'pattern' => '(\\d{4})(\\d{2})(\\d{2})(\\d{2})'
                },
                {
                  'format' => '$1 $2 $3 $4',
                  'leading_digits' => '
            7(?:
              1(?:
                0(?:
                  [356]|
                  4[023]
                )|
                [18]|
                2(?:
                  3[013-9]|
                  5
                )|
                3[45]|
                43[013-79]|
                5(?:
                  3[1-8]|
                  4[1-7]|
                  5
                )|
                6(?:
                  3[0-35-9]|
                  [4-6]
                )
              )|
              2(?:
                1(?:
                  3[178]|
                  [45]
                )|
                [24-689]|
                3[35]|
                7[457]
              )
            )|
            7(?:
              14|
              23
            )4[0-8]|
            71(?:
              33|
              45
            )[1-79]
          ',
                  'national_rule' => '8 ($1)',
                  'pattern' => '(\\d{5})(\\d)(\\d{2})(\\d{2})'
                },
                {
                  'format' => '$1 $2 $3',
                  'leading_digits' => '7',
                  'national_rule' => '8 ($1)',
                  'pattern' => '(\\d{3})(\\d{3})(\\d{4})'
                },
                {
                  'format' => '$1 $2-$3-$4',
                  'leading_digits' => '
            [349]|
            8(?:
              [02-7]|
              1[1-8]
            )
          ',
                  'national_rule' => '8 ($1)',
                  'pattern' => '(\\d{3})(\\d{3})(\\d{2})(\\d{2})'
                },
                {
                  'format' => '$1 $2 $3 $4',
                  'leading_digits' => '8',
                  'national_rule' => '8 ($1)',
                  'pattern' => '(\\d{4})(\\d{4})(\\d{3})(\\d{3})'
                }
              ];

my $validators = {
                'fixed_line' => '
          (?:
            3(?:
              0[12]|
              4[1-35-79]|
              5[1-3]|
              65|
              8[1-58]|
              9[0145]
            )|
            4(?:
              01|
              1[1356]|
              2[13467]|
              7[1-5]|
              8[1-7]|
              9[1-689]
            )|
            8(?:
              1[1-8]|
              2[01]|
              3[13-6]|
              4[0-8]|
              5[15]|
              6[1-35-79]|
              7[1-37-9]
            )
          )\\d{7}
        ',
                'geographic' => '
          (?:
            3(?:
              0[12]|
              4[1-35-79]|
              5[1-3]|
              65|
              8[1-58]|
              9[0145]
            )|
            4(?:
              01|
              1[1356]|
              2[13467]|
              7[1-5]|
              8[1-7]|
              9[1-689]
            )|
            8(?:
              1[1-8]|
              2[01]|
              3[13-6]|
              4[0-8]|
              5[15]|
              6[1-35-79]|
              7[1-37-9]
            )
          )\\d{7}
        ',
                'mobile' => '9\\d{9}',
                'pager' => '',
                'personal_number' => '808\\d{7}',
                'specialrate' => '(80[39]\\d{7})',
                'toll_free' => '
          8(?:
            0[04]|
            108\\d{3}
          )\\d{7}
        ',
                'voip' => ''
              };
my %areanames = ();
$areanames{en} = {"7811", "Pskov",
"772436", "Terenozek",
"772252", "Karaul",
"772634", "Zhanatas",
"772838", "Balpyk\ bi",
"7816", "Veliky\ Novgorod",
"771544", "Presnovka",
"772642", "Moiynkum",
"771439", "Torgai",
"772338", "Bozanbai\/Molodezhnyi",
"771532", "Smirnovo",
"771459", "Kostanai\ Region",
"7867", "Republic\ of\ North\ Ossetia",
"772545", "Ikan",
"7847", "Republic\ of\ Kalmykia",
"771135", "Zhanibek",
"772154", "Botakara",
"771635", "Zhaksy",
"772132", "Nurinsky\ District",
"772348", "Kokpekty",
"771235", "Dossor",
"7848", "Tolyatti",
"771542", "Kishkenekol",
"7863", "Rostov",
"771449", "Taranovskoye",
"772632", "Merke",
"77272956", "Talgar",
"7843", "Republic\ of\ Tatarstan",
"772144", "Kiyevka",
"771534", "Sergeyevka",
"772779", "Narynkol",
"740", "Kaliningrad",
"772644", "Karatau",
"771645", "Stepnogorsk",
"77242", "Kyzylorda",
"772935", "Zhetybai",
"772535", "Shardara",
"7494", "Kostroma",
"771145", "Karatobe\ District",
"7475", "Tambov",
"772437", "Zhosaly",
"7812", "St\ Petersburg",
"771039", "Priozersk",
"772439", "Aralsky\ District",
"771642", "Egendykol",
"772932", "Beineu",
"772532", "Abai",
"771037", "Aktogai",
"771142", "Taipak",
"771430", "Arkalyk",
"7384", "Kemerovo",
"771436", "Taranovskoye",
"7821", "Komi\ Republic",
"772544", "Shaulder",
"771838", "Koktobe",
"77102", "Zhezkazgan",
"771134", "Zhympity",
"771232", "Atyrau\ Region",
"772777", "Kegen",
"771040", "Zhairem\ \(GOK\)",
"771456", "Kachar",
"771545", "Zhambylsky\ District",
"772635", "Bauyrzhan\ Mamyshuly",
"7471", "Kursk",
"771447", "Karabalyksky\ District",
"772534", "Zhetysai",
"771144", "Kaztalovka",
"771644", "Arshaly",
"7815", "Murmansk",
"771440", "Amangeldy",
"772934", "Zhanaozen",
"7424", "Sakhalin\ Region",
"771446", "Uzunkolsky\ District",
"7472", "Belgorod",
"772770", "Uzynagash",
"772542", "Asykata",
"771457", "Dzhangildinsky\ District",
"771348", "Shalkarsky\ District",
"772776", "Shelek",
"771132", "Fyodorovka",
"771632", "Zerenda",
"7834", "Republic\ of\ Mordovia",
"771437", "Kamysty",
"771234", "Indernborski",
"77142", "Kostanai",
"772725", "Otegen\ Batyra",
"771036", "Balkhash",
"771535", "Novoishimski",
"771030", "Atasu",
"772334", "Tavricheskoye",
"772842", "Kogaly",
"7813", "Leningrad\ region",
"7851", "Astrakhan",
"772138", "Gabidena\ Mustafina",
"772342", "Katon\-Karagai",
"772834", "Ushtobe",
"771031", "Aksu\-Ayuly",
"772752", "Otegen\ Batyra",
"7818", "Arkhangelsk",
"772638", "Tole\ bi",
"77145834", "Krasnogorsk",
"771441", "Karabalyk",
"772433", "Aralsk",
"7842", "Ulyanovsk",
"7862", "Sochi",
"772771", "Kaskelen",
"771335", "Shalkar",
"7861", "Krasnodar\ Territory",
"771451", "Sarykol",
"772332", "Shemonaikha",
"772148", "Molodezhnoye",
"771041", "Aktau\,\ Zhezkazgan",
"771538", "Beskol",
"7866", "Kabardino\-Balkarian\ Republic",
"7846", "Samara",
"7841", "Penza",
"772344", "Akzhar",
"772832", "Zhansugurov",
"771345", "Karauylkeldy",
"7484", "Kaluga",
"7817", "Vologda",
"77187", "Ekibastuz",
"77245", "Kyzylorda\ Region",
"771845", "Pavlodar\ Area",
"77149", "Kostanai",
"771431", "Rudny",
"772548", "Shayan",
"771834", "Uspenka",
"7869", "Sevastopol",
"771342", "Badamsha",
"771138", "Zhalpaktal",
"7865", "Stavropol\ territory",
"771638", "Akkol",
"771043", "Zhairem",
"771453", "Auliekol",
"771842", "Koktobe",
"7845", "Saratov",
"771334", "Emba",
"7394", "Republic\ of\ Tuva",
"772335", "Zyryanovsk",
"77272983", "Kaskelen",
"7473", "Voronezh",
"772835", "Tekeli",
"771433", "Lisakovsk",
"7855", "Naberezhnye\ Chelny",
"771832", "Irtyshsk",
"771648", "Derzhavinsk",
"771033", "Agadyr",
"772938", "Fort\ Shevchenko",
"771844", "Irtyshsky\ District",
"772538", "Turara\ Ryskulova",
"771332", "Uil",
"771443", "Borovskoi",
"736", "Simferopol",
"772431", "Zhalagash",
"771238", "Miyaly",
"772345", "Shar",
"7390", "Republic\ of\ Khakassia",
"772773", "Bakanas",
"772639", "Saudakent",
"771442", "Fyodorovka",
"7342", "Perm",
"77279", "Almaty",
"77122", "Atyrau",
"771630", "Burabay",
"771434", "Denisovka",
"771636", "Shuchinsk",
"7381", "Omsk",
"7872", "Republic\ of\ Daghestan",
"772540", "Arys",
"771136", "Chapayev",
"772772", "Kapchagai",
"772546", "Sholakkorgan",
"771130", "Peremetnoye",
"771237", "Kulsary",
"7415", "Kamchatka\ Region",
"7301", "Republic\ of\ Buryatia",
"771454", "Karamendy",
"77252", "Shymkent",
"7499", "Moscow",
"772841", "Kapal",
"7351", "Chelyabinsk",
"7495", "Moscow",
"772435", "Zhanakorgan",
"77292", "Aktau",
"771833", "Terenkol",
"772341", "Ulken\ Naryn",
"771147", "Akzhaiksky\ District",
"7474", "Lipetsk",
"771032", "Karazhal",
"772537", "Saryagash",
"772937", "Kuryk",
"771333", "Kandyagash",
"772159", "Karaganda\ Region",
"771647", "Esil",
"7421", "Khabarovsk\ Territory",
"772530", "Temirlanovka",
"771146", "Akzhaiksky\ District",
"771140", "Saikhin",
"772536", "Kentau",
"771444", "Uzunkol",
"771640", "Balkashino",
"771646", "Makinsk",
"7426", "Jewish\ Autonomous\ Region",
"771539", "Beskol",
"7831", "Nizhni\ Novgorod",
"772774", "Talgar",
"7352", "Kurgan",
"7302", "Chita",
"772149", "Osakarovka",
"772351", "Borodulikha",
"7836", "Republic\ of\ Marij\ El",
"771343", "Irgiz",
"771637", "Korgalzhyn",
"771137", "Chingirlau",
"771230", "Atyrau\ Region",
"772331", "Glubokoye",
"771452", "Karasu",
"77185", "Shaldai",
"7382", "Tomsk",
"772547", "Lenger",
"7871", "Chechen\ Republic",
"771042", "Zharyk",
"771236", "Makhambet",
"77162", "Kokshetau\/Krasni\ Yar",
"7341", "Udmurtian\ Republic",
"7820", "Cherepovets",
"771843", "Maisky\ District",
"772239", "Makanchi",
"771034", "Zhezdy",
"7346", "Surgut",
"77135", "Aktobe\ Region",
"77112", "Uralsk",
"772831", "Zharkent",
"772636", "Kordai",
"771455", "Zatobolsk",
"772237", "Ayagoz",
"771546", "Talshik",
"7814", "Republic\ of\ Karelia",
"771540", "Kishkenekol",
"7487", "Tula",
"7492", "Vladimir",
"771639", "Stepnyak",
"771139", "Taskala",
"7835", "Chuvashi\ Republic",
"77222", "Semey",
"772353", "Novaya\ Shulba",
"771537", "Timiryazevo",
"772147", "Egindybulak",
"771341", "Khobda",
"7879", "Mineranye\ Vody",
"772333", "Samarskoye",
"771841", "Aktogai",
"77152", "Petropavlovsk",
"7349", "Yamalo\-Nenets\ Autonomous\ District",
"7345", "Tyumen",
"772833", "Usharal",
"772257", "Shulbinsk",
"771435", "Zhitikara",
"77273", "Almaty",
"772156", "Shakhtinsk",
"771149", "Zelenovsky\ District",
"772539", "Kazygurt",
"772256", "Kainar",
"771649", "Zhaksynsky\ District",
"772432", "Shiyeli",
"771536", "Taiynsha",
"7385", "Altai\ Territory",
"771035", "Ulytau",
"772146", "Karkaralinsk",
"7411", "Republic\ of\ Sakha",
"7712302", "Tengizshevroil",
"7416", "Amur\ Region",
"772640", "Moiynkumsky\ District",
"771445", "Ubaganskoye",
"77274", "Karassaisky\ District",
"772843", "Lepsy",
"77262", "Taraz",
"7491", "Ryazan",
"771831", "Zhelezinka",
"77212", "Karaganda",
"7496", "Moscow",
"7483", "Bryansk",
"771239", "Makat",
"772637", "Sarykemer",
"772343", "Terekty",
"772236", "Beskaragai",
"771547", "Zhambylsky\ District",
"772775", "Esik",
"771331", "Martuk",
"733", "Baikonur",
"772230", "Urdzhar",
"772137", "Saran",
"77125", "Atyrau\ Region",
"772339", "Kurchum",
"7388", "Republic\ of\ Altai",
"7877", "Republic\ of\ Adygeya",
"771836", "Sharbakty",
"771438", "Amangeldy",
"7383", "Novosibirsk",
"772839", "Sarkand",
"771336", "Khromtau",
"771330", "Khromtau\ District",
"7347", "Republic\ of\ Bashkortostan",
"7391", "Krasnoyarsk\ Territory",
"772251", "Kurchatov",
"7717", "Astana",
"7427", "Chukotka\ Autonomous\ District",
"7485", "Yaroslavl",
"7353", "Orenburg",
"771133", "Aksai",
"772543", "Aqsumbe",
"772641", "Akkol",
"771347", "Aitekebisky\ District",
"7712303", "Tengizs",
"771458", "Kostanai\ Region",
"771531", "Bulayevo",
"771633", "Ereimentau",
"771233", "Ganyushkino",
"771346", "Shubarkuduk",
"7423", "Primorie\ territory",
"772778", "Chundzha",
"771340", "Khobdinsky\ District",
"771448", "Oktyabrskoye",
"772759", "Almaty\ Region",
"7833", "Kirov",
"771840", "Bayanaul",
"77106", "Satpaev",
"771337", "Alga",
"77182", "Pavlodar",
"772131", "Abai",
"771038", "Shashubai",
"771643", "Atbasar",
"771541", "Mamlutka",
"7873", "Ingushi\ Republic",
"771143", "Akzhaik",
"772631", "Kulan",
"772533", "Turkestan",
"7878", "Karachayevo\-Cherkessian\ Republic",
"771837", "Aksu",
"77132", "Aktobe\/Kargalinskoye",
"7343", "Ekaterinburg",
"771231", "Akkystau",
"772330", "Zyryanovsky\ District",
"77272", "Almaty",
"772336", "Ridder",
"771839", "Akku",
"7482", "Tver",
"772836", "Karabulak",
"771339", "Komsomolskoye",
"772153", "Topar",
"772830", "Alakolsky\ District",
"772438", "Aiteke\ bi",
"771641", "Astrakhanka",
"771543", "Yavlenka",
"772757", "Akshi",
"772931", "Shetpe",
"772633", "Asa",
"772531", "Aksukent",
"772347", "Kalbatau",
"771141", "Zhangala",
"771349", "Shalkarsky\ District",
"771651", "Kabanbai\ Batyr",
"772840", "Saryozek",
"77213", "Aktau\/Temirtau",
"7395", "Irkutsk",
"7844", "Volgograd",
"772340", "Zaisan",
"7413", "Magadan",
"772346", "Aksuat",
"77232", "Ust\-Kamenogorsk",
"772837", "Kabanbai",
"7481", "Smolensk",
"7486", "Orel",
"772541", "Myrzakent",
"772643", "Shu",
"771131", "Darinskoye",
"77282", "Taldykorgan",
"772337", "Serebryansk",
"771533", "Saumalkol",
"771631", "Shortandy",
"7498", "Moscow",
"77224", "Barshatas",};
$areanames{ru} = {"772156", "Шахтинск",
"7345", "Тюменская\ обл\.",
"772833", "Алакольский\ р\-н",
"771435", "Житикаринский\ р\-н",
"77273", "Алма\-Ата",
"772257", "Шульбинск",
"77152", "Петропавловск",
"7349", "Ямало\-Ненецкий\ АО",
"771841", "Актогайский\ р\-н",
"772333", "Кокпектинский\ р\-н",
"7879", "Ставропольский\ край",
"772147", "Каркаралинский\ р\-н",
"771341", "Хобдинский\ р\-н",
"771537", "Тимирязевский\ р\-н",
"77222", "Семипалатинск",
"772353", "Бородулихинский\ р\-н",
"771139", "Таскалинский\ р\-н",
"7835", "Чувашская\ Республика\ \-\ Чувашия",
"771639", "Енбекшилдерский\ р\-н",
"7492", "Владимирская\ обл\.",
"771540", "Уалихановский\ р\-н",
"7814", "Республика\ Карелия",
"7487", "Тульская\ обл\.",
"771546", "Акжарский\ р\-н",
"772237", "Аязог",
"771455", "Костанайский\ р\-н",
"772636", "Кордай",
"771331", "Мартукский\ р\-н",
"772137", "Сарань",
"733", "Байконыр",
"772230", "Урджарский\ р\-н",
"771547", "Жамбылский\ р\-н",
"772236", "Бескарагайский\ р\-н",
"772775", "Енбекшиказахский\ р\-н",
"772343", "Курчумский\ р\-н",
"772637", "Байзакский\ р\-н",
"7483", "Брянская\ обл\.",
"771239", "Макатский\ р\-н",
"77212", "Караганда",
"771831", "Железинский\ р\-н",
"7496", "г\.\ Москва",
"77262", "Тараз",
"7491", "Рязанская\ обл\.",
"771445", "Алтынсаринский\ р\-н",
"77274", "Карасайский\ р\-н",
"772843", "Лепсы",
"772640", "Мойынкумский\ р\-н",
"7712302", "Тенгизшевройл",
"7416", "Амурская\ обл\.",
"771035", "Улытауский\ р\-н",
"7411", "Республика\ Саха\ \/Якутия\/",
"772146", "Каркаралинск",
"771536", "Тайыншинский\ р\-н",
"7385", "Алтайский\ край",
"771649", "Жаксынский\ р\-н",
"772432", "Шиелийский\ р\-н",
"772256", "Алгабас",
"772539", "Казыгурт",
"771149", "Акжаикский\ р\-н",
"772159", "Карагандинская\ область",
"771647", "Есильский\ р\-н",
"771333", "Мугалжарский\ р\-н",
"772937", "Каракиянский\ р\-н",
"772537", "Сарыагаш",
"7474", "Липецкая\ обл\.",
"771032", "Каражал",
"772341", "Катон\-Карагайский\ р\-н",
"771147", "Акжаикский\ р\-н",
"77292", "Актау",
"7495", "Московская\ обл\.",
"772435", "Жанакорганский\ р\-н",
"771833", "Качирский\ р\-н",
"772841", "Аксуский\ р\-н",
"7351", "Челябинская\ обл\.",
"7499", "г\.\ Москва",
"771454", "Наурзумский\ р\-н",
"7301", "Республика\ Бурятия",
"77252", "Шымкент",
"771237", "Жылыойский\ р\-н",
"7415", "Камчатский\ край",
"771130", "Зеленовский\ р\-н",
"772546", "Шолаккорган",
"7381", "Омская\ обл\.",
"772772", "Капчагай",
"7872", "Республика\ Дагестан",
"772540", "Арыс",
"771136", "Акжаикский\ р\-н",
"771636", "Щучинский\ р\-н",
"771630", "Боровое",
"771434", "Денисовский\ р\-н",
"77122", "Атырау",
"77279", "Алматы",
"7342", "Пермский\ край",
"771442", "Федоровский\ р\-н",
"772639", "Сарысуский\ р\-н",
"771034", "Улытауский\ р\-н",
"772831", "Панфиловский\ р\-н",
"7346", "Ханты\ \-\ Мансийский\ \-\ Югра\ АО",
"77135", "Актюбинская\ область",
"77112", "Уральск",
"772239", "Урджарский\ р\-н",
"771843", "Майский\ р\-н",
"7820", "Вологодская\ обл\.",
"77162", "Кокшетау",
"7341", "Республика\ Удмуртская",
"7382", "Томская\ обл\.",
"7871", "Республика\ Чеченская",
"771042", "Акой",
"771236", "Махамбетский\ р\-н",
"772547", "Ленгер",
"771230", "Атырауская\ область",
"771137", "Чингирлауский\ р\-н",
"77185", "Шалдай",
"771452", "Карасуский\ р\-н",
"772331", "Глубоковский\ р\-н",
"771637", "Коргалжынский\ р\-н",
"771343", "Иргизский\ р\-н",
"7836", "Республика\ Марий\ Эл",
"772351", "Бородулихинский\ р\-н",
"7302", "Забайкальский\ край",
"772149", "Осакаровский\ р\-н",
"771539", "Кызылжарский\ р\-н",
"7831", "Нижегородская\ обл\.",
"772774", "Талгарский\ р\-н",
"7352", "Курганская\ обл\.",
"7426", "Еврейская\ автономная\ обл\.",
"771646", "Буландинский\ р\-н",
"771444", "Узункольский\ р\-н",
"771640", "Сандыктауский\ р\-н",
"772536", "Кентау",
"771140", "Бокейординский\ р\-н",
"771146", "Акжаикский\ р\-н",
"772530", "Темирлановка",
"7421", "Хабаровский\ край",
"772347", "Жарминский\ р\-н",
"771141", "Жангалинский\ р\-н",
"772531", "Аксукент",
"772633", "Жамбылский\ р\-н",
"772757", "Акший",
"772931", "Мангистауский\ р\-н",
"771543", "Есильский\ р\-н",
"771641", "Астраханский\ р\-н",
"772438", "Казалинский\ р\-н",
"772153", "Абайский\ р\-н",
"772830", "Алакольский\ р\-н",
"772836", "Ескельдинский\ р\-н",
"7482", "Тверская\ обл\.",
"771339", "Айтекебийский\ р\-н",
"772336", "Риддер",
"771839", "Лебяжинский\ р\-н",
"771231", "Исатайский\ р\-н",
"77272", "Алма\-Ата",
"772330", "Зыряновский\ р\-н",
"77224", "Эмельтау",
"771631", "Шортандинский\ р\-н",
"771533", "Айыртауский\ р\-н",
"7498", "Московская\ обл\.",
"77282", "Талдыкорган",
"771131", "Зеленовский\ р\-н",
"772337", "Серебрянск",
"772643", "Шуский\ р\-н",
"772541", "Мырзакент",
"7493", "Ивановская\ обл\.",
"7486", "Орловская\ обл\.",
"7481", "Смоленская\ обл\.",
"77232", "Усть\-Каменогорск",
"772837", "Алакольский\ р\-н",
"772346", "Тарбагатайский\ р\-н",
"7413", "Магаданская\ обл\.",
"772340", "Зайсанский\ р\-н",
"7844", "Волгоградская\ обл\.",
"7395", "Иркутская\ обл\.",
"77213", "Темиртау",
"772840", "Кербулакский\ р\-н",
"771651", "Целиноградский\ р\-н",
"771349", "Шалкарский\ р\-н",
"771633", "Ерейментауский\ р\-н",
"771531", "Магжана\ Жумабаева\ р\-н",
"771458", "Костанайская\ область",
"7712303", "Тензиз",
"771347", "Айтекебийский\ р\-н",
"772641", "Таласский\ р\-н",
"772543", "Аксумбе",
"771133", "Бурлинский\ р\-н",
"7353", "Оренбургская\ обл\.",
"7485", "Ярославская\ обл\.",
"7717", "Астана",
"7427", "Чукотский\ АО",
"772251", "Курчатов",
"7347", "Республика\ Башкортостан",
"7391", "Красноярский\ край",
"771330", "Хромтауский\ р\-н",
"772839", "Саркандский\ р\-н",
"7383", "Новосибирская\ обл\.",
"771336", "Хромтауский\ р\-н",
"771438", "Амангельдинский\ р\-н",
"7877", "Республика\ Адыгея",
"7388", "Республика\ Алтай",
"772339", "Курчумский\ р\-н",
"771836", "Щербактинский\ р\-н",
"77125", "Атырауская\ область",
"7343", "Свердловская\ обл",
"771837", "Аксуский\ р\-н",
"77132", "Актобе\/Актюбинск",
"7878", "Республика\ Карачаево\-Черкесская",
"772533", "Туркестан",
"772631", "Турара\ Рыскулова\ р\-н",
"771143", "Теректинский\ р\-н",
"771541", "Мамлютский\ р\-н",
"771038", "Сыры\-Шаган",
"771643", "Атбасарский\ р\-н",
"7873", "Республика\ Ингушетия",
"771337", "Алгинский\ р\-н",
"772131", "Абайский\ р\-н",
"77182", "Павлодар",
"77106", "Сатпаев",
"7833", "Кировская\ обл\.",
"771840", "Баянаульский\ р\-н",
"772759", "Алматинская\ область",
"771448", "Карасуский\ р\-н",
"771340", "Хобдинский\ р\-н",
"7423", "Приморский\ край",
"771346", "Темирский\ р\-н",
"772778", "Уйгурский\ р\-н",
"771233", "Курмангазинский\ р\-н",
"771447", "Карабалыкский\ р\-н",
"7471", "Курская\ обл\.",
"772635", "Жуалынский\ р\-н",
"772777", "Райымбекский\ р\-н",
"771040", "Жайрем\ \(ГОК\)",
"771545", "Жамбылский\ р\-н",
"771456", "Качар",
"771232", "Атырауская\ область",
"77102", "Жезказган",
"771134", "Сырымский\ р\-н",
"772544", "Шаульдер",
"771838", "Майский\ р\-он",
"7384", "Кемеровская\ обл\.",
"7821", "Республика\ Коми",
"771436", "Тарановский\ р\-н",
"771430", "Аркалык",
"771142", "Акжаикский\ р\-н",
"771037", "Актогайский\ р\-н",
"772532", "Абая",
"772932", "Бейнеуский\ р\-н",
"772439", "Аральский\ р\-н",
"771642", "Егиндыкольский\ р\-н",
"771535", "Габита\ Мусрепова\ р\-н",
"771030", "Жана\-Аркинский\ р\-н",
"771036", "Балхаш",
"772725", "Отеген\-Батыр",
"77142", "Костанай",
"771234", "Индерский\ р\-н",
"771437", "Камыстинский\ р\-н",
"7834", "Республика\ Мордовия",
"771632", "Зерендинский\ р\-н",
"771348", "Шалкарский\ р\-н",
"771457", "Джангильдинский\ р\-н",
"771132", "Теректинский\ р\-н",
"772776", "Енбекшиказахский\ р\-н",
"772542", "Асыката",
"772770", "Жамбылский\ р\-н",
"771446", "Узункольский\ р\-н",
"7472", "Белгородская\ обл\.",
"772934", "Жанаозен",
"7424", "Сахалинская\ обл\.",
"771644", "Аршалынский\ р\-н",
"771440", "Амангельдинский\ р\-н",
"7815", "Мурманская\ обл\.",
"771144", "Казталовский\ р\-н",
"772534", "Жетысай",
"772154", "Бухар\-Жырауский\ р\-н",
"771635", "Жаксынский\ р\-н",
"771135", "Жанибекский\ р\-н",
"772545", "Икан",
"7847", "Республика\ Калмыкия",
"7867", "Республика\ Северная\ Осетия\ \-\ Алания",
"771459", "Костанайская\ область",
"771532", "Аккайынский\ р\-н",
"772338", "Уланский\ р\-н",
"771439", "Джангильдинский\ р\-н",
"772642", "Мойынкумский\ р\-н",
"7816", "Новгородская\ обл\.",
"772838", "Коксуский\ р\-н",
"771544", "Жамбылский\ р\-н",
"772634", "Жанатас",
"772252", "Абайский\ р\-н",
"772436", "Сырдарьинский\ р\-н",
"7811", "Псковская\ обл\.",
"771039", "Приозерск",
"7812", "г\.\ Санкт\-Петербург",
"772437", "Кармакшинский\ р\-н",
"7475", "Тамбовская\ обл\.",
"771145", "Каратобинский\ р\-н",
"772535", "Шардара",
"7494", "Костромская\ обл\.",
"77242", "Кызылорда",
"772935", "Каракиянский\ р\-н",
"771645", "Степногорск",
"772644", "Таласский\ р\-н",
"740", "Калининградская\ обл\.",
"771534", "Шал\ Акына\ р\-н",
"772779", "Райымбекский\ р\-н",
"7843", "Республика\ Татарстан",
"77272956", "Талгар",
"772144", "Нуринский\ р\-н",
"771449", "Тарановский\ р\-н",
"772632", "Меркенский\ р\-н",
"7863", "Ростовская\ обл\.",
"7848", "Самарская\ обл\.",
"771542", "Уалихановский\ р\-н",
"772132", "Нуринский\ р\-н",
"771235", "Макатский\ р\-н",
"772348", "Кокпектинский\ р\-н",
"772835", "Текели",
"771433", "Лисаковск",
"7473", "Воронежская\ обл\.",
"77272983", "Каскелен",
"772335", "Зыряновск",
"7394", "Республика\ Тыва",
"771334", "Мугалжарский\ р\-н",
"771842", "Майский\ р\-он",
"7845", "Саратовская\ обл\.",
"771453", "Аулиекольский\ р\-н",
"771043", "Жайрем\ \(поселок\)",
"7865", "Ставропольский\ край",
"771638", "Аккольский\ р\-н",
"771342", "Каргалинский\ р\-н",
"7869", "г\.\ Севастополь",
"771138", "Казталовский\ р\-н",
"772548", "Шаян",
"771834", "Успенский\ р\-н",
"772773", "Балхашский\ р\-н",
"7390", "Республика\ Хакасия",
"772345", "Жарминский\ р\-н",
"771238", "Кзылкогинский\ р\-н",
"772431", "Жалагашский\ р\-н",
"736", "Республика\ Крым",
"771443", "Мендыкаринский\ р\-н",
"771332", "Уилский\ р\-н",
"771844", "Иртышский\ р\-н",
"772538", "имени\ Турара\ Рыскулова",
"772938", "Тупкараганский\ р\-н",
"771033", "Шетский\ р\-н",
"771648", "Жаркаинский\ р\-н",
"771832", "Иртышский\ р\-н",
"7855", "Республика\ Татарстан",
"771335", "Шалкарский\ р\-н",
"772771", "Карасайский\ р\-н",
"7862", "Краснодарский\ край",
"7842", "Ульяновская\ обл\.",
"772433", "Аральский\ р\-н",
"771441", "Карабалыкский\ р\-н",
"77145834", "Красногорск",
"772638", "Шуский\ р\-н",
"7818", "Архангельская\ обл\.",
"772752", "Илийский\ р\-н",
"772834", "Каратальский\ р\-н",
"771031", "Шетский\ р\-н",
"772138", "Бухар\-Жырауский\ р\-н",
"772342", "Катон\-Карагайский\ р\-н",
"7851", "Астраханская\ обл\.",
"7813", "Ленинградская\ обл\.",
"772842", "Кербулакский\ р\-н",
"772334", "Уланский\ р\-н",
"771431", "Рудный",
"77149", "Костанай",
"771845", "Павлодар",
"77245", "Кызылординская\ область",
"7484", "Калужская\ обл\.",
"7817", "Вологодская\ обл\.",
"77187", "Экибастуз",
"771345", "Байганинский\ р\-н",
"772832", "Аксуский\ р\-н",
"7841", "Пензенская\ обл\.",
"772344", "Тарбагатайский\ р\-н",
"7846", "Самарская\ обл\.",
"7866", "Республика\ Кабардино\-Балкарская",
"771538", "Кызылжарский\ р\-н",
"771041", "Актау\,\ Жезказган",
"772332", "Шемонаихинский\ р\-н",
"771451", "Сарыкольский\ р\-н",
"772148", "Осакаровский\ р\-н",
"7861", "Краснодарский\ край",};
my $timezones = {
               '' => [
                       'Asia/Almaty',
                       'Asia/Anadyr',
                       'Asia/Aqtobe',
                       'Asia/Irkutsk',
                       'Asia/Kamchatka',
                       'Asia/Krasnoyarsk',
                       'Asia/Magadan',
                       'Asia/Novosibirsk',
                       'Asia/Omsk',
                       'Asia/Sakhalin',
                       'Asia/Vladivostok',
                       'Asia/Yakutsk',
                       'Asia/Yekaterinburg',
                       'Europe/Bucharest',
                       'Europe/Moscow',
                       'Europe/Samara'
                     ],
               '301' => [
                          'Asia/Irkutsk'
                        ],
               '302' => [
                          'Asia/Yakutsk'
                        ],
               '33' => [
                         'Asia/Almaty'
                       ],
               '34' => [
                         'Asia/Yekaterinburg'
                       ],
               '341' => [
                          'Europe/Samara'
                        ],
               '35' => [
                         'Asia/Yekaterinburg'
                       ],
               '36' => [
                         'Europe/Moscow'
                       ],
               '381' => [
                          'Asia/Omsk'
                        ],
               '382' => [
                          'Asia/Novosibirsk'
                        ],
               '383' => [
                          'Asia/Novosibirsk'
                        ],
               '384' => [
                          'Asia/Krasnoyarsk'
                        ],
               '385' => [
                          'Asia/Krasnoyarsk'
                        ],
               '388' => [
                          'Asia/Krasnoyarsk'
                        ],
               '390' => [
                          'Asia/Krasnoyarsk'
                        ],
               '391' => [
                          'Asia/Krasnoyarsk'
                        ],
               '394' => [
                          'Asia/Krasnoyarsk'
                        ],
               '395' => [
                          'Asia/Irkutsk'
                        ],
               '40' => [
                         'Europe/Bucharest'
                       ],
               '411' => [
                          'Asia/Yakutsk'
                        ],
               '413' => [
                          'Asia/Magadan'
                        ],
               '415' => [
                          'Asia/Kamchatka'
                        ],
               '416' => [
                          'Asia/Yakutsk'
                        ],
               '421' => [
                          'Asia/Vladivostok'
                        ],
               '423' => [
                          'Asia/Vladivostok'
                        ],
               '424' => [
                          'Asia/Sakhalin'
                        ],
               '426' => [
                          'Asia/Vladivostok'
                        ],
               '427' => [
                          'Asia/Anadyr'
                        ],
               '47' => [
                         'Europe/Moscow'
                       ],
               '48' => [
                         'Europe/Moscow'
                       ],
               '49' => [
                         'Europe/Moscow'
                       ],
               '7' => [
                        'Asia/Almaty',
                        'Asia/Aqtobe'
                      ],
               '71' => [
                         'Asia/Almaty'
                       ],
               '711' => [
                          'Asia/Aqtobe'
                        ],
               '712' => [
                          'Asia/Aqtobe'
                        ],
               '713' => [
                          'Asia/Aqtobe'
                        ],
               '72' => [
                         'Asia/Almaty'
                       ],
               '729' => [
                          'Asia/Aqtobe'
                        ],
               '79' => [
                         'Asia/Almaty'
                       ],
               '800' => [
                          'Asia/Almaty',
                          'Asia/Aqtobe',
                          'Europe/Moscow'
                        ],
               '803' => [
                          'Europe/Moscow'
                        ],
               '804' => [
                          'Europe/Moscow'
                        ],
               '808' => [
                          'Asia/Almaty',
                          'Asia/Aqtobe',
                          'Europe/Moscow'
                        ],
               '809' => [
                          'Asia/Almaty',
                          'Asia/Aqtobe',
                          'Europe/Moscow'
                        ],
               '81' => [
                         'Europe/Moscow'
                       ],
               '810' => [
                          'Asia/Almaty',
                          'Asia/Aqtobe',
                          'Europe/Moscow'
                        ],
               '82' => [
                         'Europe/Moscow'
                       ],
               '83' => [
                         'Europe/Moscow'
                       ],
               '840' => [
                          'Europe/Bucharest',
                          'Europe/Moscow'
                        ],
               '841' => [
                          'Europe/Moscow'
                        ],
               '842' => [
                          'Europe/Samara'
                        ],
               '843' => [
                          'Europe/Moscow'
                        ],
               '844' => [
                          'Europe/Moscow'
                        ],
               '845' => [
                          'Europe/Moscow'
                        ],
               '846' => [
                          'Europe/Samara'
                        ],
               '847' => [
                          'Europe/Moscow'
                        ],
               '848' => [
                          'Europe/Samara'
                        ],
               '851' => [
                          'Europe/Samara'
                        ],
               '855' => [
                          'Europe/Moscow'
                        ],
               '86' => [
                         'Europe/Moscow'
                       ],
               '87' => [
                         'Europe/Moscow'
                       ],
               '9' => [
                        'Europe/Moscow'
                      ]
             };

    sub new {
      my $class = shift;
      my $number = shift;
      $number =~ s/(^\+7|\D)//g;
      my $self = bless({ country_code => '7', number => $number, formatters => $formatters, validators => $validators, timezones => $timezones, areanames => \%areanames}, $class);
      return $self if ($self->is_valid());
      $number =~ s/^(?:8)//;
      $self = bless({ country_code => '7', number => $number, formatters => $formatters, validators => $validators, areanames => \%areanames}, $class);
      return $self->is_valid() ? $self : undef;
    }
1;