# $Id: 05_years.t 46 2009-01-24 23:19:13Z roland $
# $Revision: 46 $
# $HeadURL: svn+ssh://ipenburg.xs4all.nl/srv/svnroot/debbie/trunk/Date-Extract-P800Picture/t/05_years.t $
# $Date: 2009-01-25 00:19:13 +0100 (Sun, 25 Jan 2009) $

use Test::More;
BEGIN { plan tests => 36 }

my %years = (
    '00000001.JPG' => [ '2000-01-01T00:00:00', '2000' ],
    '10000001.JPG' => [ '2001-01-01T00:00:00', '2001' ],
    '20000001.JPG' => [ '2002-01-01T00:00:00', '2002' ],
    '30000001.JPG' => [ '2003-01-01T00:00:00', '2003' ],
    '40000001.JPG' => [ '2004-01-01T00:00:00', '2004' ],
    '50000001.JPG' => [ '2005-01-01T00:00:00', '2005' ],
    '60000001.JPG' => [ '2006-01-01T00:00:00', '2006' ],
    '70000001.JPG' => [ '2007-01-01T00:00:00', '2007' ],
    '80000001.JPG' => [ '2008-01-01T00:00:00', '2008' ],
    '90000001.JPG' => [ '2009-01-01T00:00:00', '2009' ],
    'A0000001.JPG' => [ '2010-01-01T00:00:00', '2010' ],
    'B0000001.JPG' => [ '2011-01-01T00:00:00', '2011' ],
    'C0000001.JPG' => [ '2012-01-01T00:00:00', '2012' ],
    'D0000001.JPG' => [ '2013-01-01T00:00:00', '2013' ],
    'E0000001.JPG' => [ '2014-01-01T00:00:00', '2014' ],
    'F0000001.JPG' => [ '2015-01-01T00:00:00', '2015' ],
    'G0000001.JPG' => [ '2016-01-01T00:00:00', '2016' ],
    'H0000001.JPG' => [ '2017-01-01T00:00:00', '2017' ],
    'I0000001.JPG' => [ '2018-01-01T00:00:00', '2018' ],
    'J0000001.JPG' => [ '2019-01-01T00:00:00', '2019' ],
    'K0000001.JPG' => [ '2020-01-01T00:00:00', '2020' ],
    'L0000001.JPG' => [ '2021-01-01T00:00:00', '2021' ],
    'M0000001.JPG' => [ '2022-01-01T00:00:00', '2022' ],
    'N0000001.JPG' => [ '2023-01-01T00:00:00', '2023' ],
    'O0000001.JPG' => [ '2024-01-01T00:00:00', '2024' ],
    'P0000001.JPG' => [ '2025-01-01T00:00:00', '2025' ],
    'Q0000001.JPG' => [ '2026-01-01T00:00:00', '2026' ],
    'R0000001.JPG' => [ '2027-01-01T00:00:00', '2027' ],
    'S0000001.JPG' => [ '2028-01-01T00:00:00', '2028' ],
    'T0000001.JPG' => [ '2029-01-01T00:00:00', '2029' ],
    'U0000001.JPG' => [ '2030-01-01T00:00:00', '2030' ],
    'V0000001.JPG' => [ '2031-01-01T00:00:00', '2031' ],
    'W0000001.JPG' => [ '2032-01-01T00:00:00', '2032' ],
    'X0000001.JPG' => [ '2033-01-01T00:00:00', '2033' ],
    'Y0000001.JPG' => [ '2034-01-01T00:00:00', '2034' ],
    'Z0000001.JPG' => [ '2035-01-01T00:00:00', '2035' ],
);

use Date::Extract::P800Picture;
my $parser = Date::Extract::P800Picture->new();
while ( my ( $filename, $expect ) = each %years ) {
    is( "@{[$parser->extract($filename)]}", $expect->[0], "year " . $expect->[1] );
}
