use Test::More tests => 80;
use strict;
use MARC::Charset;

BEGIN {
    use_ok('MARC::Charset::Hebrew');
}

my $cs = MARC::Charset->new();
$cs->g0( MARC::Charset::Hebrew->new() );

## make sure we were able to set the G1 charset to Hebrew
isa_ok( $cs->g0(), 'MARC::Charset::Hebrew' );

## see if we can use valid Hebrew characters

my %valid = (

chr(0x21)=>chr(0x0021),
chr(0x22)=>chr(0x05F4),
chr(0x23)=>chr(0x0023),
chr(0x24)=>chr(0x0024),
chr(0x25)=>chr(0x0025),
chr(0x26)=>chr(0x0026),
chr(0x27)=>chr(0x05F3),
chr(0x28)=>chr(0x0028),
chr(0x29)=>chr(0x0029),
chr(0x2A)=>chr(0x002A),
chr(0x2B)=>chr(0x002B),
chr(0x2C)=>chr(0x002C),
chr(0x2D)=>chr(0x05BE),
chr(0x2E)=>chr(0x002E),
chr(0x2F)=>chr(0x002F),
chr(0x30)=>chr(0x0030),
chr(0x31)=>chr(0x0031),
chr(0x32)=>chr(0x0032),
chr(0x33)=>chr(0x0033),
chr(0x34)=>chr(0x0034),
chr(0x35)=>chr(0x0035),
chr(0x36)=>chr(0x0036),
chr(0x37)=>chr(0x0037),
chr(0x38)=>chr(0x0038),
chr(0x39)=>chr(0x0039),
chr(0x3A)=>chr(0x003A),
chr(0x3B)=>chr(0x003B),
chr(0x3C)=>chr(0x003C),
chr(0x3D)=>chr(0x003D),
chr(0x3E)=>chr(0x003E),
chr(0x3F)=>chr(0x003F),
chr(0x40)=>chr(0x05B7),
chr(0x41)=>chr(0x05B8),
chr(0x42)=>chr(0x05B6),
chr(0x43)=>chr(0x05B5),
chr(0x45)=>chr(0x05B4),
chr(0x45)=>chr(0x05B9),
chr(0x46)=>chr(0x05BB),
chr(0x47)=>chr(0x05B0),
chr(0x48)=>chr(0x05B2),
chr(0x49)=>chr(0x05B3),
chr(0x4A)=>chr(0x05B1),
chr(0x4B)=>chr(0x05BC),
chr(0x4C)=>chr(0x05BF),
chr(0x4D)=>chr(0x05C1),
chr(0x4E)=>chr(0xFB1E),
chr(0x5B)=>chr(0x005B),
chr(0x5D)=>chr(0x005D),
chr(0x60)=>chr(0x05D0),
chr(0x61)=>chr(0x05D1),
chr(0x62)=>chr(0x05D2),
chr(0x63)=>chr(0x05D3),
chr(0x64)=>chr(0x05D4),
chr(0x65)=>chr(0x05D5),
chr(0x66)=>chr(0x05D6),
chr(0x67)=>chr(0x05D7),
chr(0x68)=>chr(0x05D8),
chr(0x69)=>chr(0x05D9),
chr(0x6A)=>chr(0x05DA),
chr(0x6B)=>chr(0x05DB),
chr(0x6C)=>chr(0x05DC),
chr(0x6D)=>chr(0x05DD),
chr(0x6E)=>chr(0x05DE),
chr(0x6F)=>chr(0x05DF),
chr(0x70)=>chr(0x05E0),
chr(0x71)=>chr(0x05E1),
chr(0x72)=>chr(0x05E2),
chr(0x73)=>chr(0x05E3),
chr(0x74)=>chr(0x05E4),
chr(0x75)=>chr(0x05E5),
chr(0x76)=>chr(0x05E6),
chr(0x77)=>chr(0x05E7),
chr(0x78)=>chr(0x05E8),
chr(0x79)=>chr(0x05E9),
chr(0x7A)=>chr(0x05EA),
chr(0x7B)=>chr(0x05F0),
chr(0x7C)=>chr(0x05F1),
chr(0x7D)=>chr(0x05F2),

);

while ( my($test,$expected) = each %valid ) {
    my $converted = $cs->to_utf8($test);
    is( $converted => $expected,
	'valid Hebrew character chr(0x'.sprintf("%2x",ord($test)).')'
    ); 
}

## and lets try one longish string
my $test = chr(0x4C).chr(0x63).chr(0x63).chr(0x42).chr(0x4B);
my $expected = chr(0x05BF).chr(0x05D3).chr(0x05D3).chr(0x05B6).chr(0x05BC);
is ($cs->to_utf8($test),$expected,'longish Hebrew string');




