package Sah::SchemaR::country::code::alpha3;

our $DATE = '2020-03-08'; # DATE
our $VERSION = '0.008'; # VERSION

our $rschema = ["str",[{description=>"\nAccept only current (not retired) codes. Only alpha-3 codes are accepted.\n\nCode will be converted to lowercase.\n\n",examples=>[{valid=>0,value=>""},{summary=>"Only alpha-3 codes are allowed",valid=>0,value=>"ID"},{valid=>1,validated_value=>"idn",value=>"IDN"},{valid=>0,value=>"xx"},{valid=>0,value=>"xxx"}],in=>["abw","afg","ago","aia","ala","alb","and","are","arg","arm","asm","ata","atf","atg","aus","aut","aze","bdi","bel","ben","bes","bfa","bgd","bgr","bhr","bhs","bih","blm","blr","blz","bmu","bol","bra","brb","brn","btn","bvt","bwa","caf","can","cck","che","chl","chn","civ","cmr","cod","cog","cok","col","com","cpv","cri","cub","cuw","cxr","cym","cyp","cze","deu","dji","dma","dnk","dom","dza","ecu","egy","eri","esh","esp","est","eth","fin","fji","flk","fra","fro","fsm","gab","gbr","geo","ggy","gha","gib","gin","glp","gmb","gnb","gnq","grc","grd","grl","gtm","guf","gum","guy","hkg","hmd","hnd","hrv","hti","hun","idn","imn","ind","iot","irl","irn","irq","isl","isr","ita","jam","jey","jor","jpn","kaz","ken","kgz","khm","kir","kna","kor","kwt","lao","lbn","lbr","lby","lca","lie","lka","lso","ltu","lux","lva","mac","maf","mar","mco","mda","mdg","mdv","mex","mhl","mkd","mli","mlt","mmr","mne","mng","mnp","moz","mrt","msr","mtq","mus","mwi","mys","myt","nam","ncl","ner","nfk","nga","nic","niu","nld","nor","npl","nru","nzl","omn","pak","pan","pcn","per","phl","plw","png","pol","pri","prk","prt","pry","pse","pyf","qat","reu","rou","rus","rwa","sau","sdn","sen","sgp","sgs","shn","sjm","slb","sle","slv","smr","som","spm","srb","ssd","stp","sur","svk","svn","swe","swz","sxm","syc","syr","tca","tcd","tgo","tha","tjk","tkl","tkm","tls","ton","tto","tun","tur","tuv","twn","tza","uga","ukr","umi","ury","usa","uzb","vat","vct","ven","vgb","vir","vnm","vut","wlf","wsm","yem","zaf","zmb","zwe"],match=>"\\A[a-z]{3}\\z",summary=>"Country code (alpha-3)","x.perl.coerce_rules"=>["From_str::to_lower"]}],["str"]];

1;
# ABSTRACT: Country code (alpha-3)

__END__

=pod

=encoding UTF-8

=head1 NAME

Sah::SchemaR::country::code::alpha3 - Country code (alpha-3)

=head1 VERSION

This document describes version 0.008 of Sah::SchemaR::country::code::alpha3 (from Perl distribution Sah-Schemas-Country), released on 2020-03-08.

=head1 DESCRIPTION

This module is automatically generated by Dist::Zilla::Plugin::Sah::Schemas during distribution build.

A Sah::SchemaR::* module is useful if a client wants to quickly lookup the base type of a schema without having to do any extra resolving. With Sah::Schema::*, one might need to do several lookups if a schema is based on another schema, and so on. Compare for example L<Sah::Schema::poseven> vs L<Sah::SchemaR::poseven>, where in Sah::SchemaR::poseven one can immediately get that the base type is C<int>. Currently L<Perinci::Sub::Complete> uses Sah::SchemaR::* instead of Sah::Schema::* for reduced startup overhead when doing tab completion.

=head1 HOMEPAGE

Please visit the project's homepage at L<https://metacpan.org/release/Sah-Schemas-Country>.

=head1 SOURCE

Source repository is at L<https://github.com/perlancar/perl-Sah-Schemas-Country>.

=head1 BUGS

Please report any bugs or feature requests on the bugtracker website L<https://rt.cpan.org/Public/Dist/Display.html?Name=Sah-Schemas-Country>

When submitting a bug or request, please include a test-file or a
patch to an existing test-file that illustrates the bug or desired
feature.

=head1 AUTHOR

perlancar <perlancar@cpan.org>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2020, 2019, 2018 by perlancar@cpan.org.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
