# Generated by default/object.tt
package Paws::GuardDuty::AccountLevelPermissions;
  use Moose;
  has BlockPublicAccess => (is => 'ro', isa => 'Paws::GuardDuty::BlockPublicAccess', request_name => 'blockPublicAccess', traits => ['NameInRequest']);

1;

### main pod documentation begin ###

=head1 NAME

Paws::GuardDuty::AccountLevelPermissions

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::GuardDuty::AccountLevelPermissions object:

  $service_obj->Method(Att1 => { BlockPublicAccess => $value, ..., BlockPublicAccess => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::GuardDuty::AccountLevelPermissions object:

  $result = $service_obj->Method(...);
  $result->Att1->BlockPublicAccess

=head1 DESCRIPTION

Contains information about the account level permissions on the S3
bucket.

=head1 ATTRIBUTES


=head2 BlockPublicAccess => L<Paws::GuardDuty::BlockPublicAccess>

Describes the S3 Block Public Access settings of the bucket's parent
account.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::GuardDuty>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

