# Generated by default/object.tt
package Paws::ConnectParticipant::AttachmentItem;
  use Moose;
  has AttachmentId => (is => 'ro', isa => 'Str');
  has AttachmentName => (is => 'ro', isa => 'Str');
  has ContentType => (is => 'ro', isa => 'Str');
  has Status => (is => 'ro', isa => 'Str');

1;

### main pod documentation begin ###

=head1 NAME

Paws::ConnectParticipant::AttachmentItem

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::ConnectParticipant::AttachmentItem object:

  $service_obj->Method(Att1 => { AttachmentId => $value, ..., Status => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::ConnectParticipant::AttachmentItem object:

  $result = $service_obj->Method(...);
  $result->Att1->AttachmentId

=head1 DESCRIPTION

The case-insensitive input to indicate standard MIME type that
describes the format of the file that will be uploaded.

=head1 ATTRIBUTES


=head2 AttachmentId => Str

A unique identifier for the attachment.


=head2 AttachmentName => Str

A case-sensitive name of the attachment being uploaded.


=head2 ContentType => Str

Describes the MIME file type of the attachment. For a list of supported
file types, see Feature specifications
(https://docs.aws.amazon.com/connect/latest/adminguide/amazon-connect-service-limits.html#feature-limits)
in the I<Amazon Connect Administrator Guide>.


=head2 Status => Str

Status of the attachment.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::ConnectParticipant>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

