# Generated by default/object.tt
package Paws::Lambda::SourceAccessConfiguration;
  use Moose;
  has Type => (is => 'ro', isa => 'Str');
  has URI => (is => 'ro', isa => 'Str');

1;

### main pod documentation begin ###

=head1 NAME

Paws::Lambda::SourceAccessConfiguration

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::Lambda::SourceAccessConfiguration object:

  $service_obj->Method(Att1 => { Type => $value, ..., URI => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::Lambda::SourceAccessConfiguration object:

  $result = $service_obj->Method(...);
  $result->Att1->Type

=head1 DESCRIPTION

You can specify the authentication protocol, or the VPC components to
secure access to your event source.

=head1 ATTRIBUTES


=head2 Type => Str

The type of authentication protocol or the VPC components for your
event source. For example: C<"Type":"SASL_SCRAM_512_AUTH">.

=over

=item *

C<BASIC_AUTH> - (MQ) The Secrets Manager secret that stores your broker
credentials.

=item *

C<VPC_SUBNET> - The subnets associated with your VPC. Lambda connects
to these subnets to fetch data from your Self-Managed Apache Kafka
cluster.

=item *

C<VPC_SECURITY_GROUP> - The VPC security group used to manage access to
your Self-Managed Apache Kafka brokers.

=item *

C<SASL_SCRAM_256_AUTH> - The Secrets Manager ARN of your secret key
used for SASL SCRAM-256 authentication of your Self-Managed Apache
Kafka brokers.

=item *

C<SASL_SCRAM_512_AUTH> - The Secrets Manager ARN of your secret key
used for SASL SCRAM-512 authentication of your Self-Managed Apache
Kafka brokers.

=item *

C<VIRTUAL_HOST> - The name of the virtual host in your RabbitMQ broker.
Lambda will use this host as the event source.

=back



=head2 URI => Str

The value for your chosen configuration in C<Type>. For example:
C<"URI":
"arn:aws:secretsmanager:us-east-1:01234567890:secret:MyBrokerSecretName">.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::Lambda>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

