/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.tree.wrapper;

import net.sf.saxon.Configuration;
import net.sf.saxon.expr.parser.Location;
import net.sf.saxon.om.AtomicSequence;
import net.sf.saxon.om.NamespaceBinding;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.TreeInfo;
import net.sf.saxon.pattern.NodeTest;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.iter.AxisIterator;
import net.sf.saxon.tree.iter.SingletonIterator;
import net.sf.saxon.tree.util.FastStringBuffer;
import net.sf.saxon.tree.util.Navigator;
import net.sf.saxon.tree.wrapper.VirtualNode;
import net.sf.saxon.type.SchemaType;

public abstract class AbstractVirtualNode
implements VirtualNode {
    protected NodeInfo node;
    protected AbstractVirtualNode parent;
    protected TreeInfo docWrapper;

    public TreeInfo getTreeInfo() {
        return this.docWrapper;
    }

    public NodeInfo head() {
        return this;
    }

    public SequenceIterator iterate() {
        return SingletonIterator.makeIterator(this);
    }

    public NodeInfo getUnderlyingNode() {
        return this.node;
    }

    public int getFingerprint() {
        if (this.node.hasFingerprint()) {
            return this.node.getFingerprint();
        }
        throw new UnsupportedOperationException();
    }

    public boolean hasFingerprint() {
        return this.node.hasFingerprint();
    }

    public Object getRealNode() {
        Object u = this;
        while ((u = ((VirtualNode)u).getUnderlyingNode()) instanceof VirtualNode) {
        }
        return u;
    }

    public Configuration getConfiguration() {
        return this.getTreeInfo().getConfiguration();
    }

    public int getNodeKind() {
        return this.node.getNodeKind();
    }

    public AtomicSequence atomize() throws XPathException {
        return this.node.atomize();
    }

    public SchemaType getSchemaType() {
        return this.node.getSchemaType();
    }

    public boolean isSameNodeInfo(NodeInfo other) {
        if (other instanceof AbstractVirtualNode) {
            return this.node.isSameNodeInfo(((AbstractVirtualNode)other).node);
        }
        return this.node.isSameNodeInfo(other);
    }

    public boolean equals(Object other) {
        return other instanceof NodeInfo && this.isSameNodeInfo((NodeInfo)other);
    }

    public int hashCode() {
        return this.node.hashCode() ^ 0x3C3C3C3C;
    }

    public String getSystemId() {
        return this.node.getSystemId();
    }

    public void setSystemId(String uri) {
        this.node.setSystemId(uri);
    }

    public String getPublicId() {
        return null;
    }

    public String getBaseURI() {
        return this.node.getBaseURI();
    }

    public int getLineNumber() {
        return this.node.getLineNumber();
    }

    public int getColumnNumber() {
        return this.node.getColumnNumber();
    }

    public Location saveLocation() {
        return this;
    }

    public int compareOrder(NodeInfo other) {
        if (other instanceof AbstractVirtualNode) {
            return this.node.compareOrder(((AbstractVirtualNode)other).node);
        }
        return this.node.compareOrder(other);
    }

    public int comparePosition(NodeInfo other) {
        if (other instanceof AbstractVirtualNode) {
            return this.node.comparePosition(((AbstractVirtualNode)other).node);
        }
        return this.node.comparePosition(other);
    }

    public final String getStringValue() {
        return this.getStringValueCS().toString();
    }

    public CharSequence getStringValueCS() {
        return this.node.getStringValueCS();
    }

    public String getLocalPart() {
        return this.node.getLocalPart();
    }

    public String getURI() {
        return this.node.getURI();
    }

    public String getPrefix() {
        return this.node.getPrefix();
    }

    public String getDisplayName() {
        return this.node.getDisplayName();
    }

    public AxisIterator iterateAxis(byte axisNumber, NodeTest nodeTest) {
        return new Navigator.AxisFilter(this.iterateAxis(axisNumber), nodeTest);
    }

    public String getAttributeValue(String uri, String local) {
        return this.node.getAttributeValue(uri, local);
    }

    public NodeInfo getRoot() {
        NodeInfo p = this;
        NodeInfo q;
        while ((q = p.getParent()) != null) {
            p = q;
        }
        return p;
    }

    public boolean hasChildNodes() {
        return this.node.hasChildNodes();
    }

    public void generateId(FastStringBuffer buffer) {
        this.node.generateId(buffer);
    }

    public NamespaceBinding[] getDeclaredNamespaces(NamespaceBinding[] buffer) {
        return this.node.getDeclaredNamespaces(buffer);
    }

    public boolean isId() {
        return this.node.isId();
    }

    public boolean isIdref() {
        return this.node.isIdref();
    }

    public boolean isNilled() {
        return this.node.isNilled();
    }

    public boolean isStreamed() {
        return false;
    }
}

