/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.util.concurrent;

import edu.stanford.nlp.util.concurrent.ThreadsafeProcessor;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.PriorityBlockingQueue;

public class MulticoreWrapper<I, O> {
    private final int nThreads;
    private int lastSubmittedId = 0;
    private int lastReturnedId = -1;
    private final PriorityBlockingQueue<QueueItem<O>> outputQueue;
    private final ExecutorService threadPool;
    private final List<Future<O>> submits;
    private final int[] submitIds;
    private final List<ThreadsafeProcessor<I, O>> processorList;
    private static final int WARN_AFTER_QUEUE_SIZE = 1000;
    private final Random random = new Random();

    public MulticoreWrapper(int nThreads, ThreadsafeProcessor<I, O> processor) {
        this.nThreads = nThreads;
        this.outputQueue = new PriorityBlockingQueue(10 * nThreads);
        this.threadPool = Executors.newFixedThreadPool(nThreads);
        this.submits = new ArrayList<Future<O>>(nThreads);
        this.submitIds = new int[nThreads];
        this.processorList = new ArrayList<ThreadsafeProcessor<I, O>>(nThreads);
        this.processorList.add(processor);
        this.submits.add(null);
        for (int i = 1; i < nThreads; ++i) {
            this.processorList.add(processor.newInstance());
            this.submits.add(null);
        }
    }

    /*
     * Unable to fully structure code
     */
    public void submit(I inputInstance) {
        while (true) {
            for (i = 0; i < this.nThreads; ++i) {
                if (this.submits.get(i) != null && this.submits.get(i).isDone()) {
                    this.blockingGetResult(i);
                }
                if (this.submits.get(i) != null) continue;
                ++this.lastSubmittedId;
                this.submits.set(i, this.threadPool.submit(new CallableJob<I, O>(inputInstance, this.processorList.get(i))));
                return;
            }
            this.blockingGetResult(this.random.nextInt(this.nThreads));
            if (this.outputQueue.size() <= 1000) ** continue;
            System.err.printf("%s: WARNING: Output queue contains %d items.%n", new Object[]{this.getClass().getName(), this.outputQueue.size()});
        }
    }

    private void blockingGetResult(int processorId) {
        if (this.submits.get(processorId) == null) {
            return;
        }
        try {
            O result = this.submits.get(processorId).get();
            QueueItem<O> resultItem = new QueueItem<O>(result, this.submitIds[processorId]);
            this.outputQueue.add(resultItem);
            this.submits.set(processorId, null);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        catch (ExecutionException e) {
            e.printStackTrace();
        }
    }

    public boolean join() {
        for (int i = 0; i < this.nThreads; ++i) {
            this.blockingGetResult(i);
        }
        this.threadPool.shutdown();
        return this.lastSubmittedId - 1 == this.lastReturnedId;
    }

    public boolean hasNext() {
        if (this.outputQueue.isEmpty()) {
            return false;
        }
        int nextId = this.outputQueue.peek().getId();
        return nextId == this.lastReturnedId + 1;
    }

    public O next() {
        if (!this.hasNext()) {
            return null;
        }
        ++this.lastReturnedId;
        QueueItem<O> result = this.outputQueue.poll();
        return result.getItem();
    }

    private static class QueueItem<O>
    implements Comparable<QueueItem<O>> {
        private final int id;
        private final O item;

        public QueueItem(O item, int id) {
            this.item = item;
            this.id = id;
        }

        public int getId() {
            return this.id;
        }

        public O getItem() {
            return this.item;
        }

        @Override
        public int compareTo(QueueItem<O> other) {
            return this.id - other.id;
        }

        public boolean equals(Object other) {
            if (other == this) {
                return true;
            }
            if (!(other instanceof QueueItem)) {
                return false;
            }
            QueueItem otherQueue = (QueueItem)other;
            return this.id == otherQueue.id;
        }

        public int hashCode() {
            return this.id;
        }
    }

    private static class CallableJob<I, O>
    implements Callable<O> {
        private final I item;
        private final ThreadsafeProcessor<I, O> processor;

        public CallableJob(I item, ThreadsafeProcessor<I, O> processor) {
            this.item = item;
            this.processor = processor;
        }

        @Override
        public O call() throws Exception {
            return this.processor.process(this.item);
        }
    }
}

