/*
 * Decompiled with CFR 0.152.
 */
package at.ac.tuwien.dbai.pdfwrap.model.graph;

import at.ac.tuwien.dbai.pdfwrap.model.document.GenericSegment;
import at.ac.tuwien.dbai.pdfwrap.model.graph.AdjacencyEdge;
import at.ac.tuwien.dbai.pdfwrap.model.graph.AdjacencyGraph;
import at.ac.tuwien.dbai.pdfwrap.model.graph.DocEdge;
import at.ac.tuwien.dbai.pdfwrap.model.graph.DocNode;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DocumentGraph
implements Cloneable {
    protected List<DocNode> nodes = new ArrayList<DocNode>();
    protected List<DocEdge> edges = new ArrayList<DocEdge>();
    protected HashMap<GenericSegment, DocNode> segNodeHash;
    protected HashMap<DocNode, GenericSegment> nodeSegHash;

    public DocumentGraph() {
    }

    public DocumentGraph(AdjacencyGraph<?> ag) {
        this.segNodeHash = new HashMap();
        this.nodeSegHash = new HashMap();
        for (Object obj : ag.getVertSegmentList()) {
            GenericSegment gs = (GenericSegment)obj;
            DocNode n = new DocNode(gs);
            this.nodes.add(n);
            this.segNodeHash.put(gs, n);
            this.nodeSegHash.put(n, gs);
        }
        for (AdjacencyEdge adjacencyEdge : ag.getEdges()) {
            Object segFrom = adjacencyEdge.getNodeFrom();
            Object segTo = adjacencyEdge.getNodeTo();
            DocNode nodeFrom = this.segNodeHash.get(segFrom);
            DocNode nodeTo = this.segNodeHash.get(segTo);
            if (adjacencyEdge.getDirection() != 1 && adjacencyEdge.getDirection() != 3) continue;
            DocEdge atr = new DocEdge(adjacencyEdge, nodeFrom, nodeTo);
            this.edges.add(atr);
        }
        System.out.println("creating DG with nodes: " + this.nodes.size() + " edges: " + this.edges.size());
    }

    public DocumentGraph(NodeList listOfItems) {
        this();
        Node itemNode;
        int s = 0;
        while (s < listOfItems.getLength()) {
            itemNode = listOfItems.item(s);
            if (itemNode.getNodeType() == 1 && itemNode.getNodeName().equals("node")) {
                this.nodes.add(new DocNode((Element)itemNode));
            }
            ++s;
        }
        s = 0;
        while (s < listOfItems.getLength()) {
            itemNode = listOfItems.item(s);
            if (itemNode.getNodeType() == 1 && itemNode.getNodeName().equals("edge")) {
                this.edges.add(new DocEdge((Element)itemNode, this.nodes));
            }
            ++s;
        }
    }

    public List<DocNode> getNodes() {
        return this.nodes;
    }

    public void setNodes(List<DocNode> nodes) {
        this.nodes = nodes;
    }

    public List<DocEdge> getEdges() {
        return this.edges;
    }

    public List<DocEdge> edgesFrom(DocNode n) {
        ArrayList<DocEdge> retVal = new ArrayList<DocEdge>();
        for (DocEdge o : this.edges) {
            DocEdge e = o;
            if (e.getFrom() != n) continue;
            retVal.add(e);
        }
        return retVal;
    }

    public List<DocEdge> edgesTo(DocNode n) {
        ArrayList<DocEdge> retVal = new ArrayList<DocEdge>();
        for (DocEdge o : this.edges) {
            DocEdge e = o;
            if (e.getTo() != n) continue;
            retVal.add(e);
        }
        return retVal;
    }

    public List<DocEdge> edgesFromTo(DocNode n) {
        ArrayList<DocEdge> retVal = new ArrayList<DocEdge>();
        for (DocEdge o : this.edges) {
            DocEdge e = o;
            if (e.getFrom() != n && e.getTo() != n) continue;
            retVal.add(e);
        }
        return retVal;
    }

    public void setEdges(List<DocEdge> edges) {
        this.edges = edges;
    }

    public DocNode getNodeFromHash(GenericSegment gs) {
        return this.segNodeHash.get(gs);
    }

    public GenericSegment getSegmentFromHash(DocNode n) {
        return this.nodeSegHash.get(n);
    }

    public DocumentGraph subGraph(List<DocNode> nodes) {
        DocumentGraph retVal = new DocumentGraph();
        retVal.nodes.addAll(nodes);
        for (DocEdge o : this.edges) {
            DocEdge e = o;
            if (!nodes.contains(e.getFrom()) && !nodes.contains(e.getTo())) continue;
            retVal.edges.add(e);
        }
        return retVal;
    }

    public DocumentGraph deepCopy() {
        DocumentGraph retVal = new DocumentGraph();
        HashMap<DocNode, DocNode> nhm = new HashMap<DocNode, DocNode>();
        Iterator<Cloneable> iterator = this.nodes.iterator();
        while (iterator.hasNext()) {
            DocNode docNode;
            DocNode n = docNode = iterator.next();
            DocNode cln = (DocNode)n.clone();
            retVal.nodes.add(cln);
            nhm.put(n, cln);
        }
        for (Cloneable cloneable : this.edges) {
            DocEdge ae = (DocEdge)cloneable;
            DocEdge cae = (DocEdge)ae.clone();
            cae.setFrom((DocNode)nhm.get(cae.getFrom()));
            cae.setTo((DocNode)nhm.get(cae.getTo()));
            retVal.edges.add(cae);
        }
        return retVal;
    }

    public void addAsXMLGraph(Document resultDocument, Element parent, boolean addDisabledItems) {
        Cloneable thisItem;
        for (DocNode docNode : this.nodes) {
            thisItem = docNode;
            if (((DocNode)thisItem).isRemoveFromInstance() && !addDisabledItems) continue;
            ((DocNode)thisItem).addAsXMLNode(resultDocument, parent);
        }
        for (Cloneable cloneable : this.edges) {
            thisItem = (DocEdge)cloneable;
            if (((DocEdge)thisItem).isRemoveFromInstance() && !addDisabledItems) continue;
            ((DocEdge)thisItem).addAsXMLEdge(resultDocument, parent);
        }
    }
}

