/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.cms;

import java.io.IOException;
import java.io.OutputStream;
import java.security.InvalidKeyException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.Signature;
import java.security.SignatureException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1Set;
import org.bouncycastle.asn1.ASN1TaggedObject;
import org.bouncycastle.asn1.BERSequenceGenerator;
import org.bouncycastle.asn1.BERTaggedObject;
import org.bouncycastle.asn1.DEREncodable;
import org.bouncycastle.asn1.DEREncodableVector;
import org.bouncycastle.asn1.DERInteger;
import org.bouncycastle.asn1.DERNull;
import org.bouncycastle.asn1.DERObjectIdentifier;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DERSet;
import org.bouncycastle.asn1.cms.AttributeTable;
import org.bouncycastle.asn1.cms.CMSObjectIdentifiers;
import org.bouncycastle.asn1.cms.SignerIdentifier;
import org.bouncycastle.asn1.cms.SignerInfo;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x509.DigestInfo;
import org.bouncycastle.cms.CMSAttributeTableGenerator;
import org.bouncycastle.cms.CMSSignedGenerator;
import org.bouncycastle.cms.CMSSignedHelper;
import org.bouncycastle.cms.CMSStreamException;
import org.bouncycastle.cms.CMSUtils;
import org.bouncycastle.cms.DefaultSignedAttributeTableGenerator;
import org.bouncycastle.cms.SignerInformation;
import org.bouncycastle.cms.SimpleAttributeTableGenerator;

public class CMSSignedDataStreamGenerator
extends CMSSignedGenerator {
    private List _signerInfs = new ArrayList();
    private List _messageDigests = new ArrayList();
    private int _bufferSize;

    public CMSSignedDataStreamGenerator() {
    }

    public CMSSignedDataStreamGenerator(SecureRandom secureRandom) {
        super(secureRandom);
    }

    public void setBufferSize(int n) {
        this._bufferSize = n;
    }

    public void addSigner(PrivateKey privateKey, X509Certificate x509Certificate, String string, String string2) throws NoSuchAlgorithmException, NoSuchProviderException, InvalidKeyException {
        this.addSigner(privateKey, x509Certificate, string, (CMSAttributeTableGenerator)new DefaultSignedAttributeTableGenerator(), (CMSAttributeTableGenerator)null, string2);
    }

    public void addSigner(PrivateKey privateKey, X509Certificate x509Certificate, String string, String string2, String string3) throws NoSuchAlgorithmException, NoSuchProviderException, InvalidKeyException {
        this.addSigner(privateKey, x509Certificate, string, string2, (CMSAttributeTableGenerator)new DefaultSignedAttributeTableGenerator(), (CMSAttributeTableGenerator)null, string3);
    }

    public void addSigner(PrivateKey privateKey, X509Certificate x509Certificate, String string, Provider provider) throws NoSuchAlgorithmException, NoSuchProviderException, InvalidKeyException {
        this.addSigner(privateKey, x509Certificate, string, (CMSAttributeTableGenerator)new DefaultSignedAttributeTableGenerator(), (CMSAttributeTableGenerator)null, provider);
    }

    public void addSigner(PrivateKey privateKey, X509Certificate x509Certificate, String string, String string2, Provider provider) throws NoSuchAlgorithmException, NoSuchProviderException, InvalidKeyException {
        this.addSigner(privateKey, x509Certificate, string, string2, (CMSAttributeTableGenerator)new DefaultSignedAttributeTableGenerator(), (CMSAttributeTableGenerator)null, provider);
    }

    public void addSigner(PrivateKey privateKey, X509Certificate x509Certificate, String string, AttributeTable attributeTable, AttributeTable attributeTable2, String string2) throws NoSuchAlgorithmException, NoSuchProviderException, InvalidKeyException {
        this.addSigner(privateKey, x509Certificate, string, (CMSAttributeTableGenerator)new DefaultSignedAttributeTableGenerator(attributeTable), (CMSAttributeTableGenerator)new SimpleAttributeTableGenerator(attributeTable2), string2);
    }

    public void addSigner(PrivateKey privateKey, X509Certificate x509Certificate, String string, String string2, AttributeTable attributeTable, AttributeTable attributeTable2, String string3) throws NoSuchAlgorithmException, NoSuchProviderException, InvalidKeyException {
        this.addSigner(privateKey, x509Certificate, string, string2, (CMSAttributeTableGenerator)new DefaultSignedAttributeTableGenerator(attributeTable), (CMSAttributeTableGenerator)new SimpleAttributeTableGenerator(attributeTable2), string3);
    }

    public void addSigner(PrivateKey privateKey, X509Certificate x509Certificate, String string, AttributeTable attributeTable, AttributeTable attributeTable2, Provider provider) throws NoSuchAlgorithmException, InvalidKeyException {
        this.addSigner(privateKey, x509Certificate, string, (CMSAttributeTableGenerator)new DefaultSignedAttributeTableGenerator(attributeTable), (CMSAttributeTableGenerator)new SimpleAttributeTableGenerator(attributeTable2), provider);
    }

    public void addSigner(PrivateKey privateKey, X509Certificate x509Certificate, String string, String string2, AttributeTable attributeTable, AttributeTable attributeTable2, Provider provider) throws NoSuchAlgorithmException, InvalidKeyException {
        this.addSigner(privateKey, x509Certificate, string, string2, (CMSAttributeTableGenerator)new DefaultSignedAttributeTableGenerator(attributeTable), (CMSAttributeTableGenerator)new SimpleAttributeTableGenerator(attributeTable2), provider);
    }

    public void addSigner(PrivateKey privateKey, X509Certificate x509Certificate, String string, CMSAttributeTableGenerator cMSAttributeTableGenerator, CMSAttributeTableGenerator cMSAttributeTableGenerator2, Provider provider) throws NoSuchAlgorithmException, InvalidKeyException {
        this.addSigner(privateKey, x509Certificate, this.getEncOID(privateKey, string), string, cMSAttributeTableGenerator, cMSAttributeTableGenerator2, provider);
    }

    public void addSigner(PrivateKey privateKey, X509Certificate x509Certificate, String string, String string2, CMSAttributeTableGenerator cMSAttributeTableGenerator, CMSAttributeTableGenerator cMSAttributeTableGenerator2, Provider provider) throws NoSuchAlgorithmException, InvalidKeyException {
        String string3 = CMSSignedHelper.INSTANCE.getDigestAlgName(string2);
        MessageDigest messageDigest = CMSSignedHelper.INSTANCE.getDigestInstance(string3, provider);
        this._signerInfs.add(new SignerInf(privateKey, CMSSignedDataStreamGenerator.getSignerIdentifier(x509Certificate), string2, string, cMSAttributeTableGenerator, cMSAttributeTableGenerator2, messageDigest, provider));
        this._messageDigests.add(messageDigest);
    }

    public void addSigner(PrivateKey privateKey, X509Certificate x509Certificate, String string, CMSAttributeTableGenerator cMSAttributeTableGenerator, CMSAttributeTableGenerator cMSAttributeTableGenerator2, String string2) throws NoSuchAlgorithmException, NoSuchProviderException, InvalidKeyException {
        this.addSigner(privateKey, x509Certificate, string, cMSAttributeTableGenerator, cMSAttributeTableGenerator2, CMSUtils.getProvider(string2));
    }

    public void addSigner(PrivateKey privateKey, X509Certificate x509Certificate, String string, String string2, CMSAttributeTableGenerator cMSAttributeTableGenerator, CMSAttributeTableGenerator cMSAttributeTableGenerator2, String string3) throws NoSuchAlgorithmException, NoSuchProviderException, InvalidKeyException {
        this.addSigner(privateKey, x509Certificate, string, string2, cMSAttributeTableGenerator, cMSAttributeTableGenerator2, CMSUtils.getProvider(string3));
    }

    public void addSigner(PrivateKey privateKey, byte[] byArray, String string, String string2) throws NoSuchAlgorithmException, NoSuchProviderException, InvalidKeyException {
        this.addSigner(privateKey, byArray, string, (CMSAttributeTableGenerator)new DefaultSignedAttributeTableGenerator(), (CMSAttributeTableGenerator)null, string2);
    }

    public void addSigner(PrivateKey privateKey, byte[] byArray, String string, String string2, String string3) throws NoSuchAlgorithmException, NoSuchProviderException, InvalidKeyException {
        this.addSigner(privateKey, byArray, string, string2, (CMSAttributeTableGenerator)new DefaultSignedAttributeTableGenerator(), (CMSAttributeTableGenerator)null, string3);
    }

    public void addSigner(PrivateKey privateKey, byte[] byArray, String string, Provider provider) throws NoSuchAlgorithmException, NoSuchProviderException, InvalidKeyException {
        this.addSigner(privateKey, byArray, string, (CMSAttributeTableGenerator)new DefaultSignedAttributeTableGenerator(), (CMSAttributeTableGenerator)null, provider);
    }

    public void addSigner(PrivateKey privateKey, byte[] byArray, String string, String string2, Provider provider) throws NoSuchAlgorithmException, NoSuchProviderException, InvalidKeyException {
        this.addSigner(privateKey, byArray, string, string2, (CMSAttributeTableGenerator)new DefaultSignedAttributeTableGenerator(), (CMSAttributeTableGenerator)null, provider);
    }

    public void addSigner(PrivateKey privateKey, byte[] byArray, String string, AttributeTable attributeTable, AttributeTable attributeTable2, String string2) throws NoSuchAlgorithmException, NoSuchProviderException, InvalidKeyException {
        this.addSigner(privateKey, byArray, string, (CMSAttributeTableGenerator)new DefaultSignedAttributeTableGenerator(attributeTable), (CMSAttributeTableGenerator)new SimpleAttributeTableGenerator(attributeTable2), string2);
    }

    public void addSigner(PrivateKey privateKey, byte[] byArray, String string, AttributeTable attributeTable, AttributeTable attributeTable2, Provider provider) throws NoSuchAlgorithmException, InvalidKeyException {
        this.addSigner(privateKey, byArray, string, (CMSAttributeTableGenerator)new DefaultSignedAttributeTableGenerator(attributeTable), (CMSAttributeTableGenerator)new SimpleAttributeTableGenerator(attributeTable2), provider);
    }

    public void addSigner(PrivateKey privateKey, byte[] byArray, String string, CMSAttributeTableGenerator cMSAttributeTableGenerator, CMSAttributeTableGenerator cMSAttributeTableGenerator2, Provider provider) throws NoSuchAlgorithmException, InvalidKeyException {
        this.addSigner(privateKey, byArray, this.getEncOID(privateKey, string), string, cMSAttributeTableGenerator, cMSAttributeTableGenerator2, provider);
    }

    public void addSigner(PrivateKey privateKey, byte[] byArray, String string, String string2, CMSAttributeTableGenerator cMSAttributeTableGenerator, CMSAttributeTableGenerator cMSAttributeTableGenerator2, Provider provider) throws NoSuchAlgorithmException, InvalidKeyException {
        String string3 = CMSSignedHelper.INSTANCE.getDigestAlgName(string2);
        MessageDigest messageDigest = CMSSignedHelper.INSTANCE.getDigestInstance(string3, provider);
        this._signerInfs.add(new SignerInf(privateKey, CMSSignedDataStreamGenerator.getSignerIdentifier(byArray), string2, string, cMSAttributeTableGenerator, cMSAttributeTableGenerator2, messageDigest, provider));
        this._messageDigests.add(messageDigest);
    }

    public void addSigner(PrivateKey privateKey, byte[] byArray, String string, CMSAttributeTableGenerator cMSAttributeTableGenerator, CMSAttributeTableGenerator cMSAttributeTableGenerator2, String string2) throws NoSuchAlgorithmException, NoSuchProviderException, InvalidKeyException {
        this.addSigner(privateKey, byArray, string, cMSAttributeTableGenerator, cMSAttributeTableGenerator2, CMSUtils.getProvider(string2));
    }

    public void addSigner(PrivateKey privateKey, byte[] byArray, String string, String string2, CMSAttributeTableGenerator cMSAttributeTableGenerator, CMSAttributeTableGenerator cMSAttributeTableGenerator2, String string3) throws NoSuchAlgorithmException, NoSuchProviderException, InvalidKeyException {
        this.addSigner(privateKey, byArray, string, string2, cMSAttributeTableGenerator, cMSAttributeTableGenerator2, CMSUtils.getProvider(string3));
    }

    public OutputStream open(OutputStream outputStream) throws IOException {
        return this.open(outputStream, false);
    }

    public OutputStream open(OutputStream outputStream, boolean bl) throws IOException {
        return this.open(outputStream, DATA, bl);
    }

    public OutputStream open(OutputStream outputStream, boolean bl, OutputStream outputStream2) throws IOException {
        return this.open(outputStream, DATA, bl, outputStream2);
    }

    public OutputStream open(OutputStream outputStream, String string, boolean bl) throws IOException {
        return this.open(outputStream, string, bl, null);
    }

    public OutputStream open(OutputStream outputStream, String string, boolean bl, OutputStream outputStream2) throws IOException {
        Object object2;
        BERSequenceGenerator bERSequenceGenerator = new BERSequenceGenerator(outputStream);
        bERSequenceGenerator.addObject(CMSObjectIdentifiers.signedData);
        BERSequenceGenerator bERSequenceGenerator2 = new BERSequenceGenerator(bERSequenceGenerator.getRawOutputStream(), 0, true);
        bERSequenceGenerator2.addObject(this.calculateVersion(string));
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        for (Object object2 : this._signers) {
            aSN1EncodableVector.add(CMSSignedHelper.INSTANCE.fixAlgID(((SignerInformation)object2).getDigestAlgorithmID()));
        }
        for (Object object2 : this._signerInfs) {
            aSN1EncodableVector.add(((SignerInf)object2).getDigestAlgorithmID());
        }
        bERSequenceGenerator2.getRawOutputStream().write(new DERSet(aSN1EncodableVector).getEncoded());
        BERSequenceGenerator bERSequenceGenerator3 = new BERSequenceGenerator(bERSequenceGenerator2.getRawOutputStream());
        bERSequenceGenerator3.addObject(new DERObjectIdentifier(string));
        object2 = bl ? CMSUtils.createBEROctetOutputStream(bERSequenceGenerator3.getRawOutputStream(), 0, true, this._bufferSize) : null;
        OutputStream outputStream3 = CMSSignedDataStreamGenerator.getSafeTeeOutputStream(outputStream2, (OutputStream)object2);
        OutputStream outputStream4 = CMSSignedDataStreamGenerator.attachDigestsToOutputStream(this._messageDigests, outputStream3);
        return new CmsSignedDataOutputStream(outputStream4, string, bERSequenceGenerator, bERSequenceGenerator2, bERSequenceGenerator3);
    }

    private DERInteger calculateVersion(String string) {
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        if (this._certs != null) {
            for (Object e : this._certs) {
                if (!(e instanceof ASN1TaggedObject)) continue;
                ASN1TaggedObject aSN1TaggedObject = (ASN1TaggedObject)e;
                if (aSN1TaggedObject.getTagNo() == 1) {
                    bl3 = true;
                    continue;
                }
                if (aSN1TaggedObject.getTagNo() == 2) {
                    bl4 = true;
                    continue;
                }
                if (aSN1TaggedObject.getTagNo() != 3) continue;
                bl = true;
            }
        }
        if (bl) {
            return new DERInteger(5);
        }
        if (this._crls != null && !bl) {
            for (Object e : this._crls) {
                if (!(e instanceof ASN1TaggedObject)) continue;
                bl2 = true;
            }
        }
        if (bl2) {
            return new DERInteger(5);
        }
        if (bl4) {
            return new DERInteger(4);
        }
        if (bl3) {
            return new DERInteger(3);
        }
        if (string.equals(DATA)) {
            if (this.checkForVersion3(this._signers)) {
                return new DERInteger(3);
            }
            return new DERInteger(1);
        }
        return new DERInteger(3);
    }

    private boolean checkForVersion3(List list) {
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            SignerInfo signerInfo = SignerInfo.getInstance(((SignerInformation)iterator.next()).toSignerInfo());
            if (signerInfo.getVersion().getValue().intValue() != 3) continue;
            return true;
        }
        return false;
    }

    private static OutputStream attachDigestsToOutputStream(List list, OutputStream outputStream) {
        OutputStream outputStream2 = outputStream;
        for (MessageDigest messageDigest : list) {
            outputStream2 = CMSSignedDataStreamGenerator.getSafeTeeOutputStream(outputStream2, new CMSSignedGenerator.DigOutputStream(messageDigest));
        }
        return outputStream2;
    }

    private static OutputStream getSafeOutputStream(OutputStream outputStream) {
        return outputStream == null ? new NullOutputStream() : outputStream;
    }

    private static OutputStream getSafeTeeOutputStream(OutputStream outputStream, OutputStream outputStream2) {
        return outputStream == null ? CMSSignedDataStreamGenerator.getSafeOutputStream(outputStream2) : (outputStream2 == null ? CMSSignedDataStreamGenerator.getSafeOutputStream(outputStream) : new TeeOutputStream(outputStream, outputStream2));
    }

    private class CmsSignedDataOutputStream
    extends OutputStream {
        private OutputStream _out;
        private DERObjectIdentifier _contentOID;
        private BERSequenceGenerator _sGen;
        private BERSequenceGenerator _sigGen;
        private BERSequenceGenerator _eiGen;

        public CmsSignedDataOutputStream(OutputStream outputStream, String string, BERSequenceGenerator bERSequenceGenerator, BERSequenceGenerator bERSequenceGenerator2, BERSequenceGenerator bERSequenceGenerator3) {
            this._out = outputStream;
            this._contentOID = new DERObjectIdentifier(string);
            this._sGen = bERSequenceGenerator;
            this._sigGen = bERSequenceGenerator2;
            this._eiGen = bERSequenceGenerator3;
        }

        public void write(int n) throws IOException {
            this._out.write(n);
        }

        public void write(byte[] byArray, int n, int n2) throws IOException {
            this._out.write(byArray, n, n2);
        }

        public void write(byte[] byArray) throws IOException {
            this._out.write(byArray);
        }

        public void close() throws IOException {
            Object object;
            this._out.close();
            this._eiGen.close();
            CMSSignedDataStreamGenerator.this._digests.clear();
            if (CMSSignedDataStreamGenerator.this._certs.size() != 0) {
                object = CMSUtils.createBerSetFromList(CMSSignedDataStreamGenerator.this._certs);
                this._sigGen.getRawOutputStream().write(new BERTaggedObject(false, 0, (DEREncodable)object).getEncoded());
            }
            if (CMSSignedDataStreamGenerator.this._crls.size() != 0) {
                object = CMSUtils.createBerSetFromList(CMSSignedDataStreamGenerator.this._crls);
                this._sigGen.getRawOutputStream().write(new BERTaggedObject(false, 1, (DEREncodable)object).getEncoded());
            }
            object = new ASN1EncodableVector();
            for (Object object2 : CMSSignedDataStreamGenerator.this._signers) {
                ((DEREncodableVector)object).add(((SignerInformation)object2).toSignerInfo());
            }
            for (Object object2 : CMSSignedDataStreamGenerator.this._signerInfs) {
                try {
                    ((DEREncodableVector)object).add(((SignerInf)object2).toSignerInfo(this._contentOID));
                }
                catch (IOException iOException) {
                    throw new CMSStreamException("encoding error.", iOException);
                }
                catch (InvalidKeyException invalidKeyException) {
                    throw new CMSStreamException("key inappropriate for signature.", invalidKeyException);
                }
                catch (SignatureException signatureException) {
                    throw new CMSStreamException("error creating signature.", signatureException);
                }
                catch (CertificateEncodingException certificateEncodingException) {
                    throw new CMSStreamException("error creating sid.", certificateEncodingException);
                }
                catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                    throw new CMSStreamException("unknown signature algorithm.", noSuchAlgorithmException);
                }
            }
            this._sigGen.getRawOutputStream().write(new DERSet((DEREncodableVector)object).getEncoded());
            this._sigGen.close();
            this._sGen.close();
        }
    }

    private static class NullOutputStream
    extends OutputStream {
        private NullOutputStream() {
        }

        public void write(byte[] byArray) throws IOException {
        }

        public void write(byte[] byArray, int n, int n2) throws IOException {
        }

        public void write(int n) throws IOException {
        }
    }

    private class SignerInf {
        private final PrivateKey _key;
        private final SignerIdentifier _signerIdentifier;
        private final String _digestOID;
        private final String _encOID;
        private final CMSAttributeTableGenerator _sAttr;
        private final CMSAttributeTableGenerator _unsAttr;
        private final MessageDigest _digest;
        private final Provider _sigProvider;

        SignerInf(PrivateKey privateKey, SignerIdentifier signerIdentifier, String string, String string2, CMSAttributeTableGenerator cMSAttributeTableGenerator, CMSAttributeTableGenerator cMSAttributeTableGenerator2, MessageDigest messageDigest, Provider provider) {
            this._key = privateKey;
            this._signerIdentifier = signerIdentifier;
            this._digestOID = string;
            this._encOID = string2;
            this._sAttr = cMSAttributeTableGenerator;
            this._unsAttr = cMSAttributeTableGenerator2;
            this._digest = messageDigest;
            this._sigProvider = provider;
        }

        AlgorithmIdentifier getDigestAlgorithmID() {
            return new AlgorithmIdentifier(new DERObjectIdentifier(this._digestOID), DERNull.INSTANCE);
        }

        SignerInfo toSignerInfo(DERObjectIdentifier dERObjectIdentifier) throws IOException, SignatureException, CertificateEncodingException, InvalidKeyException, NoSuchAlgorithmException {
            Object object;
            Signature signature;
            Object object2;
            Object object3;
            String string = CMSSignedHelper.INSTANCE.getDigestAlgName(this._digestOID);
            String string2 = CMSSignedHelper.INSTANCE.getEncryptionAlgName(this._encOID);
            String string3 = string + "with" + string2;
            AlgorithmIdentifier algorithmIdentifier = this.getDigestAlgorithmID();
            byte[] byArray = this._digest.digest();
            CMSSignedDataStreamGenerator.this._digests.put(this._digestOID, byArray.clone());
            byte[] byArray2 = byArray;
            ASN1Set aSN1Set = null;
            if (this._sAttr != null) {
                object3 = CMSSignedDataStreamGenerator.this.getBaseParameters(dERObjectIdentifier, algorithmIdentifier, byArray);
                object2 = this._sAttr.getAttributes(Collections.unmodifiableMap(object3));
                aSN1Set = CMSSignedDataStreamGenerator.this.getAttributeSet((AttributeTable)object2);
                byArray2 = aSN1Set.getEncoded("DER");
                signature = CMSSignedHelper.INSTANCE.getSignatureInstance(string3, this._sigProvider);
            } else if (string2.equals("RSA")) {
                object3 = new DigestInfo(algorithmIdentifier, byArray);
                byArray2 = ((ASN1Encodable)object3).getEncoded("DER");
                signature = CMSSignedHelper.INSTANCE.getSignatureInstance("RSA", this._sigProvider);
            } else if (string2.equals("DSA")) {
                signature = CMSSignedHelper.INSTANCE.getSignatureInstance("NONEwithDSA", this._sigProvider);
            } else {
                throw new SignatureException("algorithm: " + string2 + " not supported in base signatures.");
            }
            signature.initSign(this._key, CMSSignedDataStreamGenerator.this.rand);
            signature.update(byArray2);
            object3 = signature.sign();
            object2 = null;
            if (this._unsAttr != null) {
                object = CMSSignedDataStreamGenerator.this.getBaseParameters(dERObjectIdentifier, algorithmIdentifier, byArray);
                object.put("encryptedDigest", object3.clone());
                AttributeTable attributeTable = this._unsAttr.getAttributes(Collections.unmodifiableMap(object));
                object2 = CMSSignedDataStreamGenerator.this.getAttributeSet(attributeTable);
            }
            object = CMSSignedDataStreamGenerator.this.getEncAlgorithmIdentifier(this._encOID, signature);
            return new SignerInfo(this._signerIdentifier, algorithmIdentifier, aSN1Set, (AlgorithmIdentifier)object, new DEROctetString((byte[])object3), (ASN1Set)object2);
        }
    }

    private static class TeeOutputStream
    extends OutputStream {
        private OutputStream s1;
        private OutputStream s2;

        public TeeOutputStream(OutputStream outputStream, OutputStream outputStream2) {
            this.s1 = outputStream;
            this.s2 = outputStream2;
        }

        public void write(byte[] byArray) throws IOException {
            this.s1.write(byArray);
            this.s2.write(byArray);
        }

        public void write(byte[] byArray, int n, int n2) throws IOException {
            this.s1.write(byArray, n, n2);
            this.s2.write(byArray, n, n2);
        }

        public void write(int n) throws IOException {
            this.s1.write(n);
            this.s2.write(n);
        }

        public void close() throws IOException {
            this.s1.close();
            this.s2.close();
        }
    }
}

