/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.iosp.bufr;

import java.io.IOException;
import ucar.unidata.io.RandomAccessFile;

public class BitReader {
    private RandomAccessFile raf;
    private long startPos;
    private byte[] test;
    private int testPos = 0;
    private int bitBuf = 0;
    private int bitPos = 0;

    BitReader(byte[] test) {
        this.test = test;
        this.testPos = 0;
        this.bitBuf = 0;
        this.bitPos = 0;
    }

    public BitReader(RandomAccessFile raf, long startPos) throws IOException {
        this.raf = raf;
        this.startPos = startPos;
        raf.seek(startPos);
    }

    private void setPos(int bitPos, int bitBuf) throws IOException {
        this.bitPos = bitPos;
        this.bitBuf = bitBuf;
    }

    public void setBitOffset(int bitOffset) throws IOException {
        if (bitOffset % 8 == 0) {
            this.raf.seek(this.startPos + (long)(bitOffset / 8));
            this.bitPos = 0;
            this.bitBuf = 0;
        } else {
            this.raf.seek(this.startPos + (long)(bitOffset / 8));
            this.bitPos = 8 - bitOffset % 8;
            this.bitBuf = this.raf.read();
            this.bitBuf &= 255 >> 8 - this.bitPos;
        }
    }

    private int nextByte() throws IOException {
        if (this.raf != null) {
            return this.raf.read();
        }
        return this.test[this.testPos++];
    }

    public long bits2UInt(int nb) throws IOException {
        int shift;
        int bitsLeft = nb;
        int result = 0;
        if (this.bitPos == 0) {
            this.bitBuf = this.nextByte();
            this.bitPos = 8;
        }
        while ((shift = bitsLeft - this.bitPos) > 0) {
            result |= this.bitBuf << shift;
            bitsLeft -= this.bitPos;
            this.bitBuf = this.nextByte();
            this.bitPos = 8;
        }
        this.bitPos -= bitsLeft;
        this.bitBuf &= 255 >> 8 - this.bitPos;
        return result |= this.bitBuf >> -shift;
    }

    public long getPos() throws IOException {
        return this.raf.getFilePointer();
    }

    public static void main(String[] args) throws IOException {
        BitReader bu = new BitReader(new byte[]{-1, 2, 4, 8});
        bu.bits2UInt(7);
        bu.bits2UInt(1);
    }
}

