/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.jaxb.gmd;

import java.util.Locale;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlType;
import org.apache.sis.internal.jaxb.Context;
import org.apache.sis.internal.jaxb.gco.CharSequenceAdapter;
import org.apache.sis.internal.jaxb.gco.GO_CharacterString;
import org.apache.sis.internal.jaxb.gmd.CodeListUID;
import org.apache.sis.internal.jaxb.gmd.LanguageCode;
import org.apache.sis.util.CharSequences;
import org.apache.sis.util.resources.Errors;

@XmlType(name="Country_PropertyType")
public final class Country
extends GO_CharacterString {
    @XmlElement(name="Country")
    private CodeListUID identifier;

    private Country() {
    }

    private Country(CharSequence charSequence) {
        super(charSequence);
    }

    private Country(Context context, String string, String string2, String string3) {
        this.identifier = new CodeListUID(context, "Country", string, string2, string3);
    }

    public static Country create(Context context, Locale locale) {
        String string = Context.converter(context).toCountryCode(context, locale);
        if (string != null) {
            Object object;
            if (!string.isEmpty() && Context.isFlagSet(context, 4) && (object = CharSequenceAdapter.value(context, locale, string)) != null) {
                return new Country((CharSequence)object);
            }
            object = LanguageCode.marshalLocale(context);
            String string2 = Context.converter(context).toLanguageCode(context, (Locale)object);
            String string3 = locale.getDisplayCountry((Locale)object);
            if (string3.isEmpty()) {
                string2 = null;
                string3 = null;
            }
            if (!string.isEmpty() || string3 != null) {
                return new Country(context, string, string2, string3);
            }
        }
        return null;
    }

    public static Locale getLocale(Context context, LanguageCode languageCode, Country country, Class<?> clazz) {
        CodeListUID codeListUID;
        String string;
        String string2 = null;
        if (languageCode != null) {
            string2 = languageCode.getLanguage();
        }
        if (country != null && (string = CharSequences.trimWhitespaces(((codeListUID = country.identifier) != null ? codeListUID : country).toString())) != null && !string.isEmpty()) {
            int n;
            if (string2 == null) {
                string2 = "";
            }
            if ((n = string2.indexOf(95)) < 0) {
                string2 = string2 + '_' + string;
            } else {
                int n2 = string2.length();
                if (++n == string2.length() || string2.charAt(n) == '_') {
                    string2 = new StringBuilder().append(string2, 0, n).append(string).append(string2, n, n2).toString();
                } else if (!string.equals(CharSequences.token(string2, n))) {
                    Context.warningOccured(context, clazz, "unmarshal", Errors.class, (short)63, "country");
                }
            }
        }
        return Context.converter(context).toLocale(context, string2);
    }
}

