#!perl

use strict;
use warnings;

# This test was generated by inc::CheckJiraInChanges

use Test::More tests => 1;

my @commits = split /\n/, <<'EOC';
3028076 (xdg/master, origin/master, origin/HEAD, dagolden/master) PERL-627 Fix bug passing args to _DropCollection when assertions are off
5dcd7c6 PERL-680 Fix max_staleness_seconds usage error message
06866f5 PERL-687 Add codec-specific OID generation
3812890 PERL-664 Add Decimal128 type example
0a634cd PERL-662 Update collation documentation links
18e4ada PERL-680 PERL-684 Update Max Staleness implementation
77c377b PERL-685 check next scan time before selecting cached primary
1d91b13 PERL-675 Make fsync tests more robust
acfa507 PERL-670 Make drop_collection check error codes
c1e15fb PERL-657 Fix spelling typos
37cef67 PERL-665 Update Changes
648e932 PERL-667 Add and pass minimal Perl::Critic release tests
56a972c PERL-665 Allow invalid opt index tests to fail with server error

EOC

my %ticket_map;
for my $commit ( @commits ) {
    for my $ticket ( $commit =~ /PERL-(\d+)/g ) {
        next if $ENV{CHECK_JIRA_SKIP}
            && grep { $ticket eq $_ } split " ", $ENV{CHECK_JIRA_SKIP};
        $ticket_map{$ticket} ||= [];
        push @{$ticket_map{$ticket}}, $commit;
    }
}

# grab Changes lines from new version to next un-indented line
open my $fh, "<:encoding(UTF-8)", "Changes";
my $changelog = do { local $/; <$fh> };

my @bad;
for my $ticket ( keys %ticket_map ) {
    if ( index( $changelog, "PERL-$ticket" ) < 0 ) {
       push @bad, $ticket;
    }
}

if ( !@commits ) {
    pass("No commits with Jira tickets");
}
else {
    ok( ! scalar @bad, "Jira tickets in Changes")
        or diag "Jira tickets missing:\n"
        . join("\n", map { "  * $_" } map { @{$ticket_map{$_}} } sort { $a <=> $b } @bad );
}
