#!/usr/bin/perl

use strict;
use lib 't/lib';

use Test::Deep qw(cmp_deeply);

use FusionInventory::Agent::Tools::Hardware;
use FusionInventory::Test::Hardware;

my %tests = (
    'nortel/baystack_470.walk' => [
        {
            MANUFACTURER => 'Nortel',
            TYPE         => 'NETWORKING',
            MAC          => '00:15:40:94:75:A2',
            SNMPHOSTNAME => 'Bay470',
            DESCRIPTION  => 'BayStack 470 - 24T           HW:06       FW:3.0.0.5   SW:v3.1.2.06 ISVN:2'
        },
        {
            MANUFACTURER => 'Nortel',
            TYPE         => 'NETWORKING',
            MAC          => '00:15:40:94:75:A2',
            SNMPHOSTNAME => 'Bay470',
            DESCRIPTION  => 'BayStack 470 - 24T           HW:06       FW:3.0.0.5   SW:v3.1.2.06 ISVN:2',
            MODEL        => undef,
            MODELSNMP    => 'Networking2050',
            SERIAL       => 'SACC170NLH',
            FIRMWARE     => undef,
        },
        {
            INFO => {
                ID     => undef,
                TYPE   => 'NETWORKING',
                UPTIME => '(78352234) 9 days, 1:38:42.34',
                IPS    => {
                    IP => [ '10.97.9.231' ]
                },
                LOCATION     => 'Dost 111',
                MODEL        => 'BS470_24',
                MAC          => '00:15:40:94:75:A2',
                MANUFACTURER => 'Nortel',
                NAME         => 'Bay470',
                COMMENTS     => 'BayStack 470 - 24T           HW:06       FW:3.0.0.5   SW:v3.1.2.06 ISVN:2',
                SERIAL       => 'SACC170NLH'
            },
            PORTS => {
                PORT => [
                    {
                        IFMTU       => '1514',
                        IFSTATUS    => 'down(2)',
                        IFSPEED     => '100000000',
                        IFOUTERRORS => '0',
                        IFNUMBER    => '1',
                        IFTYPE      => 'ethernetCsmacd(6)',
                        IFOUTOCTETS => '0',
                        IFINOCTETS  => '0',
                        IFDESCR =>
                          'Nortel Networks <unknown> Ethernet Switch Module - Port 1  ',
                        IFNAME           => 'ifc1 (Slot: 1 Port: 1)',
                        MAC              => '00:15:40:94:75:A0',
                        IFINERRORS       => '0',
                        IFLASTCHANGE     => '(55) 0:00:00.55',
                        IFINTERNALSTATUS => 'up(1)'
                    },
                    {
                        IFNAME => 'ifc2 (Slot: 1 Port: 2)',
                        IFDESCR =>
                          'Nortel Networks <unknown> Ethernet Switch Module - Port 2  ',
                        MAC              => '00:15:40:94:75:A0',
                        IFINERRORS       => '0',
                        IFLASTCHANGE     => '(55) 0:00:00.55',
                        IFINTERNALSTATUS => 'up(1)',
                        IFMTU            => '1514',
                        IFSTATUS         => 'down(2)',
                        IFOUTERRORS      => '0',
                        IFSPEED          => '100000000',
                        IFNUMBER         => '2',
                        IFOUTOCTETS      => '0',
                        IFTYPE           => 'ethernetCsmacd(6)',
                        IFINOCTETS       => '0'
                    },
                    {
                        IFINERRORS => '0',
                        IFDESCR =>
                          'Nortel Networks <unknown> Ethernet Switch Module - Port 3  ',
                        MAC              => '00:15:40:94:75:A0',
                        IFNAME           => 'ifc3 (Slot: 1 Port: 3)',
                        IFINTERNALSTATUS => 'up(1)',
                        IFLASTCHANGE     => '(55) 0:00:00.55',
                        IFMTU            => '1514',
                        IFSTATUS         => 'down(2)',
                        IFSPEED          => '100000000',
                        IFOUTERRORS      => '0',
                        IFTYPE           => 'ethernetCsmacd(6)',
                        IFOUTOCTETS      => '0',
                        IFINOCTETS       => '0',
                        IFNUMBER         => '3'
                    },
                    {
                        IFLASTCHANGE     => '(55) 0:00:00.55',
                        IFINTERNALSTATUS => 'up(1)',
                        IFNAME           => 'ifc4 (Slot: 1 Port: 4)',
                        IFDESCR =>
                          'Nortel Networks <unknown> Ethernet Switch Module - Port 4  ',
                        MAC         => '00:15:40:94:75:A0',
                        IFINERRORS  => '0',
                        IFSPEED     => '100000000',
                        IFOUTERRORS => '0',
                        IFNUMBER    => '4',
                        IFINOCTETS  => '0',
                        IFTYPE      => 'ethernetCsmacd(6)',
                        IFOUTOCTETS => '0',
                        IFMTU       => '1514',
                        IFSTATUS    => 'down(2)'
                    },
                    {
                        IFOUTERRORS      => '0',
                        IFSPEED          => '100000000',
                        IFINOCTETS       => '0',
                        IFTYPE           => 'ethernetCsmacd(6)',
                        IFOUTOCTETS      => '0',
                        IFNUMBER         => '5',
                        IFMTU            => '1514',
                        IFSTATUS         => 'down(2)',
                        IFINTERNALSTATUS => 'up(1)',
                        IFLASTCHANGE     => '(55) 0:00:00.55',
                        IFINERRORS       => '0',
                        IFDESCR =>
                          'Nortel Networks <unknown> Ethernet Switch Module - Port 5  ',
                        IFNAME => 'ifc5 (Slot: 1 Port: 5)',
                        MAC    => '00:15:40:94:75:A0'
                    },
                    {
                        MAC => '00:15:40:94:75:A0',
                        IFDESCR =>
                          'Nortel Networks <unknown> Ethernet Switch Module - Port 6  ',
                        IFNAME           => 'ifc6 (Slot: 1 Port: 6)',
                        IFINERRORS       => '0',
                        IFLASTCHANGE     => '(55) 0:00:00.55',
                        IFINTERNALSTATUS => 'up(1)',
                        IFMTU            => '1514',
                        IFSTATUS         => 'down(2)',
                        IFSPEED          => '100000000',
                        IFOUTERRORS      => '0',
                        IFNUMBER         => '6',
                        IFOUTOCTETS      => '0',
                        IFTYPE           => 'ethernetCsmacd(6)',
                        IFINOCTETS       => '0'
                    },
                    {
                        IFSTATUS    => 'down(2)',
                        IFMTU       => '1514',
                        IFNUMBER    => '7',
                        IFINOCTETS  => '0',
                        IFTYPE      => 'ethernetCsmacd(6)',
                        IFOUTOCTETS => '0',
                        IFOUTERRORS => '0',
                        IFSPEED     => '100000000',
                        MAC         => '00:15:40:94:75:A0',
                        IFNAME      => 'ifc7 (Slot: 1 Port: 7)',
                        IFDESCR =>
                          'Nortel Networks <unknown> Ethernet Switch Module - Port 7  ',
                        IFINERRORS       => '0',
                        IFLASTCHANGE     => '(55) 0:00:00.55',
                        IFINTERNALSTATUS => 'up(1)'
                    },
                    {
                        IFTYPE           => 'ethernetCsmacd(6)',
                        IFOUTOCTETS      => '0',
                        IFINOCTETS       => '0',
                        IFNUMBER         => '8',
                        IFSPEED          => '100000000',
                        IFOUTERRORS      => '0',
                        IFSTATUS         => 'down(2)',
                        IFMTU            => '1514',
                        IFINTERNALSTATUS => 'up(1)',
                        IFLASTCHANGE     => '(55) 0:00:00.55',
                        IFINERRORS       => '0',
                        MAC              => '00:15:40:94:75:A0',
                        IFNAME           => 'ifc8 (Slot: 1 Port: 8)',
                        IFDESCR =>
                          'Nortel Networks <unknown> Ethernet Switch Module - Port 8  '
                    },
                    {
                        IFSTATUS    => 'down(2)',
                        IFMTU       => '1514',
                        IFNUMBER    => '9',
                        IFTYPE      => 'ethernetCsmacd(6)',
                        IFOUTOCTETS => '0',
                        IFINOCTETS  => '0',
                        IFOUTERRORS => '0',
                        IFSPEED     => '100000000',
                        IFDESCR =>
                          'Nortel Networks <unknown> Ethernet Switch Module - Port 9  ',
                        IFNAME           => 'ifc9 (Slot: 1 Port: 9)',
                        MAC              => '00:15:40:94:75:A0',
                        IFINERRORS       => '0',
                        IFLASTCHANGE     => '(55) 0:00:00.55',
                        IFINTERNALSTATUS => 'up(1)'
                    },
                    {
                        IFINERRORS => '0',
                        IFNAME     => 'ifc10 (Slot: 1 Port: 10)',
                        MAC        => '00:15:40:94:75:A0',
                        IFDESCR =>
        'Nortel Networks <unknown> Ethernet Switch Module - Port 10  ',
                        IFINTERNALSTATUS => 'up(1)',
                        IFLASTCHANGE     => '(55) 0:00:00.55',
                        IFSTATUS         => 'down(2)',
                        IFMTU            => '1514',
                        IFTYPE           => 'ethernetCsmacd(6)',
                        IFINOCTETS       => '0',
                        IFOUTOCTETS      => '0',
                        IFNUMBER         => '10',
                        IFSPEED          => '100000000',
                        IFOUTERRORS      => '0'
                    },
                    {
                        IFLASTCHANGE     => '(77308621) 8 days, 22:44:46.21',
                        IFINTERNALSTATUS => 'up(1)',
                        MAC              => '00:15:40:94:75:A0',
                        IFNAME           => 'ifc11 (Slot: 1 Port: 11)',
                        IFDESCR =>
        'Nortel Networks <unknown> Ethernet Switch Module - Port 11  ',
                        IFINERRORS  => '0',
                        IFSPEED     => '10000000',
                        IFOUTERRORS => '0',
                        IFNUMBER    => '11',
                        IFOUTOCTETS => '3179345836',
                        IFTYPE      => 'ethernetCsmacd(6)',
                        IFINOCTETS  => '1290906485',
                        IFMTU       => '1514',
                        IFSTATUS    => 'up(1)'
                    },
                    {
                        IFSTATUS    => 'down(2)',
                        IFMTU       => '1514',
                        IFNUMBER    => '12',
                        IFTYPE      => 'ethernetCsmacd(6)',
                        IFOUTOCTETS => '77060062',
                        IFINOCTETS  => '108574',
                        IFOUTERRORS => '0',
                        IFSPEED     => '100000000',
                        IFDESCR =>
        'Nortel Networks <unknown> Ethernet Switch Module - Port 12  ',
                        IFNAME           => 'ifc12 (Slot: 1 Port: 12)',
                        MAC              => '00:15:40:94:75:A0',
                        IFINERRORS       => '4',
                        IFLASTCHANGE     => '(76741116) 8 days, 21:10:11.16',
                        IFINTERNALSTATUS => 'up(1)'
                    },
                    {
                        IFNUMBER         => '13',
                        IFOUTOCTETS      => '307895726',
                        IFTYPE           => 'ethernetCsmacd(6)',
                        IFINOCTETS       => '15996094',
                        IFSPEED          => '10000000',
                        IFOUTERRORS      => '0',
                        IFSTATUS         => 'up(1)',
                        IFMTU            => '1514',
                        IFLASTCHANGE     => '(70532885) 8 days, 3:55:28.85',
                        IFINTERNALSTATUS => 'up(1)',
                        IFNAME           => 'ifc13 (Slot: 1 Port: 13)',
                        MAC              => '00:15:40:94:75:A0',
                        IFDESCR =>
        'Nortel Networks <unknown> Ethernet Switch Module - Port 13  ',
                        IFINERRORS => '26'
                    },
                    {
                        IFMTU       => '1514',
                        IFSTATUS    => 'down(2)',
                        IFSPEED     => '100000000',
                        IFOUTERRORS => '0',
                        IFNUMBER    => '14',
                        IFOUTOCTETS => '0',
                        IFTYPE      => 'ethernetCsmacd(6)',
                        IFINOCTETS  => '0',
                        IFDESCR =>
        'Nortel Networks <unknown> Ethernet Switch Module - Port 14  ',
                        MAC              => '00:15:40:94:75:A0',
                        IFNAME           => 'ifc14 (Slot: 1 Port: 14)',
                        IFINERRORS       => '0',
                        IFLASTCHANGE     => '(55) 0:00:00.55',
                        IFINTERNALSTATUS => 'up(1)'
                    },
                    {
                        IFMTU       => '1514',
                        IFSTATUS    => 'up(1)',
                        IFSPEED     => '100000000',
                        IFOUTERRORS => '0',
                        IFNUMBER    => '15',
                        IFTYPE      => 'ethernetCsmacd(6)',
                        IFINOCTETS  => '177031254',
                        IFOUTOCTETS => '424051585',
                        CONNECTIONS => {
                            CONNECTION => {
                                MAC => [ '00:19:B9:23:05:D4' ]
                            }
                        },
                        MAC    => '00:15:40:94:75:A0',
                        IFNAME => 'ifc15 (Slot: 1 Port: 15)',
                        IFDESCR =>
        'Nortel Networks <unknown> Ethernet Switch Module - Port 15  ',
                        IFINERRORS       => '0',
                        IFLASTCHANGE     => '(76338315) 8 days, 20:03:03.15',
                        IFINTERNALSTATUS => 'up(1)'
                    },
                    {
                        IFINTERNALSTATUS => 'up(1)',
                        IFLASTCHANGE     => '(55) 0:00:00.55',
                        IFINERRORS       => '0',
                        IFDESCR =>
        'Nortel Networks <unknown> Ethernet Switch Module - Port 16  ',
                        MAC         => '00:15:40:94:75:A0',
                        IFNAME      => 'ifc16 (Slot: 1 Port: 16)',
                        IFTYPE      => 'ethernetCsmacd(6)',
                        IFOUTOCTETS => '0',
                        IFINOCTETS  => '0',
                        IFNUMBER    => '16',
                        IFOUTERRORS => '0',
                        IFSPEED     => '100000000',
                        IFSTATUS    => 'down(2)',
                        IFMTU       => '1514'
                    },
                    {
                        IFTYPE           => 'ethernetCsmacd(6)',
                        IFOUTOCTETS      => '261500106',
                        IFINOCTETS       => '75037757',
                        IFNUMBER         => '17',
                        IFSPEED          => '100000000',
                        IFOUTERRORS      => '0',
                        IFSTATUS         => 'up(1)',
                        IFMTU            => '1514',
                        IFINTERNALSTATUS => 'up(1)',
                        IFLASTCHANGE     => '(75891715) 8 days, 18:48:37.15',
                        IFINERRORS       => '37',
                        CONNECTIONS      => {
                            CONNECTION => {
                                MAC => [ '00:24:81:1D:86:D0' ]
                            }
                        },
                        IFNAME => 'ifc17 (Slot: 1 Port: 17)',
                        MAC    => '00:15:40:94:75:A0',
                        IFDESCR =>
                          'Nortel Networks <unknown> Ethernet Switch Module - Port 17  '
                    },
                    {
                        IFINTERNALSTATUS => 'up(1)',
                        IFLASTCHANGE     => '(55) 0:00:00.55',
                        IFINERRORS       => '0',
                        IFDESCR =>
        'Nortel Networks <unknown> Ethernet Switch Module - Port 18  ',
                        MAC         => '00:15:40:94:75:A0',
                        IFNAME      => 'ifc18 (Slot: 1 Port: 18)',
                        IFTYPE      => 'ethernetCsmacd(6)',
                        IFINOCTETS  => '0',
                        IFOUTOCTETS => '0',
                        IFNUMBER    => '18',
                        IFOUTERRORS => '0',
                        IFSPEED     => '100000000',
                        IFSTATUS    => 'down(2)',
                        IFMTU       => '1514'
                    },
                    {
                        IFINERRORS => '0',
                        MAC        => '00:15:40:94:75:A0',
                        IFNAME     => 'ifc19 (Slot: 1 Port: 19)',
                        IFDESCR =>
        'Nortel Networks <unknown> Ethernet Switch Module - Port 19  ',
                        IFINTERNALSTATUS => 'up(1)',
                        IFLASTCHANGE     => '(775692) 2:09:16.92',
                        IFMTU            => '1514',
                        IFSTATUS         => 'down(2)',
                        IFSPEED          => '100000000',
                        IFOUTERRORS      => '0',
                        IFTYPE           => 'ethernetCsmacd(6)',
                        IFINOCTETS       => '1569595',
                        IFOUTOCTETS      => '4611271',
                        IFNUMBER         => '19'
                    },
                    {
                        IFINERRORS => '0',
                        IFNAME     => 'ifc20 (Slot: 1 Port: 20)',
                        IFDESCR =>
        'Nortel Networks <unknown> Ethernet Switch Module - Port 20  ',
                        MAC              => '00:15:40:94:75:A0',
                        IFINTERNALSTATUS => 'up(1)',
                        IFLASTCHANGE     => '(55) 0:00:00.55',
                        IFSTATUS         => 'down(2)',
                        IFMTU            => '1514',
                        IFTYPE           => 'ethernetCsmacd(6)',
                        IFINOCTETS       => '0',
                        IFOUTOCTETS      => '0',
                        IFNUMBER         => '20',
                        IFSPEED          => '100000000',
                        IFOUTERRORS      => '0'
                    },
                    {
                        IFSPEED          => '100000000',
                        IFOUTERRORS      => '0',
                        IFTYPE           => 'ethernetCsmacd(6)',
                        IFOUTOCTETS      => '0',
                        IFINOCTETS       => '0',
                        IFNUMBER         => '21',
                        IFMTU            => '1514',
                        IFSTATUS         => 'down(2)',
                        IFINTERNALSTATUS => 'up(1)',
                        IFLASTCHANGE     => '(55) 0:00:00.55',
                        IFINERRORS       => '0',
                        MAC              => '00:15:40:94:75:A0',
                        IFNAME           => 'ifc21 (Slot: 1 Port: 21)',
                        IFDESCR =>
                          'Nortel Networks <unknown> Ethernet Switch Module - Port 21  '
                    },
                    {
                        IFINERRORS => '0',
                        IFNAME     => 'ifc22 (Slot: 1 Port: 22)',
                        IFDESCR =>
        'Nortel Networks <unknown> Ethernet Switch Module - Port 22  ',
                        MAC              => '00:15:40:94:75:A0',
                        IFINTERNALSTATUS => 'up(1)',
                        IFLASTCHANGE     => '(55) 0:00:00.55',
                        IFMTU            => '1514',
                        IFSTATUS         => 'down(2)',
                        IFSPEED          => '100000000',
                        IFOUTERRORS      => '0',
                        IFOUTOCTETS      => '0',
                        IFTYPE           => 'ethernetCsmacd(6)',
                        IFINOCTETS       => '0',
                        IFNUMBER         => '22'
                    },
                    {
                        IFLASTCHANGE     => '(55) 0:00:00.55',
                        IFINTERNALSTATUS => 'up(1)',
                        MAC              => '00:15:40:94:75:A0',
                        IFDESCR =>
        'Nortel Networks <unknown> Ethernet Switch Module - Port 23  ',
                        IFNAME      => 'ifc23 (Slot: 1 Port: 23)',
                        IFINERRORS  => '0',
                        IFNUMBER    => '23',
                        IFTYPE      => 'ethernetCsmacd(6)',
                        IFOUTOCTETS => '0',
                        IFINOCTETS  => '0',
                        IFOUTERRORS => '0',
                        IFSPEED     => '100000000',
                        IFSTATUS    => 'down(2)',
                        IFMTU       => '1514'
                    },
                    {
                        IFMTU       => '1514',
                        IFSTATUS    => 'down(2)',
                        IFSPEED     => '100000000',
                        IFOUTERRORS => '0',
                        IFNUMBER    => '24',
                        IFTYPE      => 'ethernetCsmacd(6)',
                        IFOUTOCTETS => '0',
                        IFINOCTETS  => '0',
                        IFDESCR =>
        'Nortel Networks <unknown> Ethernet Switch Module - Port 24  ',
                        IFNAME           => 'ifc24 (Slot: 1 Port: 24)',
                        MAC              => '00:15:40:94:75:A0',
                        IFINERRORS       => '0',
                        IFLASTCHANGE     => '(55) 0:00:00.55',
                        IFINTERNALSTATUS => 'up(1)'
                    },
                    {
                        IFLASTCHANGE     => '(13836) 0:02:18.36',
                        IFINTERNALSTATUS => 'up(1)',
                        CONNECTIONS      => {
                            CONNECTION => {
                                MAC => [
                                    '00:00:5E:00:01:01', '00:00:5E:00:01:77',
                                    '00:01:E6:9B:C1:94', '00:01:E6:9D:45:68',
                                    '00:0A:5E:54:54:3D', '00:0B:CD:69:12:DD',
                                    '00:0B:CD:CB:FB:74', '00:0B:CD:CC:0E:AA',
                                    '00:0B:CD:CC:08:38', '00:0B:CD:EE:8A:07',
                                    '00:0C:85:53:7F:99', '00:0C:85:53:86:99',
                                    '00:0C:30:68:63:41', '00:0D:88:11:76:A9',
                                    '00:0D:9D:D8:E8:97', '00:0D:9D:4D:F0:09',
                                    '00:0E:7F:FD:88:AF', '00:0E:7F:FD:59:DF',
                                    '00:0E:7F:21:CD:5E', '00:0E:7F:2B:64:13',
                                    '00:0E:7F:2C:F8:89', '00:0F:FE:74:4D:D9',
                                    '00:0F:1F:8D:3B:33', '00:0F:20:6D:D0:E5',
                                    '00:11:43:2B:0D:4B', '00:11:58:9B:2F:30',
                                    '00:12:79:D3:5D:55', '00:12:3F:2B:C3:BE',
                                    '00:12:3F:44:05:B0', '00:12:3F:46:7B:22',
                                    '00:12:3F:47:F7:D3', '00:12:3F:47:36:AD',
                                    '00:12:3F:47:41:4D', '00:12:3F:47:53:3E',
                                    '00:12:3F:47:57:2B', '00:12:3F:47:5D:5C',
                                    '00:12:3F:47:5E:87', '00:12:3F:47:5E:2F',
                                    '00:12:3F:47:5F:E6', '00:12:3F:47:61:A3',
                                    '00:12:3F:48:1F:1B', '00:12:3F:48:4E:89',
                                    '00:12:3F:4A:86:03', '00:12:3F:4A:90:18',
                                    '00:12:3F:4A:96:51', '00:13:65:54:82:00',
                                    '00:13:65:54:82:0E', '00:13:72:77:F9:C0',
                                    '00:13:72:7D:96:DD', '00:13:21:6B:8C:C1',
                                    '00:13:21:6B:48:3E', '00:13:21:6B:48:3F',
                                    '00:13:21:07:79:78', '00:C0:FF:08:25:BA',
                                    '00:02:A5:44:17:C7', '00:02:A5:44:17:2C',
                                    '00:02:A5:44:18:A4', '00:02:A5:44:19:0A',
                                    '00:02:A5:44:19:54', '00:14:0D:2E:32:00',
                                    '00:14:0D:2E:32:0E', '00:14:C7:8C:00:00',
                                    '00:14:FD:12:F0:12', '00:14:22:2D:F3:E9',
                                    '00:14:22:2D:F6:7B', '00:14:22:2D:F7:6A',
                                    '00:14:22:2E:8D:62', '00:14:22:2E:8E:A0',
                                    '00:14:22:2E:10:69', '00:14:22:2E:10:BE',
                                    '00:14:22:2E:10:1D', '00:14:22:2E:A8:3D',
                                    '00:14:22:2E:C7:BD', '00:14:22:2E:C9:3F',
                                    '00:14:38:BF:57:BF', '00:14:38:C4:65:8E',
                                    '00:14:38:C4:65:8F', '00:14:38:4C:33:90',
                                    '00:14:38:4F:8A:3E', '00:14:38:50:23:54',
                                    '00:14:4F:66:EF:E6', '00:14:4F:66:EF:4C',
                                    '00:14:4F:41:48:5C', '00:14:4F:41:48:5D',
                                    '00:15:E8:D1:1F:81', '00:15:5D:01:B7:01',
                                    '00:15:5D:01:B7:02', '00:15:5D:01:B7:03',
                                    '00:15:5D:01:B7:04', '00:15:5D:01:34:0F',
                                    '00:15:5D:01:34:11', '00:15:5D:01:34:12',
                                    '00:15:5D:01:34:08', '00:15:5D:07:46:0B',
                                    '00:15:5D:07:46:0F', '00:15:5D:07:46:10',
                                    '00:15:5D:07:46:13', '00:15:5D:07:46:04',
                                    '00:15:5D:07:46:08', '00:16:35:7F:E6:DF',
                                    '00:16:35:81:4A:15', '00:17:A4:0E:7C:9A',
                                    '00:19:B9:20:DD:2F', '00:19:B9:20:E1:F7',
                                    '00:19:B9:20:E5:F4', '00:19:B9:20:E6:40',
                                    '00:03:BA:01:78:14', '00:03:BA:9B:5B:C5',
                                    '00:03:BA:A8:DF:9D', '00:03:BA:43:F2:51',
                                    '00:03:BA:49:1A:E3', '00:03:BA:49:1A:E4',
                                    '00:20:A7:01:6B:01', '00:20:A7:01:98:21',
                                    '00:21:5A:7B:CF:97', '00:21:5A:5B:DD:FA',
                                    '00:22:64:A9:2F:3C', '00:22:64:B2:21:B8',
                                    '00:22:64:19:9E:5E', '00:22:64:19:D8:42',
                                    '00:22:64:2F:DA:76', '00:22:64:2F:DA:87',
                                    '00:22:67:89:6C:00', '00:23:AE:91:04:A8',
                                    '00:23:AE:91:09:61', '00:24:81:17:1F:BC',
                                    '00:24:81:1D:88:47', '00:24:8C:1D:64:BB',
                                    '00:24:8C:1D:69:EE', '00:24:8C:1D:6F:CB',
                                    '00:24:8C:1D:70:3B', '00:24:8C:1D:70:3C',
                                    '00:24:8C:1D:61:FF', '00:24:8C:1D:63:24',
                                    '00:24:8C:1D:63:3A', '00:25:64:9B:81:14',
                                    '00:25:64:9B:82:68', '00:25:64:9B:88:7F',
                                    '00:25:64:9B:88:3B', '00:25:64:9B:89:29',
                                    '00:04:DC:46:E5:81', '00:30:6E:F3:87:7C',
                                    '00:07:32:0F:9C:D5', '00:09:97:8C:98:60',
                                    '00:60:16:01:2A:D4', '64:31:50:22:19:52',
                                    '68:B5:99:CB:03:DA', '68:B5:99:CB:63:8A',
                                    '68:B5:99:CB:63:96', '68:B5:99:CB:63:A8',
                                    '68:B5:99:CB:63:D6', '68:B5:99:CB:63:DE',
                                    'B8:AC:6F:37:8E:CD', 'B8:AC:6F:37:90:58',
                                    'B8:AC:6F:37:99:BB', 'B8:AC:6F:37:9D:02',
                                    'E0:26:36:83:30:40', '18:A9:05:59:C1:90',
                                    '18:A9:05:59:C1:92', '44:1E:A1:46:89:6A',
                                    '08:17:F4:3A:FE:00', '08:17:F4:3B:A6:00'
                                ]
                            }
                        },
                        MAC    => '00:15:40:94:75:A0',
                        IFNAME => 'ifc25 (Slot: 1 Port: 25)',
                        IFDESCR =>
        'Nortel Networks <unknown> Ethernet Switch Module - Port 25  ',
                        IFINERRORS  => '0',
                        IFNUMBER    => '25',
                        IFOUTOCTETS => '1628279966',
                        IFTYPE      => 'ethernetCsmacd(6)',
                        IFINOCTETS  => '254286165',
                        IFOUTERRORS => '0',
                        IFSPEED     => '1000000000',
                        IFSTATUS    => 'up(1)',
                        IFMTU       => '1514'
                    },
                    {
                        IFNAME => 'ifc26 (Slot: 1 Port: 26)',
                        MAC    => '00:15:40:94:75:A0',
                        IFDESCR =>
        'Nortel Networks <unknown> Ethernet Switch Module - Port 26  ',
                        IFINERRORS       => '0',
                        IFLASTCHANGE     => '(55) 0:00:00.55',
                        IFINTERNALSTATUS => 'up(1)',
                        IFMTU            => '1514',
                        IFSTATUS         => 'down(2)',
                        IFSPEED          => '1000000000',
                        IFOUTERRORS      => '0',
                        IFNUMBER         => '26',
                        IFTYPE           => 'ethernetCsmacd(6)',
                        IFOUTOCTETS      => '0',
                        IFINOCTETS       => '0'
                    }
                ]
            }
        }
    ],
    'nortel/unknown2.walk' => [
        {
            MANUFACTURER => 'Nortel',
            TYPE         => 'NETWORKING',
            DESCRIPTION  => 'Ethernet Switch 470-24T      HW:34       FW:3.6.0.6   SW:v3.6.2.04 BN:4 ISVN:2 (c) Nortel Networks',
            SNMPHOSTNAME => '470_99_OBS',
            MAC          => '00:1D:AF:EA:A0:E2'
        },
        {
            MANUFACTURER => 'Nortel',
            TYPE         => 'NETWORKING',
            SERIAL       => 'LBNNTMJX5809LW',
            MODELSNMP    => 'Networking0316',
            FIRMWARE     => undef,
            SNMPHOSTNAME => '470_99_OBS',
            MODEL        => undef,
            DESCRIPTION  => 'Ethernet Switch 470-24T      HW:34       FW:3.6.0.6   SW:v3.6.2.04 BN:4 ISVN:2 (c) Nortel Networks',
            MAC          => '00:1D:AF:EA:A0:E2'
        },
        {
            INFO => {
                MANUFACTURER => 'Nortel',
                TYPE         => 'NETWORKING',
                SERIAL       => 'LBNNTMJX5809LW',
                MODEL        => '470-24T',
                NAME         => '470_99_OBS',
                ID           => undef,
                MAC          => '00:1D:AF:EA:A0:E2',
                LOCATION     => 'Salle Informatique',
                COMMENTS     => 'Ethernet Switch 470-24T      HW:34       FW:3.6.0.6   SW:v3.6.2.04 BN:4 ISVN:2 (c) Nortel Networks',
            },
            PORTS => {
                PORT => [
                    {
                        MAC => '00:1D:AF:EA:A0:E0',
                        IFSPEED => '100000000',
                        IFDESCR => 'Nortel Ethernet Switch 470-24T Module - Port 1  ',
                        IFNUMBER => '1',
                        IFLASTCHANGE => '(13930) 0:02:19.30',
                        IFTYPE => 'ethernetCsmacd(6)',
                        IFINOCTETS => '1111832468',
                        IFMTU => '1514',
                        CONNECTIONS => {
                            CONNECTION => {
                                MAC => [
                                    '00:12:EF:41:30:BB'
                                    ]
                            }
                        },
                        IFOUTERRORS => '0',
                        IFINERRORS => '0',
                        IFOUTOCTETS => '3597292020'
                    },
                    {
                        IFSPEED => '100000000',
                        MAC => '00:1D:AF:EA:A0:E0',
                        IFNUMBER => '2',
                        IFDESCR => 'Nortel Ethernet Switch 470-24T Module - Port 2  ',
                        IFLASTCHANGE => '(10880) 0:01:48.80',
                        IFMTU => '1514',
                        CONNECTIONS => {
                            CONNECTION => {
                                MAC => [
                                    '00:12:EF:41:30:A8'
                                    ]
                            }
                        },
                        IFTYPE => 'ethernetCsmacd(6)',
                        IFINOCTETS => '1924076684',
                        IFOUTERRORS => '0',
                        IFINERRORS => '0',
                        IFOUTOCTETS => '103236673'
                    },
                    {
                        IFNUMBER => '3',
                        IFDESCR => 'Nortel Ethernet Switch 470-24T Module - Port 3  ',
                        IFLASTCHANGE => '(81099) 0:13:30.99',
                        MAC => '00:1D:AF:EA:A0:E0',
                        IFSPEED => '100000000',
                        IFOUTERRORS => '0',
                        IFINERRORS => '2',
                        IFOUTOCTETS => '1137599330',
                        IFTYPE => 'ethernetCsmacd(6)',
                        IFINOCTETS => '3571167735',
                        IFMTU => '1514',
                        CONNECTIONS => {
                            CONNECTION => {
                                MAC => [
                                    '00:0D:B4:02:20:0C'
                                    ]
                            }
                        }
                    },
                    {
                        IFTYPE => 'ethernetCsmacd(6)',
                        IFINOCTETS => '1264',
                        IFMTU => '1514',
                        IFINERRORS => '0',
                        IFOUTOCTETS => '26786780',
                        IFOUTERRORS => '0',
                        MAC => '00:1D:AF:EA:A0:E0',
                        IFSPEED => '100000000',
                        IFLASTCHANGE => '(60244953) 6 days, 23:20:49.53',
                        IFDESCR => 'Nortel Ethernet Switch 470-24T Module - Port 4  ',
                        IFNUMBER => '4'
                    },
                    {
                        IFSPEED => '100000000',
                        MAC => '00:1D:AF:EA:A0:E0',
                        IFLASTCHANGE => '(7005250) 19:27:32.50',
                        IFNUMBER => '5',
                        IFDESCR => 'Nortel Ethernet Switch 470-24T Module - Port 5  ',
                        IFMTU => '1514',
                        CONNECTIONS => {
                            CONNECTION => {
                                MAC => [
                                    '00:30:48:96:81:51'
                                    ]
                            }
                        },
                        IFINOCTETS => '76955793',
                        IFTYPE => 'ethernetCsmacd(6)',
                        IFOUTOCTETS => '1950190804',
                        IFINERRORS => '0',
                        IFOUTERRORS => '0'
                    },
                    {
                        IFNUMBER => '6',
                        IFDESCR => 'Nortel Ethernet Switch 470-24T Module - Port 6  ',
                        IFLASTCHANGE => '(60246350) 6 days, 23:21:03.50',
                        IFSPEED => '100000000',
                        MAC => '00:1D:AF:EA:A0:E0',
                        IFOUTERRORS => '0',
                        IFINERRORS => '0',
                        IFOUTOCTETS => '26419930',
                        IFMTU => '1514',
                        IFINOCTETS => '156912',
                        IFTYPE => 'ethernetCsmacd(6)'
                    },
                    {
                        IFINERRORS => '1',
                        IFOUTOCTETS => '523818070',
                        IFOUTERRORS => '0',
                        IFTYPE => 'ethernetCsmacd(6)',
                        IFINOCTETS => '590382976',
                        CONNECTIONS => {
                            CONNECTION => {
                                MAC => [
                                    '00:0D:B4:02:20:0D'
                                    ]
                            }
                        },
                        IFMTU => '1514',
                        IFLASTCHANGE => '(81149) 0:13:31.49',
                        IFNUMBER => '7',
                        IFDESCR => 'Nortel Ethernet Switch 470-24T Module - Port 7  ',
                        MAC => '00:1D:AF:EA:A0:E0',
                        IFSPEED => '100000000'
                    },
                    {
                        IFNUMBER => '8',
                        IFDESCR => 'Nortel Ethernet Switch 470-24T Module - Port 8  ',
                        IFLASTCHANGE => '(60245003) 6 days, 23:20:50.03',
                        IFSPEED => '100000000',
                        MAC => '00:1D:AF:EA:A0:E0',
                        IFOUTERRORS => '0',
                        IFINERRORS => '0',
                        IFOUTOCTETS => '26659895',
                        IFMTU => '1514',
                        IFINOCTETS => '5696',
                        IFTYPE => 'ethernetCsmacd(6)'
                    },
                    {
                        IFSPEED => '100000000',
                        MAC => '00:1D:AF:EA:A0:E0',
                        IFDESCR => 'Nortel Ethernet Switch 470-24T Module - Port 9  ',
                        IFNUMBER => '9',
                        IFLASTCHANGE => '(28) 0:00:00.28',
                        IFMTU => '1514',
                        IFTYPE => 'ethernetCsmacd(6)',
                        IFINOCTETS => '0',
                        IFOUTERRORS => '0',
                        IFINERRORS => '0',
                        IFOUTOCTETS => '0'
                    },
                    {
                        IFLASTCHANGE => '(29) 0:00:00.29',
                        IFNUMBER => '10',
                        IFDESCR => 'Nortel Ethernet Switch 470-24T Module - Port 10  ',
                        MAC => '00:1D:AF:EA:A0:E0',
                        IFSPEED => '100000000',
                        IFINERRORS => '0',
                        IFOUTOCTETS => '0',
                        IFOUTERRORS => '0',
                        IFTYPE => 'ethernetCsmacd(6)',
                        IFINOCTETS => '0',
                        IFMTU => '1514'
                    },
                    {
                        MAC => '00:1D:AF:EA:A0:E0',
                        IFSPEED => '100000000',
                        IFDESCR => 'Nortel Ethernet Switch 470-24T Module - Port 11  ',
                        IFNUMBER => '11',
                        IFLASTCHANGE => '(81199) 0:13:31.99',
                        IFINOCTETS => '256',
                        IFTYPE => 'ethernetCsmacd(6)',
                        IFMTU => '1514',
                        IFOUTERRORS => '0',
                        IFINERRORS => '0',
                        IFOUTOCTETS => '4354176'
                    },
                    {
                        IFOUTERRORS => '0',
                        IFINERRORS => '0',
                        IFOUTOCTETS => '4356864',
                        IFMTU => '1514',
                        IFINOCTETS => '0',
                        IFTYPE => 'ethernetCsmacd(6)',
                        IFNUMBER => '12',
                        IFDESCR => 'Nortel Ethernet Switch 470-24T Module - Port 12  ',
                        IFLASTCHANGE => '(60245053) 6 days, 23:20:50.53',
                        IFSPEED => '100000000',
                        MAC => '00:1D:AF:EA:A0:E0'
                    },
                    {
                        IFOUTOCTETS => '0',
                        IFINERRORS => '0',
                        IFOUTERRORS => '0',
                        IFINOCTETS => '0',
                        IFTYPE => 'ethernetCsmacd(6)',
                        IFMTU => '1514',
                        IFLASTCHANGE => '(29) 0:00:00.29',
                        IFDESCR => 'Nortel Ethernet Switch 470-24T Module - Port 13  ',
                        IFNUMBER => '13',
                        MAC => '00:1D:AF:EA:A0:E0',
                        IFSPEED => '100000000'
                    },
                    {
                        IFINOCTETS => '0',
                        IFTYPE => 'ethernetCsmacd(6)',
                        IFMTU => '1514',
                        IFINERRORS => '0',
                        IFOUTOCTETS => '0',
                        IFOUTERRORS => '0',
                        MAC => '00:1D:AF:EA:A0:E0',
                        IFSPEED => '100000000',
                        IFLASTCHANGE => '(30) 0:00:00.30',
                        IFDESCR => 'Nortel Ethernet Switch 470-24T Module - Port 14  ',
                        IFNUMBER => '14'
                    },
                    {
                        IFTYPE => 'ethernetCsmacd(6)',
                        IFINOCTETS => '0',
                        IFMTU => '1514',
                        IFOUTERRORS => '0',
                        IFOUTOCTETS => '0',
                        IFINERRORS => '0',
                        MAC => '00:1D:AF:EA:A0:E0',
                        IFSPEED => '100000000',
                        IFDESCR => 'Nortel Ethernet Switch 470-24T Module - Port 15  ',
                        IFNUMBER => '15',
                        IFLASTCHANGE => '(30) 0:00:00.30'
                    },
                    {
                        MAC => '00:1D:AF:EA:A0:E0',
                        IFSPEED => '100000000',
                        IFLASTCHANGE => '(30) 0:00:00.30',
                        IFDESCR => 'Nortel Ethernet Switch 470-24T Module - Port 16  ',
                        IFNUMBER => '16',
                        IFTYPE => 'ethernetCsmacd(6)',
                        IFINOCTETS => '0',
                        IFMTU => '1514',
                        IFINERRORS => '0',
                        IFOUTOCTETS => '0',
                        IFOUTERRORS => '0'
                    },
                    {
                        IFMTU => '1514',
                        IFINOCTETS => '0',
                        IFTYPE => 'ethernetCsmacd(6)',
                        IFINERRORS => '0',
                        IFOUTOCTETS => '0',
                        IFOUTERRORS => '0',
                        IFSPEED => '100000000',
                        MAC => '00:1D:AF:EA:A0:E0',
                        IFLASTCHANGE => '(30) 0:00:00.30',
                        IFDESCR => 'Nortel Ethernet Switch 470-24T Module - Port 17  ',
                        IFNUMBER => '17'
                    },
                    {
                        IFOUTERRORS => '0',
                        IFINERRORS => '0',
                        IFOUTOCTETS => '0',
                        IFMTU => '1514',
                        IFTYPE => 'ethernetCsmacd(6)',
                        IFINOCTETS => '0',
                        IFDESCR => 'Nortel Ethernet Switch 470-24T Module - Port 18  ',
                        IFNUMBER => '18',
                        IFLASTCHANGE => '(30) 0:00:00.30',
                        IFSPEED => '100000000',
                        MAC => '00:1D:AF:EA:A0:E0'
                    },
                    {
                        IFNUMBER => '19',
                        IFDESCR => 'Nortel Ethernet Switch 470-24T Module - Port 19  ',
                        IFLASTCHANGE => '(30) 0:00:00.30',
                        MAC => '00:1D:AF:EA:A0:E0',
                        IFSPEED => '100000000',
                        IFOUTERRORS => '0',
                        IFINERRORS => '0',
                        IFOUTOCTETS => '0',
                        IFINOCTETS => '0',
                        IFTYPE => 'ethernetCsmacd(6)',
                        IFMTU => '1514'
                    },
                    {
                        MAC => '00:1D:AF:EA:A0:E0',
                        IFSPEED => '100000000',
                        IFLASTCHANGE => '(30) 0:00:00.30',
                        IFDESCR => 'Nortel Ethernet Switch 470-24T Module - Port 20  ',
                        IFNUMBER => '20',
                        IFINOCTETS => '0',
                        IFTYPE => 'ethernetCsmacd(6)',
                        IFMTU => '1514',
                        IFINERRORS => '0',
                        IFOUTOCTETS => '0',
                        IFOUTERRORS => '0'
                    },
                    {
                        IFOUTOCTETS => '0',
                        IFINERRORS => '0',
                        IFOUTERRORS => '0',
                        IFTYPE => 'ethernetCsmacd(6)',
                        IFINOCTETS => '0',
                        IFMTU => '1514',
                        IFLASTCHANGE => '(30) 0:00:00.30',
                        IFDESCR => 'Nortel Ethernet Switch 470-24T Module - Port 21  ',
                        IFNUMBER => '21',
                        MAC => '00:1D:AF:EA:A0:E0',
                        IFSPEED => '100000000'
                    },
                    {
                        IFDESCR => 'Nortel Ethernet Switch 470-24T Module - Port 22  ',
                        IFNUMBER => '22',
                        IFLASTCHANGE => '(31) 0:00:00.31',
                        IFSPEED => '100000000',
                        MAC => '00:1D:AF:EA:A0:E0',
                        IFOUTERRORS => '0',
                        IFINERRORS => '0',
                        IFOUTOCTETS => '0',
                        IFMTU => '1514',
                        IFINOCTETS => '0',
                        IFTYPE => 'ethernetCsmacd(6)'
                    },
                    {
                        IFMTU => '1514',
                        CONNECTIONS => {
                            CONNECTION => {
                                MAC => [
                                    '00:00:85:BE:8A:C8',
                                '00:00:85:BE:96:38',
                                '00:00:85:BE:96:47',
                                '00:00:85:E0:6A:F4',
                                '00:00:BC:38:70:92',
                                '00:00:5E:00:01:05',
                                '00:01:02:A2:EE:10',
                                '00:01:02:A2:F0:72',
                                '00:01:02:13:9A:A2',
                                '00:01:E6:76:FB:4F',
                                '00:01:E6:89:F3:C2',
                                '00:01:E6:8C:BA:7F',
                                '00:01:E6:60:DB:F0',
                                '00:01:03:0C:C5:1B',
                                '00:01:03:11:CC:C4',
                                '00:01:29:14:3A:88',
                                '00:01:05:03:B7:3E',
                                '00:01:05:03:B7:50',
                                '00:01:05:04:94:2E',
                                '00:01:05:04:94:4A',
                                '00:0A:E4:C1:87:70',
                                '00:0A:E4:C1:87:7B',
                                '00:0A:E4:C1:8C:EC',
                                '00:0A:E4:2E:94:FE',
                                '00:0A:E4:39:52:09',
                                '00:0B:CD:70:8F:AE',
                                '00:0E:0C:EB:13:4E',
                                '00:0E:7F:6B:6E:6F',
                                '00:0E:7F:E0:F7:96',
                                '00:0E:7F:F9:E5:4A',
                                '00:0E:7F:FA:18:CC',
                                '00:0E:7F:FA:18:D0',
                                '00:0E:7F:FA:1A:98',
                                '00:0E:7F:FB:90:F2',
                                '00:0E:7F:FC:B4:CF',
                                '00:0E:7F:FC:C3:65',
                                '00:0E:7F:FC:C3:DC',
                                '00:0E:7F:FC:C3:3E',
                                '00:0E:7F:FC:CC:E8',
                                '00:0E:7F:FC:CD:4C',
                                '00:0E:7F:28:DD:C2',
                                '00:0E:7F:2A:59:76',
                                '00:0E:8C:A8:DD:26',
                                '00:0E:8C:A9:45:DB',
                                '00:0E:8C:C5:03:77',
                                '00:90:27:78:FB:A2',
                                '00:0F:FE:4F:0D:4A',
                                '00:0F:20:FA:C3:79',
                                '00:0F:20:FA:C3:80',
                                '00:0F:20:FA:C4:03',
                                '00:0F:20:FA:CC:23',
                                '00:0F:20:FA:CC:35',
                                '00:0F:20:FA:CC:43',
                                '00:0F:20:FA:CC:48',
                                '00:0F:20:FA:2C:D9',
                                '00:0F:20:2C:64:34',
                                '00:0F:20:2C:65:0B',
                                '00:0F:20:2C:72:C9',
                                '00:0F:20:2C:AD:B0',
                                '00:0F:20:2C:49:8D',
                                '00:0F:20:2C:63:DF',
                                '00:10:70:00:16:09',
                                '00:10:70:00:2E:D0',
                                '00:10:70:00:59:B1',
                                '00:10:70:03:0C:02',
                                '00:10:70:03:1E:FE',
                                '00:10:70:03:28:F2',
                                '00:10:70:04:10:FA',
                                '00:10:70:04:13:1E',
                                '00:10:70:04:22:B0',
                                '00:10:70:04:33:79',
                                '00:10:70:04:36:44',
                                '00:10:70:05:33:D3',
                                '00:10:70:05:4C:5E',
                                '00:10:5A:D6:58:E8',
                                '00:10:5A:DE:08:29',
                                '00:A0:24:AC:53:D2',
                                '00:A0:24:19:FF:FB',
                                '00:11:0A:3A:B3:72',
                                '00:11:0A:3A:B3:44',
                                '00:11:0A:3B:77:1E',
                                '00:11:0A:3B:9C:B4',
                                '00:11:0A:3B:A2:D4',
                                '00:11:0A:3B:A3:42',
                                '00:11:85:73:A1:FA',
                                '00:11:85:73:B4:30',
                                '00:11:85:73:B8:7A',
                                '00:12:EF:21:DE:E9',
                                '00:C0:EB:09:65:BC',
                                '00:C0:EB:09:65:15',
                                '00:C0:EE:6A:D4:8B',
                                '00:C0:EE:6A:D4:93',
                                '00:C0:EE:6B:3E:AA',
                                '00:C0:EE:6B:3E:C0',
                                '00:C0:EE:6B:3E:C6',
                                '00:C0:EE:6B:3E:C8',
                                '00:C0:EE:6B:3E:C9',
                                '00:C0:EE:6B:3E:CC',
                                '00:C0:EE:6B:3E:D6',
                                '00:C0:EE:6B:3E:D7',
                                '00:C0:EE:78:3B:6E',
                                '00:C0:EE:78:3B:4F',
                                '00:C0:EE:78:3B:54',
                                '00:C0:EE:49:97:4D',
                                '00:C0:EE:58:93:53',
                                '00:C0:EE:58:95:8B',
                                '00:C0:EE:58:99:46',
                                '00:C0:EE:58:C0:F6',
                                '00:C0:EE:5A:48:6F',
                                '00:02:3F:36:9C:2E',
                                '00:14:38:E4:08:72',
                                '00:D0:B7:47:A9:C1',
                                '00:15:60:04:5F:02',
                                '00:16:D3:B5:F0:FC',
                                '00:16:D3:B5:F1:E2',
                                '00:16:D3:B5:5D:BC',
                                '00:16:D3:CA:B6:54',
                                '00:16:D3:29:17:2C',
                                '00:16:D3:29:06:DB',
                                '00:16:D3:29:47:31',
                                '00:16:D3:2A:B1:C1',
                                '00:16:D3:2A:B2:7B',
                                '00:16:17:7E:90:2C',
                                '00:16:17:C5:D8:E2',
                                '00:16:17:C5:D9:6B',
                                '00:16:17:C5:D9:9B',
                                '00:16:17:C5:D9:A0',
                                '00:16:17:C5:D9:03',
                                '00:16:17:C5:D9:35',
                                '00:16:17:C5:E4:64',
                                '00:16:17:C6:A4:EE',
                                '00:16:17:C6:A9:DC',
                                '00:16:17:C6:AA:1F',
                                '00:16:17:C6:AA:2D',
                                '00:16:17:C6:B7:36',
                                '00:16:17:C6:C3:A1',
                                '00:16:17:C6:C3:AA',
                                '00:16:17:C7:6B:69',
                                '00:16:17:C7:19:01',
                                '00:16:35:AD:A3:A0',
                                '00:16:35:AD:DC:D5',
                                '00:16:35:AE:7C:CE',
                                '00:16:35:AE:95:91',
                                '00:16:35:AE:96:2D',
                                '00:17:A4:44:8A:C3',
                                '00:17:23:0D:D5:7D',
                                '00:17:42:42:3F:6C',
                                '00:17:42:42:3F:52',
                                '00:17:08:7C:8A:CA',
                                '00:19:0F:00:F0:92',
                                '00:19:99:00:2B:B9',
                                '00:19:D1:55:31:03',
                                '00:19:5B:2E:D3:38',
                                '00:19:5B:2E:D3:3C',
                                '00:19:5B:31:7F:D0',
                                '00:19:5B:31:7F:D1',
                                '00:1A:6B:6B:6B:0F',
                                '00:1A:6B:6D:7F:63',
                                '00:1A:6B:6D:C4:0D',
                                '00:1A:4B:46:70:1F',
                                '00:1A:4B:46:7F:5C',
                                '00:1A:4B:46:81:EE',
                                '00:1A:4B:46:83:2E',
                                '00:1A:4B:46:60:61',
                                '00:1A:4B:47:4C:F0',
                                '00:1A:4B:47:54:F8',
                                '00:1A:4B:47:54:39',
                                '00:1A:4B:47:57:FF',
                                '00:1A:4B:47:59:B5',
                                '00:1A:4D:5A:63:75',
                                '00:1B:78:B6:94:34',
                                '00:1B:78:B6:97:84',
                                '00:1B:78:B6:97:97',
                                '00:1B:78:B6:97:AA',
                                '00:1B:78:B6:97:C0',
                                '00:1B:78:B6:97:D5',
                                '00:1B:78:B6:98:F9',
                                '00:1B:78:B6:99:B1',
                                '00:1B:78:B6:99:D8',
                                '00:1B:78:B6:99:5A',
                                '00:1B:78:B6:BE:77',
                                '00:1B:78:B6:BE:9B',
                                '00:1B:78:B6:BE:DF',
                                '00:1B:78:B6:BE:F5',
                                '00:1B:78:B6:C0:A8',
                                '00:1B:78:B6:56:43',
                                '00:1B:78:22:33:29',
                                '00:1B:78:22:46:84',
                                '00:1B:21:0D:A7:88',
                                '00:1C:C4:D8:84:DC',
                                '00:1C:C4:D8:C3:60',
                                '00:1C:C4:DE:9C:E2',
                                '00:1C:C4:E2:E5:AE',
                                '00:1C:C4:1A:64:82',
                                '00:1C:C4:1A:34:14',
                                '00:1C:C4:1A:34:53',
                                '00:1C:C4:1A:5A:05',
                                '00:1C:C4:1A:63:6B',
                                '00:1C:C4:1A:63:5A',
                                '00:1C:C4:5D:C8:F4',
                                '00:1C:C4:60:39:8A',
                                '00:1C:C4:63:E5:0D',
                                '00:1C:EB:33:58:40',
                                '00:1C:EB:33:58:41',
                                '00:1C:EB:33:58:42',
                                '00:1C:EB:33:58:43',
                                '00:1C:EB:33:58:49',
                                '00:1C:25:99:86:C4',
                                '00:1C:25:99:86:16',
                                '00:1C:25:99:86:19',
                                '00:1C:25:99:86:20',
                                '00:1C:25:99:87:32',
                                '00:1C:25:99:87:34',
                                '00:1C:25:A1:2E:EC',
                                '00:1D:72:84:C3:66',
                                '00:1D:72:8A:46:F2',
                                '00:1D:92:E2:8E:8A',
                                '00:1D:92:E4:05:EE',
                                '00:1D:92:E4:05:EF',
                                '00:1D:92:E4:05:FD',
                                '00:03:47:AD:D7:21',
                                '00:03:47:AD:D8:B5',
                                '00:1E:0B:A6:3A:39',
                                '00:1E:58:A8:13:3C',
                                '00:1E:58:A8:13:3D',
                                '00:1E:58:A8:13:3E',
                                '00:1E:58:A8:15:A6',
                                '00:1F:16:0E:C6:71',
                                '00:1F:16:0E:DB:37',
                                '00:1F:16:0E:DB:3D',
                                '00:1F:16:17:AE:51',
                                '00:1F:16:29:C2:88',
                                '00:1F:16:29:C2:1B',
                                '00:1F:16:29:C3:23',
                                '00:1F:16:29:C3:40',
                                '00:1F:16:29:C3:60',
                                '00:1F:16:29:60:0B',
                                '00:21:85:01:7C:14',
                                '00:21:85:01:DC:7D',
                                '00:21:85:01:DC:7E',
                                '00:21:85:01:DC:1F',
                                '00:21:85:01:DC:22',
                                '00:21:85:01:DC:29',
                                '00:21:85:01:DC:41',
                                '00:21:85:01:DC:47',
                                '00:21:5A:1C:45:FB',
                                '00:23:7D:87:51:A4',
                                '00:23:7D:2B:FE:21',
                                '00:23:AE:92:70:87',
                                '00:23:AE:AE:2C:A6',
                                '00:24:81:C7:ED:40',
                                '00:24:81:C7:ED:51',
                                '00:24:81:E9:E3:66',
                                '00:24:81:E9:E3:74',
                                '00:24:81:E9:E3:87',
                                '00:24:81:E9:E3:8A',
                                '00:24:81:E9:E3:93',
                                '00:24:81:E9:E3:98',
                                '00:24:81:E9:E3:CF',
                                '00:24:81:E9:E3:D2',
                                '00:24:81:E9:E3:D6',
                                '00:24:81:E9:E3:DE',
                                '00:24:81:E9:E3:3E',
                                '00:24:81:E9:E3:41',
                                '00:24:81:E9:E3:43',
                                '00:24:81:E9:E3:45',
                                '00:24:81:E9:E3:57',
                                '00:24:81:E9:E3:5C',
                                '00:24:81:EA:D9:02',
                                '00:24:81:EA:DA:6E',
                                '00:24:81:EA:DA:74',
                                '00:24:81:EA:DA:79',
                                '00:24:81:EA:DA:81',
                                '00:24:81:EA:DA:8F',
                                '00:24:81:EA:DA:91',
                                '00:24:81:EA:DA:92',
                                '00:24:81:EA:DA:A7',
                                '00:24:81:EA:DA:C9',
                                '00:24:81:EA:DA:CD',
                                '00:24:81:EA:DA:CE',
                                '00:24:81:EA:DA:D8',
                                '00:24:81:EA:DA:F7',
                                '00:24:81:EA:DA:FC',
                                '00:24:81:F3:F4:CD',
                                '00:24:81:F3:F5:1D',
                                '00:24:81:F3:F5:1E',
                                '00:24:81:F3:F5:25',
                                '00:24:81:06:DE:4E',
                                '00:24:E8:B1:57:56',
                                '00:24:E8:B2:8C:74',
                                '00:24:E8:B2:8C:AB',
                                '00:24:E8:B2:8D:78',
                                '00:24:E8:B2:8D:3B',
                                '00:24:1D:C2:92:68',
                                '00:24:1D:C2:16:BC',
                                '00:25:B3:0A:44:C4',
                                '00:25:B3:0A:44:CF',
                                '00:25:B3:0A:44:D5',
                                '00:26:6C:94:01:4F',
                                '00:26:55:4A:A3:2A',
                                '00:27:19:C7:47:69',
                                '00:27:19:C7:47:6A',
                                '00:27:19:C7:47:6B',
                                '00:27:19:C7:47:81',
                                '00:27:19:C7:47:94',
                                '00:27:19:C7:47:62',
                                '00:04:75:52:5E:8B',
                                '00:04:23:13:B3:13',
                                '00:04:23:13:B6:E2',
                                '00:04:23:13:D8:A7',
                                '00:04:23:13:D8:CB',
                                '00:04:23:13:DD:9E',
                                '00:04:23:13:DD:A8',
                                '00:04:23:13:DD:B1',
                                '00:04:23:13:DD:D6',
                                '00:04:23:13:DD:DA',
                                '00:04:23:13:E4:E4',
                                '00:04:23:13:E5:56',
                                '00:04:23:13:EA:16',
                                '00:04:23:13:ED:45',
                                '00:04:23:1B:0B:04',
                                '00:04:23:1B:8B:6E',
                                '00:04:23:1B:8B:63',
                                '00:04:23:1B:0E:0A',
                                '00:04:23:1B:8C:66',
                                '00:04:23:1B:8C:0B',
                                '00:04:23:1B:8C:95',
                                '00:04:23:1B:8C:1B',
                                '00:04:23:1B:8D:89',
                                '00:04:23:1B:8D:B0',
                                '00:04:23:1B:8D:C8',
                                '00:04:23:1B:8E:47',
                                '00:04:23:1B:8E:4B',
                                '00:04:23:1B:8E:5B',
                                '00:04:23:1B:4E:B0',
                                '00:04:23:1B:4E:48',
                                '00:04:23:1B:4E:55',
                                '00:04:23:1B:4F:72',
                                '00:04:23:1B:4F:36',
                                '00:30:6E:F4:89:EE',
                                '00:30:6E:06:0A:DE',
                                '00:30:6E:06:79:E1',
                                '00:30:6E:4B:10:04',
                                '00:30:6E:4B:13:C4',
                                '00:30:05:99:EB:C6',
                                '00:30:05:99:EB:DE',
                                '00:30:05:9A:F2:FB',
                                '00:30:05:CD:CE:82',
                                '00:30:05:CD:CE:93',
                                '00:30:05:FB:9B:94',
                                '00:30:05:46:44:7A',
                                '00:30:05:46:44:F8',
                                '00:30:05:5E:36:74',
                                '00:05:5D:F5:05:61',
                                '00:40:CA:A1:70:2F',
                                '00:07:4D:37:6D:1D',
                                '00:07:4D:37:6D:63',
                                '00:08:9B:1B:43:2C',
                                '00:50:04:38:F5:14',
                                '00:50:56:73:2E:47',
                                '00:50:56:73:33:76',
                                '00:50:56:93:66:B2',
                                '00:50:56:93:6F:58',
                                '00:50:56:93:70:E3',
                                '00:50:56:93:7B:9F',
                                '00:50:56:93:7C:21',
                                '00:50:56:93:0E:63',
                                '00:50:56:93:10:F7',
                                '00:50:56:93:22:B7',
                                '00:50:56:93:26:6F',
                                '00:50:56:93:36:E8',
                                '00:50:56:93:39:2F',
                                '00:50:56:93:3C:E6',
                                '00:50:56:93:40:3E',
                                '00:50:56:93:4A:6B',
                                '00:50:56:93:4A:78',
                                '00:50:56:93:56:0A',
                                '00:50:56:93:59:77',
                                '00:50:56:93:09:8F',
                                '00:50:56:93:5B:97',
                                '00:50:56:93:5F:70',
                                '00:50:56:93:62:30',
                                '00:60:97:BD:43:E1',
                                '00:60:08:62:9D:6B',
                                '94:0C:6D:80:06:99',
                                'B8:AC:6F:48:C8:F1',
                                'E8:BE:81:1C:29:A3',
                                '3C:4A:92:42:64:61',
                                '40:61:86:0D:0A:A9',
                                '08:00:06:8F:A5:84',
                                '08:00:06:8F:A5:85',
                                '08:00:06:8F:A5:89',
                                '08:00:06:8F:A5:8B',
                                '08:00:06:8F:A5:95',
                                '08:00:06:8F:A5:17',
                                '08:00:06:8F:A5:06',
                                '08:00:06:8F:B4:D0',
                                '08:00:06:8F:B4:DC',
                                '08:00:06:8F:B4:DD',
                                '08:00:06:8F:B4:E6',
                                '08:00:06:8F:B4:E9',
                                '08:00:06:8F:B4:F1',
                                '08:00:06:8F:B5:EE',
                                '08:00:06:8F:B5:F5',
                                '08:00:06:8F:B5:FB',
                                '58:55:CA:F0:90:AD',
                                '5C:0E:8B:13:13:DD',
                                '5C:0E:8B:13:C5:B9',
                                '5C:0E:8B:13:C5:1D',
                                '5C:0E:8B:13:07:5B',
                                '5C:0E:8B:18:36:A8'
                                    ]
                            }
                        },
                        IFINOCTETS => '2065851792',
                        IFTYPE => 'ethernetCsmacd(6)',
                        IFOUTOCTETS => '849934883',
                        IFINERRORS => '0',
                        IFOUTERRORS => '0',
                        IFSPEED => '100000000',
                        MAC => '00:1D:AF:EA:A0:E0',
                        IFLASTCHANGE => '(13430) 0:02:14.30',
                        IFDESCR => 'Nortel Ethernet Switch 470-24T Module - Port 23  ',
                        IFNUMBER => '23'
                    },
                    {
                        MAC => '00:1D:AF:EA:A0:E0',
                        IFSPEED => '100000000',
                        IFLASTCHANGE => '(13580) 0:02:15.80',
                        IFNUMBER => '24',
                        IFDESCR => 'Nortel Ethernet Switch 470-24T Module - Port 24  ',
                        IFINOCTETS => '1377356854',
                        IFTYPE => 'ethernetCsmacd(6)',
                        CONNECTIONS => {
                            CONNECTION => {
                                MAC => [
                                    '00:1C:EB:33:58:00'
                                    ]
                            }
                        },
                        IFMTU => '1514',
                        IFINERRORS => '0',
                        IFOUTOCTETS => '12624866',
                        IFOUTERRORS => '0'
                    },
                    {
                        IFOUTOCTETS => '0',
                        IFINERRORS => '0',
                        IFOUTERRORS => '0',
                        IFTYPE => 'ethernetCsmacd(6)',
                        IFINOCTETS => '0',
                        IFMTU => '1514',
                        IFLASTCHANGE => '(31) 0:00:00.31',
                        IFNUMBER => '25',
                        IFDESCR => 'Nortel Ethernet Switch 470-24T Module - Port 25  ',
                        MAC => '00:1D:AF:EA:A0:E0',
                        IFSPEED => '1000000000'
                    },
                    {
                        IFDESCR => 'Nortel Ethernet Switch 470-24T Module - Port 26  ',
                        IFNUMBER => '26',
                        IFLASTCHANGE => '(31) 0:00:00.31',
                        MAC => '00:1D:AF:EA:A0:E0',
                        IFSPEED => '1000000000',
                        IFOUTERRORS => '0',
                        IFINERRORS => '0',
                        IFOUTOCTETS => '0',
                        IFTYPE => 'ethernetCsmacd(6)',
                        IFINOCTETS => '0',
                        IFMTU => '1514'
                    }
                ]
            },
        }
    ],
);

setPlan(scalar keys %tests);

my $dictionary = getDictionnary();
my $index      = getIndex();

foreach my $test (sort keys %tests) {
    my $snmp  = getSNMP($test);
    my $model = getModel($index, $tests{$test}->[1]->{MODELSNMP});

    my %device0 = getDeviceInfo($snmp);
    cmp_deeply(\%device0, $tests{$test}->[0], "$test: base stage");

    my %device1 = getDeviceInfo($snmp, $dictionary);
    cmp_deeply(\%device1, $tests{$test}->[1], "$test: base + dictionnary stage");

    my $device3 = getDeviceFullInfo(
        snmp  => $snmp,
        model => $model,
    );
    cmp_deeply($device3, $tests{$test}->[2], "$test: base + model stage");
}
