# Generated by default/object.tt
package Paws::IoTEvents::InitializationConfiguration;
  use Moose;
  has DisabledOnInitialization => (is => 'ro', isa => 'Bool', request_name => 'disabledOnInitialization', traits => ['NameInRequest'], required => 1);

1;

### main pod documentation begin ###

=head1 NAME

Paws::IoTEvents::InitializationConfiguration

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::IoTEvents::InitializationConfiguration object:

  $service_obj->Method(Att1 => { DisabledOnInitialization => $value, ..., DisabledOnInitialization => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::IoTEvents::InitializationConfiguration object:

  $result = $service_obj->Method(...);
  $result->Att1->DisabledOnInitialization

=head1 DESCRIPTION

Specifies the default alarm state. The configuration applies to all
alarms that were created based on this alarm model.

=head1 ATTRIBUTES


=head2 B<REQUIRED> DisabledOnInitialization => Bool

The value must be C<TRUE> or C<FALSE>. If C<FALSE>, all alarm instances
created based on the alarm model are activated. The default value is
C<TRUE>.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::IoTEvents>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

