package Treex::Core::Node::P;
BEGIN {
  $Treex::Core::Node::P::VERSION = '0.05222';
}
use Moose;
use Treex::Core::Common;
extends 'Treex::Core::Node';

sub get_pml_type_name {
    my ($self) = @_;

    if ( $self->is_root() or $self->get_attr('phrase') ) {
        return 'p-nonterminal.type';
    }
    elsif ( $self->get_attr('tag') ) {
        return 'p-terminal.type';
    }
    else {
        return;
    }
}

# Nodes on the p-layer have no ordering attribute.
# (It is not needed, trees are projective,
#  the order is implied by the ordering of siblings.)
override 'get_ordering_value' => sub {
    my ($self) = @_;
    return;
};

1;

__END__

=encoding utf-8

=head1 NAME

Treex::Core::Node::P

=head1 VERSION

version 0.05222

=head1 DESCRIPTION

A node for storing phrase structure (constituency) trees.


=head1 AUTHOR

Martin Popel <popel@ufal.mff.cuni.cz>

=head1 COPYRIGHT AND LICENSE

Copyright © 2011 by Institute of Formal and Applied Linguistics, Charles University in Prague

This module is free software; you can redistribute it and/or modify it under the same terms as Perl itself.