# This file was automatically generated by SWIG
package perliso9660;
require Exporter;
require DynaLoader;
@ISA = qw(Exporter DynaLoader);
package perliso9660c;
bootstrap perliso9660;
package perliso9660;
@EXPORT = qw( );

# ---------- BASE METHODS -------------

package perliso9660;

sub TIEHASH {
    my ($classname,$obj) = @_;
    return bless $obj, $classname;
}

sub CLEAR { }

sub FIRSTKEY { }

sub NEXTKEY { }

sub FETCH {
    my ($self,$field) = @_;
    my $member_func = "swig_${field}_get";
    $self->$member_func();
}

sub STORE {
    my ($self,$field,$newval) = @_;
    my $member_func = "swig_${field}_set";
    $self->$member_func($newval);
}

sub this {
    my $ptr = shift;
    return tied(%$ptr);
}


# ------- FUNCTION WRAPPERS --------

package perliso9660;

*cdio_read_sectors = *perliso9660c::cdio_read_sectors;
*cdio_eject_media_drive = *perliso9660c::cdio_eject_media_drive;
*open_iso = *perliso9660c::open_iso;
*open_ext = *perliso9660c::open_ext;
*open_fuzzy = *perliso9660c::open_fuzzy;
*iso9660_open_fuzzy_ext = *perliso9660c::iso9660_open_fuzzy_ext;
*ifs_fuzzy_read_superblock = *perliso9660c::ifs_fuzzy_read_superblock;
*close = *perliso9660c::close;
*seek_read = *perliso9660c::seek_read;
*fs_read_pvd = *perliso9660c::fs_read_pvd;
*ifs_read_pvd = *perliso9660c::ifs_read_pvd;
*fs_read_superblock = *perliso9660c::fs_read_superblock;
*ifs_read_superblock = *perliso9660c::ifs_read_superblock;
*set_dtime = *perliso9660c::set_dtime;
*set_ltime = *perliso9660c::set_ltime;
*get_dtime = *perliso9660c::get_dtime;
*get_ltime = *perliso9660c::get_ltime;
*is_dchar = *perliso9660c::is_dchar;
*is_achar = *perliso9660c::is_achar;
*name_translate = *perliso9660c::name_translate;
*name_translate_ext = *perliso9660c::name_translate_ext;
*strncpy_pad = *perliso9660c::strncpy_pad;
*dirname_valid_p = *perliso9660c::dirname_valid_p;
*pathname_isofy = *perliso9660c::pathname_isofy;
*pathname_valid_p = *perliso9660c::pathname_valid_p;
*fs_find_lsn = *perliso9660c::fs_find_lsn;
*fs_stat = *perliso9660c::fs_stat;
*fs_stat_translate = *perliso9660c::fs_stat_translate;
*ifs_stat = *perliso9660c::ifs_stat;
*ifs_stat_translate = *perliso9660c::ifs_stat_translate;
*fs_readdir = *perliso9660c::fs_readdir;
*ifs_readdir = *perliso9660c::ifs_readdir;
*get_application_id = *perliso9660c::get_application_id;
*ifs_get_application_id = *perliso9660c::ifs_get_application_id;
*get_joliet_level = *perliso9660c::get_joliet_level;
*get_dir_len = *perliso9660c::get_dir_len;
*iso9660_dir_to_name = *perliso9660c::iso9660_dir_to_name;
*get_preparer_id = *perliso9660c::get_preparer_id;
*ifs_get_preparer_id = *perliso9660c::ifs_get_preparer_id;
*get_publisher_id = *perliso9660c::get_publisher_id;
*ifs_get_publisher_id = *perliso9660c::ifs_get_publisher_id;
*get_pvd_type = *perliso9660c::get_pvd_type;
*get_pvd_id = *perliso9660c::get_pvd_id;
*get_pvd_space_size = *perliso9660c::get_pvd_space_size;
*get_pvd_block_size = *perliso9660c::get_pvd_block_size;
*get_pvd_version = *perliso9660c::get_pvd_version;
*get_system_id = *perliso9660c::get_system_id;
*ifs_get_system_id = *perliso9660c::ifs_get_system_id;
*get_root_lsn = *perliso9660c::get_root_lsn;
*get_volume_id = *perliso9660c::get_volume_id;
*ifs_get_volume_id = *perliso9660c::ifs_get_volume_id;
*get_volumeset_id = *perliso9660c::get_volumeset_id;
*ifs_get_volumeset_id = *perliso9660c::ifs_get_volumeset_id;
*pathtable_init = *perliso9660c::pathtable_init;
*pathtable_get_size = *perliso9660c::pathtable_get_size;
*pathtable_l_add_entry = *perliso9660c::pathtable_l_add_entry;
*pathtable_m_add_entry = *perliso9660c::pathtable_m_add_entry;
*set_evd = *perliso9660c::set_evd;
*is_xa = *perliso9660c::is_xa;

# ------- VARIABLE STUBS --------

package perliso9660;

*VERSION_NUM = *perliso9660c::VERSION_NUM;
*INVALID_LBA = *perliso9660c::INVALID_LBA;
*INVALID_LSN = *perliso9660c::INVALID_LSN;
*CD_FRAMESIZE = *perliso9660c::CD_FRAMESIZE;
*CD_FRAMESIZE_RAW = *perliso9660c::CD_FRAMESIZE_RAW;
*ISO_BLOCKSIZE = *perliso9660c::ISO_BLOCKSIZE;
*M2F2_SECTOR_SIZE = *perliso9660c::M2F2_SECTOR_SIZE;
*M2RAW_SECTOR_SIZE = *perliso9660c::M2RAW_SECTOR_SIZE;
*CDIO_READ_MODE_AUDIO = *perliso9660c::CDIO_READ_MODE_AUDIO;
*CDIO_READ_MODE_M1F1 = *perliso9660c::CDIO_READ_MODE_M1F1;
*CDIO_READ_MODE_M1F2 = *perliso9660c::CDIO_READ_MODE_M1F2;
*CDIO_READ_MODE_M2F1 = *perliso9660c::CDIO_READ_MODE_M2F1;
*CDIO_READ_MODE_M2F2 = *perliso9660c::CDIO_READ_MODE_M2F2;
*PVD_SECTOR = *perliso9660c::PVD_SECTOR;
*EVD_SECTOR = *perliso9660c::EVD_SECTOR;
*LEN_ISONAME = *perliso9660c::LEN_ISONAME;
*MAX_SYSTEM_ID = *perliso9660c::MAX_SYSTEM_ID;
*MAX_ISONAME = *perliso9660c::MAX_ISONAME;
*MAX_PREPARER_ID = *perliso9660c::MAX_PREPARER_ID;
*MAX_ISOPATHNAME = *perliso9660c::MAX_ISOPATHNAME;
*FILE = *perliso9660c::FILE;
*EXISTENCE = *perliso9660c::EXISTENCE;
*DIRECTORY = *perliso9660c::DIRECTORY;
*ASSOCIATED = *perliso9660c::ASSOCIATED;
*RECORD = *perliso9660c::RECORD;
*PROECTION = *perliso9660c::PROECTION;
*DRESERVED1 = *perliso9660c::DRESERVED1;
*DRESERVED2 = *perliso9660c::DRESERVED2;
*MULTIEXTENT = *perliso9660c::MULTIEXTENT;
*VD_BOOT_RECORD = *perliso9660c::VD_BOOT_RECORD;
*VD_PRIMARY = *perliso9660c::VD_PRIMARY;
*VD_SUPPLEMENTARY = *perliso9660c::VD_SUPPLEMENTARY;
*VD_PARITION = *perliso9660c::VD_PARITION;
*VD_END = *perliso9660c::VD_END;
*MAX_PUBLISHER_ID = *perliso9660c::MAX_PUBLISHER_ID;
*MAX_APPLICATION_ID = *perliso9660c::MAX_APPLICATION_ID;
*MAX_VOLUME_ID = *perliso9660c::MAX_VOLUME_ID;
*MAX_VOLUMESET_ID = *perliso9660c::MAX_VOLUMESET_ID;
*STANDARD_ID = *perliso9660c::STANDARD_ID;
*NOCHECK = *perliso9660c::NOCHECK;
*SEVEN_BIT = *perliso9660c::SEVEN_BIT;
*ACHARS = *perliso9660c::ACHARS;
*DCHARS = *perliso9660c::DCHARS;
*EXTENSION_JOLIET_LEVEL1 = *perliso9660c::EXTENSION_JOLIET_LEVEL1;
*EXTENSION_JOLIET_LEVEL2 = *perliso9660c::EXTENSION_JOLIET_LEVEL2;
*EXTENSION_JOLIET_LEVEL3 = *perliso9660c::EXTENSION_JOLIET_LEVEL3;
*EXTENSION_ROCK_RIDGE = *perliso9660c::EXTENSION_ROCK_RIDGE;
*EXTENSION_HIGH_SIERRA = *perliso9660c::EXTENSION_HIGH_SIERRA;
*EXTENSION_ALL = *perliso9660c::EXTENSION_ALL;
*EXTENSION_NONE = *perliso9660c::EXTENSION_NONE;
*EXTENSION_JOLIET = *perliso9660c::EXTENSION_JOLIET;

=pod

=head1 NAME

perliso9660 - lower-level wrappper to libiso9660, CD Input and Control library'sISO9660 library

=head1 SYNOPSIS

This is fairly straight-forward wrapper around the C library libiso9660
Although this is perfectly usable on its own, it is expected that the
Object-Oriented interface L<Device::Cdio::ISO9660> is what most people will
want to use. 

There are various constants that are defined here.

=head1 DESCRIPTION

Encapsulation is done in two parts. The lower-level Perl
interface is called perlcdio (this file) and is generated via SWIG.

=head1 CONSTANTS

=over 4

=item ISO_BLOCKSIZE

Number of bytes in an ISO 9660 block (2048)

=item PVD_SECTOR

Sector of Primary Volume Descriptor

=item EVD_SECTOR

Sector of End Volume Descriptor

=item LEN_ISONAME

Size in bytes of the filename  portion + null byte

=item MAX_SYSTEM_ID

Maximum number of characters in a system id

=item MAX_ISONAME

Size in bytes of the filename portion + null byte.

=item MAX_PREPARER_ID

Maximum number of characters in a preparer id.

=item MAX_ISOPATHNAME

Maximum number of characters in the entire ISO 9660 filename.

=item FILE

Not really a flag but the lack of one.

=item EXISTENCE

Do not make existence known (hidden).

=item DIRECTORY

This file is a directory.

=item ASSOCIATED

This file is an associated file

=item RECORD

Record format in extended attr. if not set.

=item PROTECTION

No read/execute permission in extended attribute.

=item DRESERVED1

Reserved bit 5.

=item DRESERVED2

Reserved bit 6

=item MULTIEXTENT

Not the final entry of a multi-extent file.

=item VD_BOOT_RECORD

CD is bootable

=item VD_PRIMARY

Primary Volume descriptor which must be in any ISO-9660

=item VD_SUPPLEMENTARY

(optional) Supplimentary Volume Descriptor. But used by Joliet, for
example.

=item VD_PARITION

Indicates a partition of a CD.

=item VD_END

=item MAX_PUBLISHER_ID

Maximum number of characters in a publisher id.

=item MAX_APPLICATION_ID

Maximum number of characters in an application id.

=item MAX_VOLUME_ID

Maximum number of characters in a volume id.

=item MAX_VOLUMESET_ID

Maximum number of characters in a volume-set id.

=item STANDARD_ID

String inside frame which identifies an ISO 9660 filesystem. This
string is the "id" field of an iso9660_pvd_t or an iso9660_svd_t.

=item NOCHECK

Enumeration for don't check in strncpy_pad.

=item SEVEN_BIT

Enumeration in strncpy_pad for checking entry has only 7-bit characters.


=item ACHARS

Enumeration in strncpy_pad for checking entry has only ACHARs.

=item DCHARS

Enumeration in strncpy_pad for checking entry has only DCHARs.

=item EXTENSION_JOLIET_LEVEL1

Use Joliet Level 1.

=item EXTENSION_JOLIET_LEVEL2

Use Joliet Level 2.

=item EXTENSION_JOLIET_LEVEL3

Use Joliet Level 3

=item EXTENSION_ROCK_RIDGE

Use Rock-Ridge Extensions.

=item EXTENSION_HIGH_SIERRA

Use High-Sierra Extensions.

=item EXTENSION_ALL

Use any of the above extensions.

=item EXTENSION_NONE

Use none of the above extensions.

=item EXTENSION_JOLIET

Use any Joliet Extension available.

=back

=head1 SUBROUTINES

=head2 Input Output

=head3 open

Open an ISO 9660 image for reading. Maybe in the future we will have
mode. undef is returned on error.

=head3 open_ext

Open an ISO 9660 image for reading allowing various ISO 9660
xtensions.  Maybe in the future we will have a mode. undef is
eturned on error.

=head3 open_fuzzy

Open an ISO 9660 image for reading with some tolerence for positioning
of the ISO9660 image. We scan for $perliso9660::ISO_STANDARD_ID and
use that to set he eventual offset to adjust by (as long as that is <=
i_fuzz).

Maybe in the future we will have a mode. undef is returned on error.

See also open

=head3 open_fuzzy_ext

Open an ISO 9660 image for reading with some tolerence for positioning
of the ISO9660 image. We scan for ISO_STANDARD_ID and use that to set
the eventual offset to adjust by (as long as that is <= i_fuzz).

Maybe in the future we will have a mode. undef is returned on error.

=head3 ifs_fuzzy_read_superblock

Read the Super block of an ISO 9660 image but determine framesize
and datastart and a possible additional offset. Generally here we are
not reading an ISO 9660 image but a CD-Image which contains an ISO 9660
filesystem.

=head3 close

Close previously opened ISO 9660 image.
1 is unconditionally returned. If there was an error 0 would
be returned.

=head3 seek_read

Seek to a position and then read n bytes. (buffer, size) are is returned.

=head3 fs_read_pvd

Read the Primary Volume Descriptor for a CD.
1 is returned if read, and 0 if there was an error.

=head3 ifs_read_pvd

Read the Primary Volume Descriptor for an ISO 9660 image.
1 is returned if read, and 0 if there was an error.

=head3 _fs_read_superblock

Read the Super block of an ISO 9660 image. This is the 
Primary Volume Descriptor (PVD) and perhaps a Supplemental Volume 
Descriptor if (Joliet) extensions are acceptable.

=head3 ifs_read_superblock

Read the Super block of an ISO 9660 image. This is the 
Primary Volume Descriptor (PVD) and perhaps a Supplemental Volume 
Descriptor if (Joliet) extensions are acceptable.

=head2 Time Conversion

=head3 set_dtime

Set time in format used in ISO 9660 directory index record
from a Unix time structure.


=head3 set_ltime

Set "long" time in format used in ISO 9660 primary volume descriptor
from a Unix time structure.

=head3 get_dtime 

Get Unix time structure from format use in an ISO 9660 directory index 
record. Even though tm_wday and tm_yday fields are not explicitly in
idr_date, they are calculated from the other fields.

If tm is to reflect the localtime, set "use_localtime" 1, otherwise
tm will reported in GMT.

=head3 get_ltime

Get "long" time in format used in ISO 9660 primary volume descriptor
from a Unix time structure. 

=head2 Character Classification and String Manipulation

=head3 is_dchar

Return 1 if c (an int) is a DCHAR - a character that can appear in an an
ISO-9600 level 1 directory name. These are the ASCII capital
letters A-Z, the digits 0-9 and an underscore.

=head3 is_achar

=head3 name_translate

Convert an ISO-9660 file name that stored in a directory entry into 
what's usually listed as the file name in a listing.
wercase name, and remove trailing ;1's or .;1's and
turn the other ;'s into version numbers.

=head3 name_translate_ext

Convert an ISO-9660 file name that stored in a directory entry into
what's usually listed as the file name in a listing.  Lowercase
name if no Joliet Extension interpretation. Remove trailing ;1's or
.;1's and turn the other ;'s into version numbers.

=head3 strncpy_pad 

Pad string src with spaces to size len and copy this to dst. If len is
less than the length of src, dst will be truncated to the first len
characters of src.

src can also be scanned to see if it contains only ACHARs, DCHARs,
7-bit ASCII chars depending on the enumeration _check.

In addition to getting changed, dst is the return value.  Note: this
string might not be undef terminated.

=head2 File and Directory Names 

=head3 dirname_valid_p

Check that psz_path is a valid ISO-9660 directory name.

A valid directory name should not start out with a slash (/), 
dot (.) or null byte, should be less than 37 characters long, 
have no more than 8 characters in a directory component 
which is separated by a /, and consist of only DCHARs. 

1 is returned if psz_path is valid.

=head3 pathname_isofy

Take psz_path and a version number and turn that into a ISO-9660
pathname.  (That is just the pathname followd by ";" and the version
number. For example, mydir/file.ext -> MYDIR/FILE.EXT;1 for version
1. The resulting ISO-9660 pathname is returned.

=head3 pathname_valid_p

Check that psz_path is a valid ISO-9660 pathname.  

A valid pathname contains a valid directory name, if one appears and
the filename portion should be no more than 8 characters for the
file prefix and 3 characters in the extension (or portion after a
dot). There should be exactly one dot somewhere in the filename
portion and the filename should be composed of only DCHARs.
  
1 is returned if psz_path is valid.

=head3 fs_find_lsn

Given a directory pointer, find the filesystem entry that contains
lsn and return information about it.

Returns stat_t of entry if we found lsn, or undef otherwise.

=head3 ifs_find_lsn

Given a directory pointer, find the filesystem entry that contains
lsn and return information about it.

Returns stat_t of entry if we found lsn, or undef otherwise.

=head3 fs_stat

Return file status for psz_path. undef is returned on error.

=head3 fs_stat_translate

Return file status for path name psz_path. undef is returned on error.
pathname version numbers in the ISO 9660 name are dropped, i.e. ;1
is removed and if level 1 ISO-9660 names are lowercased.

=head3 ifs_stat

Return file status for pathname. undef is returned on error.

=head3 ifs_stat_translate

Return file status for path name psz_path. undef is returned on
error.  pathname version numbers in the ISO 9660 name are dropped,
i.e. ;1 is removed and if level 1 ISO-9660 names are lowercased.


=head3 fs_readdir

Read psz_path (a directory) and return a list of iso9660_stat_t
pointers for the files inside that directory. The caller must free the
returned result.

=head3 ifs_readdir

Read psz_path (a directory) and return a list of iso9660_stat_t
pointers for the files inside that directory. The caller must free
the returned result.

=head3 get_dir_len

Return the directory name stored in the iso9660_dir_t
  
A string is allocated: the caller must deallocate.

=head3 dir_to_name
  
=head3 get_posix_filemode

Returns a POSIX mode for a given p_iso_dirent.

=head2 Primary Volume Descriptor Routines

=head3 get_application_id

Return the PVD's application ID.

undef is returned if there is some problem in getting this. 

=head3 ifs_get_application_id

Get the application ID.  psz_app_id is set to undef if there
is some problem in getting this and 0 is returned.

=head3 get_preparer_id

Return a string containing the preparer id with trailing
blanks removed.

=head3 ifs_get_preparer_id

Get the preparer ID.  psz_preparer_id is set to undef if there
is some problem in getting this and 0 is returned.
  
=head3 get_publisher_id

Return a string containing the PVD's publisher id with trailing
blanks removed.

=head3 ifs_get_publisher_id

Get the publisher ID.  psz_publisher_id is set to undef if there
is some problem in getting this and 0 is returned.

=head3 get_pvd_type
  
=head3 get_pvd_id

=head3 get_pvd_space_size

=head3 get_pvd_block_size

=head3 get_pvd_version

Return the primary volume id version number (of pvd).
If there is an error 0 is returned. 

=head3 get_system_id

Return a string containing the PVD's system id with trailing
blanks removed.

=head3 ifs_get_system_id

Get the system ID.  psz_system_id is set to undef if there
is some problem in getting this and 0 is returned.

=head3 get_root_lsn

Return the LSN of the root directory for pvd.
If there is an error CDIO_INVALID_LSN is returned. 

=head3 get_volume_id

Return the PVD's volume ID.

=head3 ifs_get_volume_id

Get the system ID.  psz_system_id is set to undef if there
s some problem in getting this and 0 is returned.

=head3 get_volumeset_id

Return the PVD's volumeset ID.
undef is returned if there is some problem in getting this. 

=head3 ifs_get_volumeset_id

Get the systemset ID.  psz_systemset_id is set to undef if there
is some problem in getting this and 0 is returned.

=head2 Path Table Routines
  
=head3 iso9660_pathtable_init

Zero out pathable. Do this first.
  
=head3 pathtable_get_size 
  
=head3 pathtable_l_add_entry
  
=head3 pathtable_m_add_entry 
  
=head3 set_evd

=head2 Miscellaneous

=head3 get_joliet_level

Return the Joliet level recognized for p_iso.

=head3 ifs_is_xa

Return 1 if ISO 9660 image has extended attrributes (XA).

=head1 METHODS

=head2 this

This seems to be an artifact of SWIG. 

=head1 SEE ALSO

L<http://www.gnu.org/software/libcdio> has documentation on
libcdio including the a manual and the API via doxygen.

=head1 AUTHORS

Rocky Bernstein C<< <rocky at cpan.org> >>.

=head1 COPYRIGHT

Copyright (C) 2006 Rocky Bernstein <rocky@cpan.org>

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

=cut
1;
