### 03-submission.t #############################################################################
# This file tests the simple calls to the job submit function

### Includes ######################################################################################

# Safe Perl
use warnings;
use strict;
use Carp;

use Test::More tests => 5;
use Test::Exception;
use Test::File::Contents;
use MooseX::Types::Path::Class qw(Dir File);
use File::Temp;
use File::pushd;
use File::ShareDir;
use HPCI;

use FindBin;
$ENV{PATH} = "$FindBin::Bin/../bin:$ENV{PATH}";

### Tests #################################################################################

-d 'scratch' or mkdir 'scratch';
my $tmp_dir = File::Temp->newdir( TEMPLATE => 'TEST.XXXX', DIR => 'scratch', CLEANUP => 0 );
print( "Testing in " . $tmp_dir->dirname . "\n" );
chdir $tmp_dir->dirname;
my $pre_name = 'T_Submission_';
my $inst = 0;
my $name = "$pre_name$inst";

my $cluster = $ENV{HPCI_CLUSTER} || 'uni';

{
	++$inst;
	$name = "$pre_name$inst";
	mkdir $name;
	my $dir_handle = pushd( $name );
    my $group = HPCI->group( cluster => $cluster, base_dir => '.', name => $name );

    my $num_jobs = 3;

    foreach my $i ( 0 .. $num_jobs ) {
        $group->stage(
            command => "echo \"yo, s'up $i\" >testfile$i.txt",
            name    => "otherjob$i",
        );
    }

    my $results = $group->execute();

	my $cnt = 0;
    while ( my ( $name, $stats ) = each %$results ) {
        like( $name, qr{^otherjob\d$}, 'result name matches' );
		++$cnt;
    }
    is( $cnt, $num_jobs + 1, 'Number of finished jobs is correct' );
}

done_testing();

# system( "rm -rf $tmp_dir" ) unless $ENV{KEEP_TMP};
