### -*- mode: perl; -*-

use Test::More;

use PDF::FDF::Simple;
use File::Temp qw( tempfile );

use Data::Dumper;
use Parse::RecDescent;
use strict;
use warnings;

plan tests => 2;

################## tests ##################


my ($fdf_fh, $fdf_fname) = tempfile (
                                     "/tmp/XXXXXX",
                                     SUFFIX => '.fdf',
                                     UNLINK => 1
                                    );

my $fdf = new PDF::FDF::Simple ({ 'filename'     => $fdf_fname });
$fdf->content ({
                'name'                 => 'Blubberman',
                'organisation'         => 'Misc Stuff Ltd.',
                'dotted.field.name'    => 'Hello world.',
                'language.radio.value' => 'French',
                'my.checkbox.value'    => 'On'
               });
ok (($fdf->save), 'save');

my $fdf2 = new PDF::FDF::Simple ({ 'filename'     => './t/simple.fdf' });

my $erg = $fdf2->load;
ok (($erg->{'oeavoba.angebotseroeffnung.anschrift'} eq 'Lndliche Neuordnung in Sachsen TG Schnwlkau I, Lptitzer Str. 39, 04808 Wurzen'),
    "load");

