/*
 * Decompiled with CFR 0.152.
 */
package opennlp.common.util;

import java.util.ArrayList;
import java.util.StringTokenizer;

public final class PerlHelp {
    public static String[] getParagraphs(String text) {
        StringTokenizer st = new StringTokenizer(text, "\n", true);
        ArrayList<String> pars = new ArrayList<String>();
        StringBuffer nextPar = new StringBuffer();
        boolean prevWasReturn = false;
        while (st.hasMoreTokens()) {
            String s = st.nextToken();
            if (s.equals("\n")) {
                if (prevWasReturn) {
                    prevWasReturn = false;
                    pars.add(nextPar.toString());
                    nextPar = new StringBuffer();
                } else {
                    prevWasReturn = true;
                }
            } else {
                prevWasReturn = false;
            }
            nextPar.append(s);
        }
        pars.add(nextPar.toString());
        String[] parsArray = new String[pars.size()];
        pars.toArray(parsArray);
        return parsArray;
    }

    public static boolean hasCap(String s) {
        char[] ca = s.toCharArray();
        int i = 0;
        while (i < ca.length) {
            if (Character.isUpperCase(ca[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static boolean hasNum(String s) {
        char[] ca = s.toCharArray();
        int i = 0;
        while (i < ca.length) {
            if (Character.isDigit(ca[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static boolean isAlphanumeric(String s) {
        char[] ca = s.toCharArray();
        int i = 0;
        while (i < ca.length) {
            if (!Character.isLetterOrDigit(ca[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static boolean isPunctuation(String s) {
        char[] ca = s.toCharArray();
        int i = 0;
        while (i < ca.length) {
            if (Character.isLetterOrDigit(ca[i]) || Character.isWhitespace(ca[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static int nextSpaceIndex(StringBuffer sb, int seek, int lastIndex) {
        ++seek;
        while (seek < lastIndex) {
            char c = sb.charAt(seek);
            if (c == ' ' || c == '\n') {
                while (sb.length() > seek + 1 && sb.charAt(seek + 1) == ' ') {
                    ++seek;
                }
                return seek;
            }
            ++seek;
        }
        return lastIndex;
    }

    public static int previousSpaceIndex(StringBuffer sb, int seek) {
        --seek;
        while (seek > 0) {
            if (sb.charAt(seek) == ' ') {
                while (seek > 0 && sb.charAt(seek - 1) == ' ') {
                    --seek;
                }
                return seek;
            }
            --seek;
        }
        return 0;
    }

    public static String[] split(String s) {
        return PerlHelp.split(s, " ");
    }

    public static String[] split(String s, String delim) {
        StringTokenizer st = new StringTokenizer(s, delim);
        String[] toks = new String[st.countTokens()];
        int i = 0;
        while (st.hasMoreTokens()) {
            toks[i] = st.nextToken();
            ++i;
        }
        return toks;
    }

    public static String[] splitByWhitespace(String s) {
        return PerlHelp.split(s, " \t\n\r\f");
    }
}

