#!/usr/bin/perl

package eBay::API::XML::DataType::ScheduleType;

use strict;
use warnings;  

##########################################################################
#
# Module: ............... <user defined location>eBay/API/XML
# File: ................. ScheduleType.pm
# Generated by: ......... genEBayApiDataTypes.pl
# Last Generated: ....... 08/24/2008 16:44
# API Release Number: ... 579
#
##########################################################################  

=head1 NAME

eBay::API::XML::DataType::ScheduleType

=head1 DESCRIPTION

Sellers create live auction catalogs and schedule their live auction events by using
the eBay Live Auctions Web site user interface. The seller can create a catalog in
the Live Auctions system several months before a sale.



=head1 SYNOPSIS

=cut


=head1 INHERITANCE

eBay::API::XML::DataType::ScheduleType inherits from the L<eBay::API::XML::BaseDataType> class

=cut

use eBay::API::XML::BaseDataType;
our @ISA = ("eBay::API::XML::BaseDataType");



my @gaProperties = ( [ 'ScheduleID', 'xs:int', '', '', '' ]
	, [ 'ScheduleTime', 'xs:dateTime', '', '', '' ]
                    );
push @gaProperties, @{eBay::API::XML::BaseDataType::getPropertiesList()};

my @gaAttributes = ( 
                    );
push @gaAttributes, @{eBay::API::XML::BaseDataType::getAttributesList()};

=head1 Subroutines:

=cut

sub new {
  my $classname = shift;
  my %args = @_;
  my $self = $classname->SUPER::new(%args);
  return $self;
}

sub isScalar {
   return 0; 
}



=head2 setScheduleID()

Identifier for an event schedule in the seller's Live Auctions catalog.

#    Argument: 'xs:int'

=cut

sub setScheduleID {
  my $self = shift;
  $self->{'ScheduleID'} = shift
}

=head2 getScheduleID()

  Calls: GetLiveAuctionCatalogDetails
  Returned: Conditionally

#    Returns: 'xs:int'

=cut

sub getScheduleID {
  my $self = shift;
  return $self->{'ScheduleID'};
}


=head2 setScheduleTime()

Date and time that the sale schedule starts.

#    Argument: 'xs:dateTime'

=cut

sub setScheduleTime {
  my $self = shift;
  $self->{'ScheduleTime'} = shift
}

=head2 getScheduleTime()

  Calls: GetLiveAuctionCatalogDetails
  Returned: Conditionally

#    Returns: 'xs:dateTime'

=cut

sub getScheduleTime {
  my $self = shift;
  return $self->{'ScheduleTime'};
}





##  Attribute and Property lists
sub getPropertiesList {
   my $self = shift;
   return \@gaProperties;
}

sub getAttributesList {
   my $self = shift;
   return \@gaAttributes;
}



1;   
