# Before `make install' is performed this script should be runnable with
# `make test'. After `make install' it should work as `perl VMS-CMS.t'

#########################

# change 'tests => 2' to 'tests => last_test_to_print';

use Test::More tests => 5;
use File::Spec;

BEGIN { use_ok('VMS::CMS') };


my $fail = 0;
foreach my $constname (qw(
	CMS_K_ACCEPT CMS_K_ACL_CLASS CMS_K_ACL_COMMAND CMS_K_ACL_ELEMENT
	CMS_K_ACL_GROUP CMS_K_ACL_LIBRARY CMS_K_AFTER CMS_K_BEFORE CMS_K_CANCEL
	CMS_K_MARK CMS_K_REJECT CMS_K_REVIEW CMS_K_SUPERSEDE CMS_M_ELEMENT_DIF
	CMS_M_GENERATIONAL_DIF CMS_M_IGNORE_CASE CMS_M_IGNORE_FIRST_VARIANT
	CMS_M_IGNORE_FORM CMS_M_IGNORE_HISTORY CMS_M_IGNORE_LEAD
	CMS_M_IGNORE_NOTES CMS_M_IGNORE_SPACE CMS_M_IGNORE_TRAIL
	CMS_M_VARIANT_DIF CMS__ABSTIM CMS__ACCEPTANCES CMS__ACCEPTED
	CMS__ACCVIORD CMS__ACCVIOWT CMS__ALL CMS__ALPHACHAR CMS__ALRDYEXISTS
	CMS__ALRDYINCLS CMS__ALRDYINGRP CMS__ALRDYMARKED CMS__ANNOTATED
	CMS__ANNOTATIONS CMS__ANNSIGNAL CMS__ARGCONFLICT CMS__ARGCOUNTERR
	CMS__AUTOREC CMS__AUTORECSUC CMS__BADBUG CMS__BADCALL CMS__BADCRC
	CMS__BADCRETIME CMS__BADFORMAT CMS__BADLENSTR CMS__BADLIB CMS__BADLST
	CMS__BADLSTSTR CMS__BADORDSTR CMS__BADPTR CMS__BADREF CMS__BADREFHDR
	CMS__BADSTRING CMS__BADTYPSTR CMS__BADVERSION CMS__BADVERSTR
	CMS__BCKPTRSTR CMS__BUG CMS__CANCELATIONS CMS__CANCELED
	CMS__CLASSGENEXP CMS__CMPSIGNAL CMS__CNTSTR CMS__COMPARED CMS__CONCLS
	CMS__CONCURRENT CMS__CONELE CMS__CONFIRM CMS__CONFLICTS CMS__CONGRP
	CMS__CONHIS CMS__CONRES CMS__CONTROLC CMS__CONVERTED CMS__CONVERTLIB
	CMS__CONVNOTNEC CMS__COPIED CMS__COPIES CMS__CREATED CMS__CREATES
	CMS__DEFAULTDIR CMS__DELETED CMS__DELETIONS CMS__DIFFCLASS
	CMS__DIFFERENT CMS__DUPEDF CMS__DUPREF CMS__EDFINWRONGDIR CMS__EDFMISS
	CMS__ELEEXISTS CMS__ELEEXP CMS__ELEMULTRES CMS__ELEXPIGN CMS__ENDOFLIST
	CMS__ENDPTRSTR CMS__EOF CMS__ERRACCEPTANCES CMS__ERRANNOTATIONS
	CMS__ERRCANCELATIONS CMS__ERRCLOSE CMS__ERRCOPIES CMS__ERRCREATES
	CMS__ERRDELETIONS CMS__ERRELEHIS CMS__ERREMOVALS CMS__ERREPLACEMENTS
	CMS__ERRESERVATIONS CMS__ERRETRIEVALS CMS__ERRFETCHES
	CMS__ERRGENDELETIONS CMS__ERRHISLINE CMS__ERRINSERTIONS CMS__ERRMARKS
	CMS__ERRMODACLS CMS__ERRMODIFIES CMS__ERRPAREXP CMS__ERRREJECTIONS
	CMS__ERRREVIEWS CMS__ERRUNRESERVES CMS__ERRVER2 CMS__ERRVERARC
	CMS__ERRVERCLS CMS__ERRVERCMD CMS__ERRVERCON CMS__ERRVEREDFS
	CMS__ERRVERELE CMS__ERRVERFRE CMS__ERRVERGEN CMS__ERRVERGRP
	CMS__ERRVERREFS CMS__ERRVERRES CMS__ERRVERSTR CMS__EXCLUDE CMS__EXIT
	CMS__EXTENDEDLIB CMS__EXTFOUND CMS__FACILITY CMS__FETCHED CMS__FETCHES
	CMS__FILEXISTS CMS__FILINUSE CMS__FIXCRC CMS__FIXHDR CMS__FREBLKCON
	CMS__GENCREATED CMS__GENDELETED CMS__GENDELETIONS CMS__GENEXISTS
	CMS__GENINSERTED CMS__GENMULTRES CMS__GENNOINSERT CMS__GENNOREMOVE
	CMS__GENNOTANC CMS__GENNOTFOUND CMS__GENNOTRES CMS__GENRECSIZE
	CMS__GENREMOVED CMS__GENRESREV CMS__GENTOODEEP CMS__GROUPEXP
	CMS__HASFILES CMS__HASMEMBERS CMS__HISNOTSTM CMS__HISTDEL
	CMS__IDENTCLASS CMS__IDENTICAL CMS__IDENTNOTRES CMS__ILLACT
	CMS__ILLARCREC CMS__ILLCHAR CMS__ILLCLSNAM CMS__ILLCONREC
	CMS__ILLDATREC CMS__ILLEGALDEV CMS__ILLELENAM CMS__ILLELEXP
	CMS__ILLFORMAT CMS__ILLGEN CMS__ILLGRPNAM CMS__ILLHIST CMS__ILLNAME
	CMS__ILLNOTE CMS__ILLOBJTYP CMS__ILLPAR CMS__ILLPOSVAL CMS__ILLREFDIR
	CMS__ILLRMK CMS__ILLSEQ CMS__ILLSUBTYP CMS__ILLVAR CMS__INCLIBVER
	CMS__INCRANGSPEC CMS__INSERTED CMS__INSERTIONS CMS__INUSE CMS__INVFETDB
	CMS__INVFIXMRS CMS__INVGENLRL CMS__INVLENGTH CMS__INVLIBDB
	CMS__INVOKERBK CMS__INVSTRDES CMS__ISMEMBER CMS__ISRESERVED
	CMS__LIBALRINLIS CMS__LIBINSLIS CMS__LIBIS CMS__LIBLISMOD
	CMS__LIBLISNOTMOD CMS__LIBNOTINLIS CMS__LIBREMLIS CMS__LIBSET
	CMS__LONGVARFOUND CMS__MANCONLIB CMS__MARKED CMS__MARKS CMS__MAXARG
	CMS__MERGECONFLICT CMS__MERGECOUNT CMS__MERGED CMS__MINARG
	CMS__MISBLKSTR CMS__MISMATCON CMS__MODACL CMS__MODACLS
	CMS__MODIFICATIONS CMS__MODIFIED CMS__MSGBUILD CMS__MSGCANCEL
	CMS__MSGCONTINUE CMS__MSGPOST CMS__MSGUPDATE CMS__MSSBLKSTR
	CMS__MULTCALL CMS__MULTPAR CMS__MUSTBEDIR CMS__MUSTBEFIL CMS__MUSTBEPOS
	CMS__MUTEXC CMS__NEEDNUMBER CMS__NEEDPERIOD CMS__NETNOTALL
	CMS__NOACCEPT CMS__NOACCESS CMS__NOACE CMS__NOALTDELETE CMS__NOANNOTATE
	CMS__NOBACKUP CMS__NOBCKPTR CMS__NOCANCEL CMS__NOCHANGES CMS__NOCLOSE
	CMS__NOCLS CMS__NOCMD CMS__NOCOMMALIST CMS__NOCOMPARE CMS__NOCONCUR
	CMS__NOCONFIRM CMS__NOCONRES CMS__NOCONVERT CMS__NOCOPY CMS__NOCREATE
	CMS__NODEFACL CMS__NODELACCESS CMS__NODELETE CMS__NODELETIONS
	CMS__NODELFUTURE CMS__NODELGEN1 CMS__NOEDFIWDREPAIR CMS__NOELE
	CMS__NOELEENT CMS__NOERRLOG CMS__NOEXTENDED CMS__NOEXTENDEDREF
	CMS__NOFETCH CMS__NOFILE CMS__NOGENBEFORE CMS__NOGENDELETED CMS__NOGENS
	CMS__NOGRP CMS__NOHIS CMS__NOHISNOTES CMS__NOHISPAR CMS__NOINPUT
	CMS__NOINSERT CMS__NOMARK CMS__NOMATCH CMS__NOMODACL CMS__NOMODARG
	CMS__NOMODIFY CMS__NOMOREPARAM CMS__NOOBJ CMS__NOOBJTYP CMS__NORECOVER
	CMS__NOREF CMS__NOREFDIR CMS__NOREFELE CMS__NOREJECT CMS__NOREMARK
	CMS__NOREMOVAL CMS__NOREPAIR CMS__NOREPBCKPTR CMS__NOREPCMD
	CMS__NOREPEDF CMS__NOREPGENLRL CMS__NOREPGENMRS CMS__NOREPLACE
	CMS__NOREPREF CMS__NOREPRO CMS__NOREPSEQDATA CMS__NORES
	CMS__NORESERVATION CMS__NORESNOCON CMS__NORESRO CMS__NORETRIEVE
	CMS__NOREV CMS__NOREVIEW CMS__NOREVPEND CMS__NOREVSPEND CMS__NORMAL
	CMS__NOSINCE CMS__NOSRCHLST CMS__NOSUPERSEDE CMS__NOTBYCMS
	CMS__NOTCMSLIB CMS__NOTCOMPLETED CMS__NOTCRELIB CMS__NOTDIRDES
	CMS__NOTESVALREQ CMS__NOTFOUND CMS__NOTLOGGED CMS__NOTNOREF
	CMS__NOTRESBYOU CMS__NOTSET CMS__NOTTHERE CMS__NOTWILD CMS__NOUNRESERVE
	CMS__NOVERIFY CMS__NOWLDCARD CMS__NULLARG CMS__NULLSTR CMS__NUMGENEXP
	CMS__OLDSYNTAX CMS__ONEPERIOD CMS__OPENARC CMS__OPENIN CMS__OPENIN1
	CMS__OPENIN2 CMS__OPENOUT CMS__OVERDRAFT CMS__POSVALREQ CMS__PROCEEDING
	CMS__QUALCONFLICT CMS__READERR CMS__READIN CMS__READONLY CMS__RECGRP
	CMS__RECNOTNEC CMS__RECOVERED CMS__REFMISMAT CMS__REFMISS
	CMS__REFREPAIR CMS__REJECTED CMS__REJECTIONS CMS__REMARK CMS__REMOVALS
	CMS__REMOVED CMS__REPAIRED CMS__REPBADLST CMS__REPBADTYP CMS__REPBCKPTR
	CMS__REPCMD CMS__REPCNTSTR CMS__REPDEL CMS__REPEDF CMS__REPENDPTR
	CMS__REPGENLRL CMS__REPGENMRS CMS__REPILLDATREC CMS__REPLACEMENTS
	CMS__REPMISBLK CMS__REPREF CMS__RESERVATIONS CMS__RESERVED
	CMS__RESERVEDBYYOU CMS__RETRIEVALS CMS__RETRIEVED CMS__REVIEWED
	CMS__REVIEWS CMS__REVPENDING CMS__SAMELINE CMS__SEQFAIL CMS__SEQMISMAT
	CMS__SEQUENCED CMS__SIZEMISMAT CMS__STARTHIS CMS__STOPPED
	CMS__SUPERSEDE CMS__SYSTIMDIF CMS__SYSTIMERR CMS__TIMEORDER
	CMS__TOODEEP CMS__TOOLONG CMS__TOOMANYLIBS CMS__TRUNCLST CMS__TRYAGNLAT
	CMS__UNDEFLIB CMS__UNFOUT CMS__UNRECTYPE CMS__UNRESERVED
	CMS__UNRESERVES CMS__UNSUPFRMT CMS__USERECOVER CMS__USEREPAIR
	CMS__USERERR CMS__USESETLIB CMS__VARINRANGE CMS__VARLETTER CMS__VER2
	CMS__VERARC CMS__VERCLS CMS__VERCMD CMS__VERCON CMS__VEREDF
	CMS__VEREDFERR CMS__VEREDFS CMS__VERELE CMS__VERFRE CMS__VERGRP
	CMS__VERIFIED CMS__VERILLDATREC CMS__VERLMTERR CMS__VERREF
	CMS__VERREFERR CMS__VERREFERRW CMS__VERREFS CMS__VERRES CMS__VERSTR
	CMS__WAITING CMS__WILDCONFLICT CMS__WILDMATCH CMS__WILDNEEDED
	CMS__WILDNOMATCH CMS__WILDVER CMS__WRITEERR CMS__ZEROADD CMS__ZLENBLK)) {
  next if (eval "my \$a = $constname; 1");
  if ($@ =~ /^Your vendor has not defined VMS::CMS macro $constname/) {
    print "# pass: $@";
  } else {
    print "# fail: $@";
    $fail = 1;
  }

}

ok( $fail == 0 , 'Constants' );
#########################

# Insert your test code below, the Test::More module is use()ed here so read
# its man page ( perldoc Test::More ) for help writing this test script.

my $ver = VMS::CMS::show_version();
ok( defined($ver) );
ok( ref($ver) eq "HASH" );
ok( exists($ver->{ABSOLUTE}) && exists($ver->{BRIEF}) && exists($ver->{FULL}) );
